/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.MissingReferenceException;
import com.liferay.portal.PortletIdException;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.PortletDataContextListener;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.AlwaysCurrentUserIdStrategy;
import com.liferay.portal.lar.CurrentUserIdStrategy;
import com.liferay.portal.lar.DeletionSystemEventImporter;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.LayoutImporter;
import com.liferay.portal.lar.PermissionImporter;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.model.StagedGroupedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.PortletPreferencesImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletItemLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.PortletPreferencesUtil;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetLinkLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetCategoryUtil;
import com.liferay.portlet.asset.service.persistence.AssetTagUtil;
import com.liferay.portlet.asset.service.persistence.AssetVocabularyUtil;
import com.liferay.portlet.expando.NoSuchTableException;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoTableLocalServiceUtil;
import com.liferay.portlet.expando.util.ExpandoConverterUtil;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.ratings.model.RatingsEntry;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.time.StopWatch;

public class PortletImporter {
    private static Log _log = LogFactoryUtil.getLog(PortletImporter.class);
    private DeletionSystemEventImporter _deletionSystemEventImporter = new DeletionSystemEventImporter();
    private Element _headerElement;
    private PermissionImporter _permissionImporter = new PermissionImporter();
    private Element _rootElement;

    public String importPortletData(PortletDataContext portletDataContext, String portletId, com.liferay.portal.model.PortletPreferences portletPreferences, Element portletDataElement) throws Exception {
        String portletData;
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet data for " + portletId + " because the portlet does not exist"));
            }
            return null;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null || portletDataHandler.isDataPortletInstanceLevel()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet data for " + portletId + " because the portlet does not have a " + "PortletDataHandler"));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Importing data for " + portletId));
        }
        com.liferay.portlet.PortletPreferencesImpl portletPreferencesImpl = null;
        if (portletPreferences != null) {
            portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)PortletPreferencesFactoryUtil.fromDefaultXML((String)portletPreferences.getPreferences());
        }
        if (Validator.isNull((String)(portletData = portletDataContext.getZipEntryAsString(portletDataElement.attributeValue("path"))))) {
            return null;
        }
        if ((portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)portletDataHandler.importData(portletDataContext, portletId, (PortletPreferences)portletPreferencesImpl, portletData)) == null) {
            return null;
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferencesImpl);
    }

    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws Exception {
        try {
            ExportImportThreadLocal.setPortletImportInProcess((boolean)true);
            this.doImportPortletInfo(userId, plid, groupId, portletId, parameterMap, file);
        }
        finally {
            ExportImportThreadLocal.setPortletImportInProcess((boolean)false);
            CacheUtil.clearCache();
            JournalContentUtil.clearCache();
            PermissionCacheUtil.clearCache();
        }
    }

    public MissingReferences validateFile(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws Exception {
        ZipReader zipReader = null;
        try {
            ExportImportThreadLocal.setPortletValidationInProcess((boolean)true);
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
            PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)layout.getCompanyId(), (long)groupId, parameterMap, null, (ZipReader)zipReader);
            this.validateFile(portletDataContext, portletId);
            MissingReferences missingReferences = ExportImportHelperUtil.validateMissingReferences((long)userId, (long)groupId, parameterMap, (File)file);
            Map dependencyMissingReferences = missingReferences.getDependencyMissingReferences();
            if (!dependencyMissingReferences.isEmpty()) {
                throw new MissingReferenceException(missingReferences);
            }
            MissingReferences missingReferences2 = missingReferences;
            return missingReferences2;
        }
        finally {
            ExportImportThreadLocal.setPortletValidationInProcess((boolean)false);
            if (zipReader != null) {
                zipReader.close();
            }
        }
    }

    protected void deletePortletData(PortletDataContext portletDataContext, String portletId, long plid) throws Exception {
        String xml;
        long ownerId = 0L;
        int ownerType = 3;
        com.liferay.portal.model.PortletPreferences portletPreferences = PortletPreferencesUtil.fetchByO_O_P_P((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if ((xml = this.deletePortletData(portletDataContext, portletId, portletPreferences)) != null) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        }
    }

    protected String deletePortletData(PortletDataContext portletDataContext, String portletId, com.liferay.portal.model.PortletPreferences portletPreferences) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not delete portlet data for " + portletId + " because the portlet does not exist"));
            }
            return null;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not delete portlet data for " + portletId + " because the portlet does not have a " + "PortletDataHandler"));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Deleting data for " + portletId));
        }
        com.liferay.portlet.PortletPreferencesImpl portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)PortletPreferencesFactoryUtil.fromDefaultXML((String)portletPreferences.getPreferences());
        try {
            portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)portletDataHandler.deleteData(portletDataContext, portletId, (PortletPreferences)portletPreferencesImpl);
        }
        finally {
            portletDataContext.setGroupId(portletDataContext.getScopeGroupId());
        }
        if (portletPreferencesImpl == null) {
            return null;
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferencesImpl);
    }

    protected void doImportPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws Exception {
        boolean deletePortletData = MapUtil.getBoolean(parameterMap, (String)"DELETE_PORTLET_DATA");
        boolean importPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        String userIdStrategyString = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        User user = UserUtil.findByPrimaryKey((long)userId);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(user.getCompanyId());
            serviceContext.setSignedIn(false);
            serviceContext.setUserId(userId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        UserIdStrategy userIdStrategy = this.getUserIdStrategy(user, userIdStrategyString);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)layout.getCompanyId(), (long)groupId, parameterMap, (UserIdStrategy)userIdStrategy, (ZipReader)zipReader);
        portletDataContext.setPortetDataContextListener((PortletDataContextListener)new PortletDataContextListenerImpl(portletDataContext));
        portletDataContext.setPlid(plid);
        portletDataContext.setPrivateLayout(layout.isPrivateLayout());
        portletDataContext.setRootPortletId(PortletConstants.getRootPortletId((String)portletId));
        this.validateFile(portletDataContext, portletId);
        ManifestSummary manifestSummary = ExportImportHelperUtil.getManifestSummary((long)userId, (long)groupId, parameterMap, (File)file);
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"portlet", (String)portletId, (ManifestSummary)manifestSummary);
        }
        portletDataContext.setManifestSummary(manifestSummary);
        long sourceCompanyId = GetterUtil.getLong((String)this._headerElement.attributeValue("company-id"));
        portletDataContext.setSourceCompanyId(sourceCompanyId);
        long sourceCompanyGroupId = GetterUtil.getLong((String)this._headerElement.attributeValue("company-group-id"));
        portletDataContext.setSourceCompanyGroupId(sourceCompanyGroupId);
        long sourceGroupId = GetterUtil.getLong((String)this._headerElement.attributeValue("group-id"));
        portletDataContext.setSourceGroupId(sourceGroupId);
        long sourceUserPersonalSiteGroupId = GetterUtil.getLong((String)this._headerElement.attributeValue("user-personal-site-group-id"));
        portletDataContext.setSourceUserPersonalSiteGroupId(sourceUserPersonalSiteGroupId);
        Element missingReferencesElement = this._rootElement.element("missing-references");
        if (missingReferencesElement != null) {
            portletDataContext.setMissingReferencesElement(missingReferencesElement);
        }
        this._deletionSystemEventImporter.importDeletionSystemEvents(portletDataContext);
        Element portletElement = null;
        try {
            portletElement = this._rootElement.element("portlet");
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletElement.attributeValue("path")));
            portletElement = portletDocument.getRootElement();
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
        LayoutCache layoutCache = new LayoutCache();
        if (importPermissions) {
            this._permissionImporter.checkRoles(layoutCache, layout.getCompanyId(), groupId, userId, portletElement);
            this._permissionImporter.readPortletDataPermissions(portletDataContext);
        }
        this.readAssetCategories(portletDataContext);
        this.readAssetTags(portletDataContext);
        this.readComments(portletDataContext);
        this.readExpandoTables(portletDataContext);
        this.readLocks(portletDataContext);
        this.readRatingsEntries(portletDataContext);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Deleting portlet data");
        }
        if (deletePortletData) {
            this.deletePortletData(portletDataContext, portletId, plid);
        }
        Element portletDataElement = portletElement.element("portlet-data");
        Map<String, Boolean> importPortletControlsMap = LayoutImporter.getImportPortletControlsMap(layout.getCompanyId(), portletId, parameterMap, portletDataElement, manifestSummary);
        try {
            this.importPortletPreferences(portletDataContext, layout.getCompanyId(), groupId, layout, portletId, portletElement, true, importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), importPortletControlsMap.get("PORTLET_DATA"), importPortletControlsMap.get("PORTLET_SETUP"), importPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
            if (importPortletControlsMap.get("PORTLET_DATA").booleanValue()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Importing portlet data");
                }
                this.importPortletData(portletDataContext, portletId, plid, portletDataElement);
            }
        }
        finally {
            this.resetPortletScope(portletDataContext, groupId);
        }
        if (importPermissions) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Importing portlet permissions");
            }
            this._permissionImporter.importPortletPermissions(layoutCache, layout.getCompanyId(), groupId, userId, layout, portletElement, portletId);
            if (userId > 0L) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
                indexer.reindex((Object)userId);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Importing asset links");
        }
        this.readAssetLinks(portletDataContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing portlet takes " + stopWatch.getTime() + " ms"));
        }
        zipReader.close();
        ExportImportHelperUtil.reindex((PortletDataContext)portletDataContext, (long)userId);
    }

    protected String getAssetCategoryName(String uuid, long groupId, long parentCategoryId, String name, long vocabularyId, int count) throws Exception {
        AssetCategory assetCategory = AssetCategoryUtil.fetchByG_P_N_V_First((long)groupId, (long)parentCategoryId, (String)name, (long)vocabularyId, null);
        if (assetCategory == null || Validator.isNotNull((String)uuid) && uuid.equals(assetCategory.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getAssetCategoryName(uuid, groupId, parentCategoryId, name, vocabularyId, ++count);
    }

    protected String getAssetCategoryPath(PortletDataContext portletDataContext, long assetCategoryId) {
        StringBundler sb = new StringBundler(6);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/categories/");
        sb.append(assetCategoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected Map<Locale, String> getAssetCategoryTitleMap(long groupId, AssetCategory assetCategory, String name) throws PortalException, SystemException {
        HashMap<Locale, String> titleMap = assetCategory.getTitleMap();
        if (titleMap == null) {
            titleMap = new HashMap<Locale, String>();
        }
        titleMap.put(PortalUtil.getSiteDefaultLocale((long)groupId), name);
        return titleMap;
    }

    protected String getAssetVocabularyName(String uuid, long groupId, String name, int count) throws Exception {
        AssetVocabulary assetVocabulary = AssetVocabularyUtil.fetchByG_N((long)groupId, (String)name);
        if (assetVocabulary == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(assetVocabulary.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getAssetVocabularyName(uuid, groupId, name, ++count);
    }

    protected Map<Locale, String> getAssetVocabularyTitleMap(long groupId, AssetVocabulary assetVocabulary, String name) throws PortalException, SystemException {
        HashMap<Locale, String> titleMap = assetVocabulary.getTitleMap();
        if (titleMap == null) {
            titleMap = new HashMap<Locale, String>();
        }
        titleMap.put(PortalUtil.getSiteDefaultLocale((long)groupId), name);
        return titleMap;
    }

    protected UserIdStrategy getUserIdStrategy(User user, String userIdStrategy) {
        if ("ALWAYS_CURRENT_USER_ID".equals(userIdStrategy)) {
            return new AlwaysCurrentUserIdStrategy(user);
        }
        return new CurrentUserIdStrategy(user);
    }

    protected void importAssetCategory(PortletDataContext portletDataContext, Map<Long, Long> assetVocabularyPKs, Map<Long, Long> assetCategoryPKs, Map<String, String> assetCategoryUuids, Element assetCategoryElement, AssetCategory assetCategory) throws Exception {
        long userId = portletDataContext.getUserId(assetCategory.getUserUuid());
        long groupId = portletDataContext.getGroupId();
        long assetVocabularyId = MapUtil.getLong(assetVocabularyPKs, (long)assetCategory.getVocabularyId(), (long)assetCategory.getVocabularyId());
        long parentAssetCategoryId = MapUtil.getLong(assetCategoryPKs, (long)assetCategory.getParentCategoryId(), (long)assetCategory.getParentCategoryId());
        if (parentAssetCategoryId != 0L && parentAssetCategoryId == assetCategory.getParentCategoryId()) {
            String path = this.getAssetCategoryPath(portletDataContext, parentAssetCategoryId);
            AssetCategory parentAssetCategory = (AssetCategory)portletDataContext.getZipEntryAsObject(path);
            Node parentCategoryNode = assetCategoryElement.getParent().selectSingleNode("./category[@path='" + path + "']");
            if (parentCategoryNode != null) {
                this.importAssetCategory(portletDataContext, assetVocabularyPKs, assetCategoryPKs, assetCategoryUuids, (Element)parentCategoryNode, parentAssetCategory);
                parentAssetCategoryId = MapUtil.getLong(assetCategoryPKs, (long)assetCategory.getParentCategoryId(), (long)assetCategory.getParentCategoryId());
            }
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(assetCategory.getCreateDate());
        serviceContext.setModifiedDate(assetCategory.getModifiedDate());
        serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        AssetCategory importedAssetCategory = null;
        if (parentAssetCategoryId != 0L && AssetCategoryUtil.fetchByPrimaryKey((long)parentAssetCategoryId) == null) {
            _log.error((Object)("Could not find the parent category for category " + assetCategory.getCategoryId()));
            return;
        }
        List propertyElements = assetCategoryElement.elements("property");
        String[] properties = new String[propertyElements.size()];
        int i2 = 0;
        while (i2 < propertyElements.size()) {
            Element propertyElement = (Element)propertyElements.get(i2);
            String key = propertyElement.attributeValue("key");
            String value = propertyElement.attributeValue("value");
            properties[i2] = key.concat("_KEY_VALUE_").concat(value);
            ++i2;
        }
        AssetCategory existingAssetCategory = AssetCategoryUtil.fetchByUUID_G((String)assetCategory.getUuid(), (long)groupId);
        if (existingAssetCategory == null) {
            existingAssetCategory = AssetCategoryUtil.fetchByUUID_G((String)assetCategory.getUuid(), (long)portletDataContext.getCompanyGroupId());
        }
        if (existingAssetCategory == null) {
            existingAssetCategory = AssetCategoryUtil.fetchByG_P_N_V_First((long)groupId, (long)parentAssetCategoryId, (String)assetCategory.getName(), (long)assetVocabularyId, null);
        }
        if (existingAssetCategory == null) {
            serviceContext.setUuid(assetCategory.getUuid());
            importedAssetCategory = AssetCategoryLocalServiceUtil.addCategory((long)userId, (long)parentAssetCategoryId, this.getAssetCategoryTitleMap(groupId, assetCategory, assetCategory.getName()), (Map)assetCategory.getDescriptionMap(), (long)assetVocabularyId, (String[])properties, (ServiceContext)serviceContext);
        } else {
            if (portletDataContext.isCompanyStagedGroupedModel((StagedGroupedModel)existingAssetCategory)) {
                return;
            }
            String name = this.getAssetCategoryName(existingAssetCategory.getUuid(), groupId, parentAssetCategoryId, assetCategory.getName(), assetVocabularyId, 2);
            if (!Validator.equals((Object)existingAssetCategory.getName(), (Object)name)) {
                List assetCategoryAssetEntries = AssetEntryLocalServiceUtil.getAssetCategoryAssetEntries((long)existingAssetCategory.getCategoryId());
                for (AssetEntry assetCategoryAssetEntry : assetCategoryAssetEntries) {
                    String className = PortalUtil.getClassName((long)assetCategoryAssetEntry.getClassNameId());
                    Map newPrimaryKeysMap = portletDataContext.getNewPrimaryKeysMap(className);
                    newPrimaryKeysMap.put(assetCategoryAssetEntry.getClassPK(), assetCategoryAssetEntry.getClassPK());
                }
            }
            importedAssetCategory = AssetCategoryLocalServiceUtil.updateCategory((long)userId, (long)existingAssetCategory.getCategoryId(), (long)parentAssetCategoryId, this.getAssetCategoryTitleMap(groupId, assetCategory, name), (Map)assetCategory.getDescriptionMap(), (long)assetVocabularyId, (String[])properties, (ServiceContext)serviceContext);
            String assetCategoryUuid = assetCategory.getUuid();
            if (!assetCategoryUuid.equals(importedAssetCategory.getUuid())) {
                importedAssetCategory.setUuid(assetCategory.getUuid());
                AssetCategoryLocalServiceUtil.updateAssetCategory((AssetCategory)importedAssetCategory);
            }
        }
        assetCategoryPKs.put(assetCategory.getCategoryId(), importedAssetCategory.getCategoryId());
        assetCategoryUuids.put(assetCategory.getUuid(), importedAssetCategory.getUuid());
        portletDataContext.importPermissions(AssetCategory.class, assetCategory.getCategoryId(), importedAssetCategory.getCategoryId());
    }

    protected void importAssetTag(PortletDataContext portletDataContext, Map<Long, Long> assetTagPKs, Element assetTagElement, AssetTag assetTag) throws PortalException, SystemException {
        AssetTag existingAssetTag;
        String[] properties;
        AssetTag importedAssetTag;
        ServiceContext serviceContext;
        long userId;
        block5: {
            userId = portletDataContext.getUserId(assetTag.getUserUuid());
            serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setCreateDate(assetTag.getCreateDate());
            serviceContext.setModifiedDate(assetTag.getModifiedDate());
            serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
            importedAssetTag = null;
            List propertyElements = assetTagElement.elements("property");
            properties = new String[propertyElements.size()];
            int i2 = 0;
            while (i2 < propertyElements.size()) {
                Element propertyElement = (Element)propertyElements.get(i2);
                String key = propertyElement.attributeValue("key");
                String value = propertyElement.attributeValue("value");
                properties[i2] = key.concat("_KEY_VALUE_").concat(value);
                ++i2;
            }
            existingAssetTag = null;
            try {
                existingAssetTag = AssetTagUtil.findByG_N((long)portletDataContext.getScopeGroupId(), (String)assetTag.getName());
            }
            catch (NoSuchTagException noSuchTagException) {
                if (!_log.isDebugEnabled()) break block5;
                StringBundler sb = new StringBundler(5);
                sb.append("No AssetTag exists with the key {groupId=");
                sb.append(portletDataContext.getScopeGroupId());
                sb.append(", name=");
                sb.append(assetTag.getName());
                sb.append("}");
                _log.debug((Object)sb.toString());
            }
        }
        try {
            importedAssetTag = existingAssetTag == null ? AssetTagLocalServiceUtil.addTag((long)userId, (String)assetTag.getName(), (String[])properties, (ServiceContext)serviceContext) : AssetTagLocalServiceUtil.updateTag((long)userId, (long)existingAssetTag.getTagId(), (String)assetTag.getName(), (String[])properties, (ServiceContext)serviceContext);
            assetTagPKs.put(assetTag.getTagId(), importedAssetTag.getTagId());
            portletDataContext.importPermissions(AssetTag.class, assetTag.getTagId(), importedAssetTag.getTagId());
        }
        catch (NoSuchTagException noSuchTagException) {
            _log.error((Object)("Could not find the parent category for category " + assetTag.getTagId()));
        }
    }

    protected void importAssetVocabulary(PortletDataContext portletDataContext, Map<Long, Long> assetVocabularyPKs, Element assetVocabularyElement, AssetVocabulary assetVocabulary) throws Exception {
        long userId = portletDataContext.getUserId(assetVocabulary.getUserUuid());
        long groupId = portletDataContext.getScopeGroupId();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(assetVocabulary.getCreateDate());
        serviceContext.setModifiedDate(assetVocabulary.getModifiedDate());
        serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        AssetVocabulary importedAssetVocabulary = null;
        AssetVocabulary existingAssetVocabulary = AssetVocabularyUtil.fetchByUUID_G((String)assetVocabulary.getUuid(), (long)groupId);
        if (existingAssetVocabulary == null) {
            existingAssetVocabulary = AssetVocabularyUtil.fetchByUUID_G((String)assetVocabulary.getUuid(), (long)portletDataContext.getCompanyGroupId());
        }
        if (existingAssetVocabulary == null) {
            existingAssetVocabulary = AssetVocabularyUtil.fetchByG_N((long)groupId, (String)assetVocabulary.getName());
        }
        if (existingAssetVocabulary == null) {
            serviceContext.setUuid(assetVocabulary.getUuid());
            importedAssetVocabulary = AssetVocabularyLocalServiceUtil.addVocabulary((long)userId, (String)"", this.getAssetVocabularyTitleMap(groupId, assetVocabulary, assetVocabulary.getName()), (Map)assetVocabulary.getDescriptionMap(), (String)assetVocabulary.getSettings(), (ServiceContext)serviceContext);
        } else {
            if (portletDataContext.isCompanyStagedGroupedModel((StagedGroupedModel)existingAssetVocabulary)) {
                return;
            }
            String name = this.getAssetVocabularyName(existingAssetVocabulary.getUuid(), groupId, assetVocabulary.getName(), 2);
            importedAssetVocabulary = AssetVocabularyLocalServiceUtil.updateVocabulary((long)existingAssetVocabulary.getVocabularyId(), (String)"", this.getAssetVocabularyTitleMap(groupId, assetVocabulary, name), (Map)assetVocabulary.getDescriptionMap(), (String)assetVocabulary.getSettings(), (ServiceContext)serviceContext);
            String assetVocabularyUuid = assetVocabulary.getUuid();
            if (!assetVocabularyUuid.equals(importedAssetVocabulary.getUuid())) {
                importedAssetVocabulary.setUuid(assetVocabulary.getUuid());
                AssetVocabularyLocalServiceUtil.updateAssetVocabulary((AssetVocabulary)importedAssetVocabulary);
            }
        }
        assetVocabularyPKs.put(assetVocabulary.getVocabularyId(), importedAssetVocabulary.getVocabularyId());
        portletDataContext.importPermissions(AssetVocabulary.class, assetVocabulary.getVocabularyId(), importedAssetVocabulary.getVocabularyId());
    }

    protected void importPortletData(PortletDataContext portletDataContext, String portletId, long plid, Element portletDataElement) throws Exception {
        String xml;
        long ownerId = 0L;
        int ownerType = 3;
        com.liferay.portal.model.PortletPreferences portletPreferences = PortletPreferencesUtil.fetchByO_O_P_P((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if (Validator.isNotNull((String)(xml = this.importPortletData(portletDataContext, portletId, portletPreferences, portletDataElement)))) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        }
    }

    protected void importPortletPreferences(PortletDataContext portletDataContext, long companyId, long groupId, Layout layout, String portletId, Element parentElement, boolean preserveScopeLayoutId, boolean importPortletArchivedSetups, boolean importPortletData, boolean importPortletSetup, boolean importPortletUserPreferences) throws Exception {
        if (portletId == null) {
            portletId = parentElement.attributeValue("portlet-id");
        }
        long plid = 0L;
        String scopeType = "";
        String scopeLayoutUuid = "";
        if (layout != null) {
            plid = layout.getPlid();
            if (preserveScopeLayoutId && portletId != null) {
                PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
                scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
                scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
                portletDataContext.setScopeType(scopeType);
                portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            }
        }
        List portletPreferencesElements = parentElement.elements("portlet-preferences");
        for (Element portletPreferencesElement : portletPreferencesElements) {
            boolean defaultUser;
            String userUuid;
            String path = portletPreferencesElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            String xml = null;
            Element element = null;
            try {
                xml = portletDataContext.getZipEntryAsString(path);
                Document preferencesDocument = SAXReaderUtil.read((String)xml);
                element = preferencesDocument.getRootElement();
            }
            catch (DocumentException de) {
                throw new SystemException((Throwable)de);
            }
            long ownerId = GetterUtil.getLong((String)element.attributeValue("owner-id"));
            int ownerType = GetterUtil.getInteger((String)element.attributeValue("owner-type"));
            if (ownerType == 1 || !importPortletSetup || ownerType == 5 && !importPortletArchivedSetups || ownerType == 4 && ownerId != 0L && !importPortletUserPreferences) continue;
            long curPlid = plid;
            String curPortletId = portletId;
            if (ownerType == 2) {
                curPlid = 0L;
                curPortletId = PortletConstants.getRootPortletId((String)portletId);
                ownerId = portletDataContext.getScopeGroupId();
            }
            if (ownerType == 5) {
                userUuid = element.attributeValue("archive-user-uuid");
                long userId = portletDataContext.getUserId(userUuid);
                String name = element.attributeValue("archive-name");
                curPortletId = PortletConstants.getRootPortletId((String)portletId);
                PortletItem portletItem = PortletItemLocalServiceUtil.updatePortletItem((long)userId, (long)groupId, (String)name, (String)curPortletId, (String)com.liferay.portal.model.PortletPreferences.class.getName());
                curPlid = 0L;
                ownerId = portletItem.getPortletItemId();
            }
            if (ownerType == 4) {
                userUuid = element.attributeValue("user-uuid");
                ownerId = portletDataContext.getUserId(userUuid);
            }
            if (defaultUser = GetterUtil.getBoolean((String)element.attributeValue("default-user"))) {
                ownerId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
            }
            PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)curPlid, (String)curPortletId, (String)xml);
            Element importDataRootElement = portletDataContext.getImportDataRootElement();
            try {
                Element preferenceDataElement = portletPreferencesElement.element("preference-data");
                if (preferenceDataElement != null) {
                    portletDataContext.setImportDataRootElement(preferenceDataElement);
                }
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)curPortletId);
                PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
                jxPortletPreferences = portletDataHandler.processImportPortletPreferences(portletDataContext, curPortletId, jxPortletPreferences);
            }
            finally {
                portletDataContext.setImportDataRootElement(importDataRootElement);
            }
            this.updatePortletPreferences(portletDataContext, ownerId, ownerType, curPlid, curPortletId, PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences), importPortletData);
        }
        if (preserveScopeLayoutId && layout != null) {
            PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
            try {
                jxPortletPreferences.setValue("lfrScopeType", scopeType);
                jxPortletPreferences.setValue("lfrScopeLayoutUuid", scopeLayoutUuid);
                jxPortletPreferences.store();
            }
            finally {
                portletDataContext.setScopeType(scopeType);
                portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            }
        }
    }

    protected void readAssetCategories(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext)) + "/categories-hierarchy.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        Element assetVocabulariesElement = rootElement.element("vocabularies");
        List assetVocabularyElements = assetVocabulariesElement.elements("vocabulary");
        Map assetVocabularyPKs = portletDataContext.getNewPrimaryKeysMap(AssetVocabulary.class);
        for (Element assetVocabularyElement : assetVocabularyElements) {
            String path = assetVocabularyElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            AssetVocabulary assetVocabulary = (AssetVocabulary)portletDataContext.getZipEntryAsObject(path);
            this.importAssetVocabulary(portletDataContext, assetVocabularyPKs, assetVocabularyElement, assetVocabulary);
        }
        Element assetCategoriesElement = rootElement.element("categories");
        List assetCategoryElements = assetCategoriesElement.elements("category");
        Map assetCategoryPKs = portletDataContext.getNewPrimaryKeysMap(AssetCategory.class);
        Map assetCategoryUuids = portletDataContext.getNewPrimaryKeysMap(AssetCategory.class + ".uuid");
        for (Element assetCategoryElement : assetCategoryElements) {
            String path = assetCategoryElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            AssetCategory assetCategory = (AssetCategory)portletDataContext.getZipEntryAsObject(path);
            this.importAssetCategory(portletDataContext, assetVocabularyPKs, assetCategoryPKs, assetCategoryUuids, assetCategoryElement, assetCategory);
        }
        Element assetsElement = rootElement.element("assets");
        List assetElements = assetsElement.elements("asset");
        for (Element assetElement : assetElements) {
            String className = GetterUtil.getString((String)assetElement.attributeValue("class-name"));
            long classPK = GetterUtil.getLong((String)assetElement.attributeValue("class-pk"));
            String[] assetCategoryUuidArray = StringUtil.split((String)GetterUtil.getString((String)assetElement.attributeValue("category-uuids")));
            long[] assetCategoryIds = new long[]{};
            String[] stringArray = assetCategoryUuidArray;
            int n = assetCategoryUuidArray.length;
            int n2 = 0;
            while (n2 < n) {
                String assetCategoryUuid = stringArray[n2];
                AssetCategory assetCategory = AssetCategoryUtil.fetchByUUID_G((String)(assetCategoryUuid = MapUtil.getString((Map)assetCategoryUuids, (String)assetCategoryUuid, (String)assetCategoryUuid)), (long)portletDataContext.getScopeGroupId());
                if (assetCategory == null) {
                    Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
                    assetCategory = AssetCategoryUtil.fetchByUUID_G((String)assetCategoryUuid, (long)companyGroup.getGroupId());
                }
                if (assetCategory != null) {
                    assetCategoryIds = ArrayUtil.append((long[])assetCategoryIds, (long)assetCategory.getCategoryId());
                }
                ++n2;
            }
            portletDataContext.addAssetCategories(className, classPK, assetCategoryIds);
        }
    }

    protected void readAssetLinks(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext)) + "/links.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetLinkGroupElements = rootElement.elements("asset-link-group");
        for (Element assetLinkGroupElement : assetLinkGroupElements) {
            String sourceUuid = assetLinkGroupElement.attributeValue("source-uuid");
            AssetEntry sourceAssetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)portletDataContext.getScopeGroupId(), (String)sourceUuid);
            if (sourceAssetEntry == null) {
                sourceAssetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)portletDataContext.getCompanyGroupId(), (String)sourceUuid);
            }
            if (sourceAssetEntry == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to find asset entry with uuid " + sourceUuid));
                continue;
            }
            List assetLinksElements = assetLinkGroupElement.elements("asset-link");
            for (Element assetLinkElement : assetLinksElements) {
                String path = assetLinkElement.attributeValue("path");
                if (!portletDataContext.isPathNotProcessed(path)) continue;
                String targetUuid = assetLinkElement.attributeValue("target-uuid");
                AssetEntry targetAssetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)portletDataContext.getScopeGroupId(), (String)targetUuid);
                if (targetAssetEntry == null) {
                    targetAssetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)portletDataContext.getCompanyGroupId(), (String)targetUuid);
                }
                if (targetAssetEntry == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to find asset entry with uuid " + targetUuid));
                    continue;
                }
                AssetLink assetLink = (AssetLink)portletDataContext.getZipEntryAsObject(path);
                long userId = portletDataContext.getUserId(assetLink.getUserUuid());
                AssetLinkLocalServiceUtil.updateLink((long)userId, (long)sourceAssetEntry.getEntryId(), (long)targetAssetEntry.getEntryId(), (int)assetLink.getType(), (int)assetLink.getWeight());
            }
        }
    }

    protected void readAssetTags(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext)) + "/tags.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetTagElements = rootElement.elements("tag");
        for (Element assetTagElement : assetTagElements) {
            String path = assetTagElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            AssetTag assetTag = (AssetTag)portletDataContext.getZipEntryAsObject(path);
            Map assetTagPKs = portletDataContext.getNewPrimaryKeysMap(AssetTag.class);
            this.importAssetTag(portletDataContext, assetTagPKs, assetTagElement, assetTag);
        }
        List assetElements = rootElement.elements("asset");
        for (Element assetElement : assetElements) {
            String className = GetterUtil.getString((String)assetElement.attributeValue("class-name"));
            long classPK = GetterUtil.getLong((String)assetElement.attributeValue("class-pk"));
            String assetTagNames = GetterUtil.getString((String)assetElement.attributeValue("tags"));
            portletDataContext.addAssetTags(className, classPK, StringUtil.split((String)assetTagNames));
        }
    }

    protected void readComments(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext)) + "/comments.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetElements = rootElement.elements("asset");
        for (Element assetElement : assetElements) {
            String path = assetElement.attributeValue("path");
            String className = assetElement.attributeValue("class-name");
            long classPK = GetterUtil.getLong((String)assetElement.attributeValue("class-pk"));
            List zipFolderEntries = portletDataContext.getZipFolderEntries(path);
            ArrayList<MBMessage> mbMessages = new ArrayList<MBMessage>();
            for (String zipFolderEntry : zipFolderEntries) {
                MBMessage mbMessage = (MBMessage)portletDataContext.getZipEntryAsObject(zipFolderEntry);
                if (mbMessage == null) continue;
                mbMessages.add(mbMessage);
            }
            portletDataContext.addComments(className, classPK, mbMessages);
        }
    }

    protected void readExpandoTables(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext)) + "/expando-tables.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List expandoTableElements = rootElement.elements("expando-table");
        for (Element expandoTableElement : expandoTableElements) {
            String className = expandoTableElement.attributeValue("class-name");
            ExpandoTable expandoTable = null;
            try {
                expandoTable = ExpandoTableLocalServiceUtil.getDefaultTable((long)portletDataContext.getCompanyId(), (String)className);
            }
            catch (NoSuchTableException noSuchTableException) {
                expandoTable = ExpandoTableLocalServiceUtil.addDefaultTable((long)portletDataContext.getCompanyId(), (String)className);
            }
            List expandoColumnElements = expandoTableElement.elements("expando-column");
            for (Element expandoColumnElement : expandoColumnElements) {
                long columnId = GetterUtil.getLong((String)expandoColumnElement.attributeValue("column-id"));
                String name = expandoColumnElement.attributeValue("name");
                int type = GetterUtil.getInteger((String)expandoColumnElement.attributeValue("type"));
                String defaultData = expandoColumnElement.elementText("default-data");
                String typeSettings = expandoColumnElement.elementText("type-settings");
                Serializable defaultDataObject = ExpandoConverterUtil.getAttributeFromString(type, defaultData);
                ExpandoColumn expandoColumn = ExpandoColumnLocalServiceUtil.getColumn((long)expandoTable.getTableId(), (String)name);
                if (expandoColumn != null) {
                    ExpandoColumnLocalServiceUtil.updateColumn((long)expandoColumn.getColumnId(), (String)name, (int)type, (Object)defaultDataObject);
                } else {
                    expandoColumn = ExpandoColumnLocalServiceUtil.addColumn((long)expandoTable.getTableId(), (String)name, (int)type, (Object)defaultDataObject);
                }
                ExpandoColumnLocalServiceUtil.updateTypeSettings((long)expandoColumn.getColumnId(), (String)typeSettings);
                portletDataContext.importPermissions(ExpandoColumn.class, columnId, expandoColumn.getColumnId());
            }
        }
    }

    protected void readLocks(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext)) + "/locks.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetElements = rootElement.elements("asset");
        for (Element assetElement : assetElements) {
            String path = assetElement.attributeValue("path");
            String className = assetElement.attributeValue("class-name");
            String key = assetElement.attributeValue("key");
            Lock lock = (Lock)portletDataContext.getZipEntryAsObject(path);
            if (lock == null) continue;
            portletDataContext.addLocks(className, key, lock);
        }
    }

    protected void readRatingsEntries(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext)) + "/ratings.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetElements = rootElement.elements("asset");
        for (Element assetElement : assetElements) {
            String path = assetElement.attributeValue("path");
            String className = assetElement.attributeValue("class-name");
            long classPK = GetterUtil.getLong((String)assetElement.attributeValue("class-pk"));
            List zipFolderEntries = portletDataContext.getZipFolderEntries(path);
            ArrayList<RatingsEntry> ratingsEntries = new ArrayList<RatingsEntry>();
            for (String zipFolderEntry : zipFolderEntries) {
                RatingsEntry ratingsEntry = (RatingsEntry)portletDataContext.getZipEntryAsObject(zipFolderEntry);
                if (ratingsEntry == null) continue;
                ratingsEntries.add(ratingsEntry);
            }
            portletDataContext.addRatingsEntries(className, classPK, ratingsEntries);
        }
    }

    protected void readXML(PortletDataContext portletDataContext) throws Exception {
        if (this._rootElement != null && this._headerElement != null) {
            return;
        }
        String xml = portletDataContext.getZipEntryAsString("/manifest.xml");
        if (xml == null) {
            throw new LARFileException("manifest.xml not found in the LAR");
        }
        try {
            Document document = SAXReaderUtil.read((String)xml);
            this._rootElement = document.getRootElement();
            portletDataContext.setImportDataRootElement(this._rootElement);
        }
        catch (Exception e2) {
            throw new LARFileException((Throwable)e2);
        }
        this._headerElement = this._rootElement.element("header");
    }

    protected void resetPortletScope(PortletDataContext portletDataContext, long groupId) {
        portletDataContext.setScopeGroupId(groupId);
        portletDataContext.setScopeLayoutUuid("");
        portletDataContext.setScopeType("");
    }

    protected void updatePortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, long plid, String portletId, String xml, boolean importData) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not update portlet preferences for " + portletId + " because the portlet does not exist"));
            }
            return;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (importData || !MergeLayoutPrototypesThreadLocal.isInProgress()) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
            return;
        }
        Object[] dataPortletPreferences = portletDataHandler.getDataPortletPreferences();
        PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.getPreferences((long)portletDataContext.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromXML((long)portletDataContext.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        Enumeration enu = jxPortletPreferences.getNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String scopeLayoutUuid = portletDataContext.getScopeLayoutUuid();
            String scopeType = portletDataContext.getScopeType();
            if (ArrayUtil.contains((Object[])dataPortletPreferences, (Object)name) && (!Validator.isNull((String)scopeLayoutUuid) || !scopeType.equals("company"))) continue;
            String[] values = jxPortletPreferences.getValues(name, null);
            portletPreferences.setValues(name, values);
        }
        PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (PortletPreferences)portletPreferences);
    }

    protected void validateFile(PortletDataContext portletDataContext, String portletId) throws Exception {
        this.readXML(portletDataContext);
        int buildNumber = ReleaseInfo.getBuildNumber();
        int importBuildNumber = GetterUtil.getInteger((String)this._headerElement.attributeValue("build-number"));
        if (buildNumber != importBuildNumber) {
            throw new LayoutImportException("LAR build number " + importBuildNumber + " does not match " + "portal build number " + buildNumber);
        }
        String larType = this._headerElement.attributeValue("type");
        if (!larType.equals("portlet")) {
            throw new LARTypeException(larType);
        }
        String rootPortletId = this._headerElement.attributeValue("root-portlet-id");
        if (!PortletConstants.getRootPortletId((String)portletId).equals(rootPortletId)) {
            throw new PortletIdException("Invalid portlet id " + rootPortletId);
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler.isDataLocalized()) {
            Locale[] sourceAvailableLocales = LocaleUtil.fromLanguageIds((String[])StringUtil.split((String)this._headerElement.attributeValue("available-locales")));
            Object[] targetAvailableLocales = LanguageUtil.getAvailableLocales((long)PortalUtil.getSiteGroupId((long)portletDataContext.getScopeGroupId()));
            Locale[] localeArray = sourceAvailableLocales;
            int n = sourceAvailableLocales.length;
            int n2 = 0;
            while (n2 < n) {
                Locale sourceAvailableLocale = localeArray[n2];
                if (!ArrayUtil.contains((Object[])targetAvailableLocales, (Object)sourceAvailableLocale)) {
                    LocaleException le = new LocaleException(2, "Locale " + sourceAvailableLocale + " is not " + "available in company " + portletDataContext.getCompanyId());
                    le.setSourceAvailableLocales(sourceAvailableLocales);
                    le.setTargetAvailableLocales((Locale[])targetAvailableLocales);
                    throw le;
                }
                ++n2;
            }
        }
    }
}

