/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DerivedStringProperty<D> {
    private static final Logger log = LoggerFactory.getLogger(DerivedStringProperty.class);
    private final DynamicStringProperty delegate;
    private final AtomicReference<D> derived = new AtomicReference<Object>(null);

    public DerivedStringProperty(String name, String defaultValue) {
        this.delegate = DynamicPropertyFactory.getInstance().getStringProperty(name, defaultValue);
        this.deriveAndSet();
        this.delegate.addCallback(new Runnable(){

            @Override
            public void run() {
                DerivedStringProperty.this.propertyChangedInternal();
            }
        });
    }

    public D get() {
        return this.derived.get();
    }

    protected abstract D derive(String var1);

    protected void propertyChanged() {
    }

    void propertyChangedInternal() {
        this.deriveAndSet();
        this.propertyChanged();
    }

    private void deriveAndSet() {
        try {
            this.derived.set(this.derive(this.delegate.get()));
        }
        catch (Exception e) {
            log.error("error when deriving initial value", (Throwable)e);
        }
    }
}

