/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.cql.test.utils.ReadTests;
import com.netflix.astyanax.cql.test.utils.TestUtils;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SingleRowColumnRangeQueryTests
extends ReadTests {
    private static ColumnFamily<String, String> CF_COLUMN_RANGE_TEST = TestUtils.CF_COLUMN_RANGE_TEST;

    @BeforeClass
    public static void init() throws Exception {
        SingleRowColumnRangeQueryTests.initContext();
        keyspace.createColumnFamily(CF_COLUMN_RANGE_TEST, null);
        CF_COLUMN_RANGE_TEST.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_COLUMN_RANGE_TEST);
    }

    @Test
    public void testColumnRangeQuery() throws Exception {
        TestUtils.populateRowsForColumnRange(keyspace);
        Thread.sleep(1000L);
        boolean rowDeleted = false;
        this.readColumnRangeForAllRows(rowDeleted);
        this.getColumnCountForAllRows(rowDeleted);
        TestUtils.deleteRowsForColumnRange(keyspace);
        rowDeleted = true;
        this.readColumnRangeForAllRows(rowDeleted);
        this.getColumnCountForAllRows(rowDeleted);
    }

    public void readColumnRangeForAllRows(boolean rowDeleted) throws Exception {
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            this.readColumnRangeForRowKey(String.valueOf(ch), rowDeleted);
        }
    }

    private void readColumnRangeForRowKey(String rowKey, boolean rowDeleted) throws Exception {
        ColumnList columns = (ColumnList)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getKey((Object)rowKey).withColumnRange((Object)"a", (Object)"z", false, -1).execute().getResult();
        if (rowDeleted) {
            Assert.assertTrue((boolean)columns.isEmpty());
            return;
        }
        Assert.assertFalse((boolean)columns.isEmpty());
        char ch = 'a';
        for (Column c : columns) {
            Assert.assertEquals((String)String.valueOf(ch), (String)((String)c.getName()));
            Assert.assertTrue((ch - 97 + 1 == c.getIntegerValue() ? 1 : 0) != 0);
            ch = (char)(ch + '\u0001');
        }
    }

    public void getColumnCountForAllRows(boolean rowDeleted) throws Exception {
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            this.getColumnCountForRowKey(String.valueOf(ch), rowDeleted);
        }
    }

    private void getColumnCountForRowKey(String rowKey, boolean rowDeleted) throws Exception {
        Integer count = (Integer)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getKey((Object)rowKey).withColumnRange((Object)"a", (Object)"z", false, -1).getCount().execute().getResult();
        int expectedCount = rowDeleted ? 0 : 26;
        Assert.assertTrue((count == expectedCount ? 1 : 0) != 0);
    }
}

