/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class RowCopierTests
extends KeyspaceTests {
    private static final ColumnFamily<Integer, String> CF_ROW_COPY = new ColumnFamily("testrowcopy", (Serializer)IntegerSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)IntegerSerializer.get());
    private static final ColumnFamily<Integer, String> CF_ROW_COPY2 = new ColumnFamily("testrowcopy2", (Serializer)IntegerSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)IntegerSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        RowCopierTests.initContext();
        keyspace.createColumnFamily(CF_ROW_COPY, null);
        keyspace.createColumnFamily(CF_ROW_COPY2, null);
        CF_ROW_COPY.describe(keyspace);
        CF_ROW_COPY2.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_ROW_COPY);
        keyspace.dropColumnFamily(CF_ROW_COPY2);
    }

    @Test
    public void runRowCopyTest() throws Exception {
        MutationBatch m = keyspace.prepareMutationBatch();
        m.withRow(CF_ROW_COPY, (Object)10).putColumn((Object)"c1", 1).putColumn((Object)"c2", 2);
        m.execute();
        ColumnList result = (ColumnList)keyspace.prepareQuery(CF_ROW_COPY).getRow((Object)10).execute().getResult();
        Column column = result.getColumnByIndex(0);
        Assert.assertEquals((String)"c1", (String)((String)column.getName()));
        Assert.assertEquals((int)1, (int)column.getIntegerValue());
        column = result.getColumnByIndex(1);
        Assert.assertEquals((String)"c2", (String)((String)column.getName()));
        Assert.assertEquals((int)2, (int)column.getIntegerValue());
        keyspace.prepareQuery(CF_ROW_COPY).getRow((Object)10).copyTo(CF_ROW_COPY2, (Object)11).execute();
        ColumnList result2 = (ColumnList)keyspace.prepareQuery(CF_ROW_COPY2).getRow((Object)11).execute().getResult();
        column = result2.getColumnByIndex(0);
        Assert.assertEquals((String)"c1", (String)((String)column.getName()));
        Assert.assertEquals((int)1, (int)column.getIntegerValue());
        column = result2.getColumnByIndex(1);
        Assert.assertEquals((String)"c2", (String)((String)column.getName()));
        Assert.assertEquals((int)2, (int)column.getIntegerValue());
    }
}

