/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.test.ErrorTest;
import com.hp.hpl.jena.rdf.arp.test.LazyFileInputStream;
import com.hp.hpl.jena.rdf.arp.test.NTripleTest;
import com.hp.hpl.jena.rdf.arp.test.TestEqualitySuite;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BugzillaTestSuite
extends TestSuite
implements ARPErrorNumbers {
    private static String dir = "modules/rdf/regression/arp/";

    public BugzillaTestSuite() {
        super("ARP reported bugs");
        this.addBad("Fragment Namespace URI", 500, 109);
        this.addBad("rdf:_-1", 670, 103);
        this.addBad("rdf:_0", 675, 103);
        this.addBad("rdf:_01", 676, 103);
        this.addBad("Bad rdf:_NNN", 677, 0).setExpected(new int[]{113, 113, 113});
        this.addBad("attr rdf:-1", 671, 111);
        this.addBad("attr rdf:0", 672, 111);
        this.addBad("element rdf:-1", 673, 111);
        this.addBad("element rdf:0", 674, 111);
        this.addBad("rdf:parseType=\"literal\"", 680, 106);
        this.addBad("rdf:li as type", 690, 114);
        this.addTriple("colon in ID", 740);
        this.addTriple("xml:base with no path", 510);
        this.addEqual("unicode and other encodings", new int[]{730, 731, 732});
    }

    public static TestSuite suite() {
        return new BugzillaTestSuite();
    }

    private ErrorTest addBad(String string, int n, int n2) {
        int n3 = n / 10;
        int n4 = n % 10;
        String string2 = "bad-bug" + n3 + "_" + n4 + ".rdf";
        ErrorTest errorTest = new ErrorTest("http://example.org/" + string2, new LazyFileInputStream(dir + string2), n2);
        errorTest.setName(string);
        if (n2 == 111) {
            errorTest.setExpected(new int[]{111, 111});
        }
        this.addTest((Test)errorTest);
        return errorTest;
    }

    private void addTriple(String string, int n) {
        int n2 = n / 10;
        int n3 = n % 10;
        String string2 = "bug" + n2 + "_" + n3;
        NTripleTest nTripleTest = new NTripleTest(n == 510 ? "http://example.org" : "http://example.org/" + string2 + ".rdf", dir + string2 + ".rdf", dir + string2 + ".nt");
        nTripleTest.setName(string);
        this.addTest((Test)nTripleTest);
    }

    private void addEqual(String string, int[] nArray) {
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = "eq-bug" + nArray[n] / 10 + "_" + nArray[n] % 10 + ".rdf";
            ++n;
        }
        this.addTest((Test)new TestEqualitySuite(string, dir, "http://example.org/", stringArray));
    }
}

