/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.gcubesearchlibrary;

import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.BadRequestException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.InternalServerErrorException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.NotFoundException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.PropertiesFileRetrievalException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.ServletURLRetrievalException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.SetVREFailureException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.SignOutFailureException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.UnauthorizedException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.VresListingFailureException;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.ServletURLBean;
import gr.uoa.di.madgik.gcubesearchlibrary.parsers.XMLParser;
import gr.uoa.di.madgik.gcubesearchlibrary.utils.FileUtils;
import gr.uoa.di.madgik.gcubesearchlibrary.utils.RequestHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;

public class LoginHandler {
    public static String signIn(ServletURLBean servletURL, String username, String pass) throws ServletURLRetrievalException, UnauthorizedException, NotFoundException, PropertiesFileRetrievalException {
        String request = null;
        try {
            request = URLEncoder.encode("username", "UTF-8") + "=" + URLEncoder.encode(username, "UTF-8");
            request = request + "&" + URLEncoder.encode("password", "UTF-8") + "=" + URLEncoder.encode(pass, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            String protocol = null;
            String host = null;
            String port = null;
            if (servletURL != null) {
                protocol = servletURL.getProtocol();
                host = servletURL.getHost();
                port = servletURL.getPort();
            } else {
                protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                host = FileUtils.getPropertyValue("config.properties", "host");
                port = FileUtils.getPropertyValue("config.properties", "port");
            }
            String loginServlet = FileUtils.getPropertyValue("config.properties", "login_servlet");
            String file = "/" + loginServlet + "/" + "Login";
            URL url = new URL(protocol, host, new Integer(port), file);
            return XMLParser.parseSignInResponse(RequestHandler.submitPostRequest(url, request));
        }
        catch (NumberFormatException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (MalformedURLException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
    }

    public static void signOut(ServletURLBean servletURL, String sessionID) throws SignOutFailureException {
        try {
            sessionID = sessionID.trim();
            String protocol = null;
            String host = null;
            String port = null;
            if (servletURL != null) {
                protocol = servletURL.getProtocol();
                host = servletURL.getHost();
                port = servletURL.getPort();
            } else {
                protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                host = FileUtils.getPropertyValue("config.properties", "host");
                port = FileUtils.getPropertyValue("config.properties", "port");
            }
            String loginServlet = FileUtils.getPropertyValue("config.properties", "login_servlet");
            String file = "/" + loginServlet + "/" + "Logout";
            URL url = new URL(protocol, host, new Integer(port), file);
            RequestHandler.submitGetRequest(url, sessionID);
        }
        catch (Exception e) {
            throw new SignOutFailureException("SignOut failed for the session ID '" + sessionID + "'");
        }
    }

    public static List<String> getUserVREs(ServletURLBean servletURL, String sessionID) throws PropertiesFileRetrievalException, ServletURLRetrievalException, UnauthorizedException, NotFoundException, BadRequestException, VresListingFailureException {
        try {
            sessionID = sessionID.trim();
            String protocol = null;
            String host = null;
            String port = null;
            if (servletURL != null) {
                protocol = servletURL.getProtocol();
                host = servletURL.getHost();
                port = servletURL.getPort();
            } else {
                protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                host = FileUtils.getPropertyValue("config.properties", "host");
                port = FileUtils.getPropertyValue("config.properties", "port");
            }
            String loginServlet = FileUtils.getPropertyValue("config.properties", "login_servlet");
            String file = "/" + loginServlet + "/" + "ListInfrastructureScopes" + ";" + "jsessionid" + "=" + sessionID;
            URL url = new URL(protocol, host, new Integer(port), file);
            String response = RequestHandler.submitGetRequest(url, sessionID);
            if (response != null) {
                return XMLParser.parseVREsResponse(response);
            }
        }
        catch (NumberFormatException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (InternalServerErrorException e) {
            throw new VresListingFailureException("Failed to retrieve the available VREs. An internal server error occurred");
        }
        return null;
    }

    public static void setVRE(ServletURLBean servletURL, String vre, String sessionID) throws ServletURLRetrievalException, UnauthorizedException, NotFoundException, BadRequestException, PropertiesFileRetrievalException, SetVREFailureException {
        try {
            sessionID = sessionID.trim();
            String protocol = null;
            String host = null;
            String port = null;
            if (servletURL != null) {
                protocol = servletURL.getProtocol();
                host = servletURL.getHost();
                port = servletURL.getPort();
            } else {
                protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                host = FileUtils.getPropertyValue("config.properties", "host");
                port = FileUtils.getPropertyValue("config.properties", "port");
            }
            String loginServlet = FileUtils.getPropertyValue("config.properties", "login_servlet");
            String file = "/" + loginServlet + "/" + "LoginScope" + ";" + "jsessionid" + "=" + sessionID + "?" + "scope" + "=" + vre;
            URL url = new URL(protocol, host, new Integer(port), file);
            RequestHandler.submitGetRequest(url, sessionID);
        }
        catch (NumberFormatException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (InternalServerErrorException e) {
            throw new SetVREFailureException("Failed to set the selected VRE. An internal server error occurred");
        }
    }
}

