/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.gcubesearchlibrary;

import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.BadRequestException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.ContentInfoFailureException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.InternalServerErrorException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.NotFoundException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.PropertiesFileRetrievalException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.ServletURLRetrievalException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.UnauthorizedException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.XMLParsingException;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.ObjectInfoBean;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.ServletURLBean;
import gr.uoa.di.madgik.gcubesearchlibrary.parsers.XMLParser;
import gr.uoa.di.madgik.gcubesearchlibrary.utils.FileUtils;
import gr.uoa.di.madgik.gcubesearchlibrary.utils.RequestHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ContentViewerHandler {
    public static String getGCubeObjectMimeType(ServletURLBean servletURL, String documentURI, String username, String sessionID) throws ServletURLRetrievalException, PropertiesFileRetrievalException, UnauthorizedException, NotFoundException, BadRequestException, ContentInfoFailureException, XMLParsingException {
        try {
            String protocol = null;
            String host = null;
            String port = null;
            if (servletURL != null) {
                protocol = servletURL.getProtocol();
                host = servletURL.getHost();
                port = servletURL.getPort();
            } else {
                protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                host = FileUtils.getPropertyValue("config.properties", "host");
                port = FileUtils.getPropertyValue("config.properties", "port");
            }
            String contentServlet = FileUtils.getPropertyValue("config.properties", "content_servlet");
            String file = "/" + contentServlet + "/" + "ContentInfo";
            if (sessionID != null) {
                sessionID = sessionID.trim();
                file = file + ";jsessionid=" + sessionID;
            }
            file = file + "?";
            if (username != null) {
                file = file + "username=" + username + "&";
            }
            file = file + "documentURI=" + documentURI + "&" + "responseType" + "=" + "xml";
            URL url = new URL(protocol, host, new Integer(port), file);
            String response = RequestHandler.submitGetRequest(url, sessionID);
            return XMLParser.parseObjectInfoResponseToGetMime(response);
        }
        catch (NumberFormatException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (InternalServerErrorException e) {
            throw new ContentInfoFailureException("Failed to get Object's info. An internal server error occurred");
        }
    }

    public static String getGCubeObjectMimeType(ServletURLBean servletURL, String documentURI) throws ServletURLRetrievalException, PropertiesFileRetrievalException, UnauthorizedException, NotFoundException, BadRequestException, ContentInfoFailureException, XMLParsingException {
        return ContentViewerHandler.getGCubeObjectMimeType(servletURL, documentURI, null, null);
    }

    public static ObjectInfoBean getGCubeObjectInfo(ServletURLBean servletURL, String documentURI, String username, String sessionID) throws ServletURLRetrievalException, PropertiesFileRetrievalException, UnauthorizedException, NotFoundException, BadRequestException, ContentInfoFailureException, XMLParsingException {
        try {
            String protocol = null;
            String host = null;
            String port = null;
            if (servletURL != null) {
                protocol = servletURL.getProtocol();
                host = servletURL.getHost();
                port = servletURL.getPort();
            } else {
                protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                host = FileUtils.getPropertyValue("config.properties", "host");
                port = FileUtils.getPropertyValue("config.properties", "port");
            }
            String contentServlet = FileUtils.getPropertyValue("config.properties", "content_servlet");
            String file = "/" + contentServlet + "/" + "ContentInfo";
            if (sessionID != null) {
                file = file + ";jsessionid=" + sessionID;
            }
            file = file + "?";
            if (username != null) {
                file = file + "username=" + username + "&";
            }
            file = file + "documentURI=" + documentURI + "&" + "responseType" + "=" + "xml";
            URL url = new URL(protocol, host, new Integer(port), file);
            String response = RequestHandler.submitGetRequest(url, sessionID);
            return XMLParser.parseObjectInfoResponseToGetObjectInfo(response);
        }
        catch (NumberFormatException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (InternalServerErrorException e) {
            throw new ContentInfoFailureException("Failed to get Object's info. An internal server error occurred");
        }
    }

    public static ObjectInfoBean getGCubeObjectInfo(ServletURLBean servletURL, String documentURI) throws ServletURLRetrievalException, PropertiesFileRetrievalException, UnauthorizedException, NotFoundException, BadRequestException, ContentInfoFailureException, XMLParsingException {
        return ContentViewerHandler.getGCubeObjectInfo(servletURL, documentURI, null, null);
    }

    public static ByteArrayOutputStream getGcubeObjectContent(ServletURLBean servletURL, String documentURI, String username, String sessionID) {
        try {
            String protocol = null;
            String host = null;
            String port = null;
            if (servletURL != null) {
                protocol = servletURL.getProtocol();
                host = servletURL.getHost();
                port = servletURL.getPort();
            } else {
                protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                host = FileUtils.getPropertyValue("config.properties", "host");
                port = FileUtils.getPropertyValue("config.properties", "port");
            }
            String contentServlet = FileUtils.getPropertyValue("config.properties", "content_servlet");
            String file = "/" + contentServlet + "/" + "ContentViewer";
            if (sessionID != null) {
                sessionID = sessionID.trim();
                file = file + ";jsessionid=" + sessionID;
            }
            file = file + "?";
            if (username != null) {
                file = file + "username=" + username + "&";
            }
            file = file + "documentURI=" + documentURI;
            URL url = new URL(protocol, host, new Integer(port), file);
            return RequestHandler.submitGetRequestByteStream(url, sessionID);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ByteArrayOutputStream getGcubeObjectContent(ServletURLBean servletURL, String documentURI) {
        return ContentViewerHandler.getGcubeObjectContent(servletURL, documentURI, null, null);
    }

    public static String getGCubeObjectContentURL(ServletURLBean servletURL, String documentURI, String username, String sessionID) throws ServletURLRetrievalException, PropertiesFileRetrievalException {
        try {
            String protocol = null;
            String host = null;
            String port = null;
            if (servletURL != null) {
                protocol = servletURL.getProtocol();
                host = servletURL.getHost();
                port = servletURL.getPort();
            } else {
                protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                host = FileUtils.getPropertyValue("config.properties", "host");
                port = FileUtils.getPropertyValue("config.properties", "port");
            }
            String contentServlet = FileUtils.getPropertyValue("config.properties", "content_servlet");
            String file = "/" + contentServlet + "/" + "ContentViewer";
            if (sessionID != null) {
                sessionID = sessionID.trim();
                file = file + ";jsessionid=" + sessionID;
            }
            file = file + "?";
            if (username != null) {
                file = file + "username=" + username + "&";
            }
            file = file + "documentURI=" + documentURI;
            URL url = new URL(protocol, host, new Integer(port), file);
            return url.toString();
        }
        catch (NumberFormatException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (MalformedURLException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
    }

    public static String getGCubeObjectContentURL(ServletURLBean servletURL, String documentURI) throws ServletURLRetrievalException, PropertiesFileRetrievalException {
        return ContentViewerHandler.getGCubeObjectContentURL(servletURL, documentURI, null, null);
    }
}

