/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleBoundaryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFragmentsBuilder
implements FragmentsBuilder {
    protected String[] preTags;
    protected String[] postTags;
    public static final String[] COLORED_PRE_TAGS = new String[]{"<b style=\"background:yellow\">", "<b style=\"background:lawngreen\">", "<b style=\"background:aquamarine\">", "<b style=\"background:magenta\">", "<b style=\"background:palegreen\">", "<b style=\"background:coral\">", "<b style=\"background:wheat\">", "<b style=\"background:khaki\">", "<b style=\"background:lime\">", "<b style=\"background:deepskyblue\">", "<b style=\"background:deeppink\">", "<b style=\"background:salmon\">", "<b style=\"background:peachpuff\">", "<b style=\"background:violet\">", "<b style=\"background:mediumpurple\">", "<b style=\"background:palegoldenrod\">", "<b style=\"background:darkkhaki\">", "<b style=\"background:springgreen\">", "<b style=\"background:turquoise\">", "<b style=\"background:powderblue\">"};
    public static final String[] COLORED_POST_TAGS = new String[]{"</b>"};
    private char multiValuedSeparator = (char)32;
    private final BoundaryScanner boundaryScanner;
    private static final Encoder NULL_ENCODER = new DefaultEncoder();

    protected BaseFragmentsBuilder() {
        this(new String[]{"<b>"}, new String[]{"</b>"});
    }

    protected BaseFragmentsBuilder(String[] preTags, String[] postTags) {
        this(preTags, postTags, new SimpleBoundaryScanner());
    }

    protected BaseFragmentsBuilder(BoundaryScanner boundaryScanner) {
        this(new String[]{"<b>"}, new String[]{"</b>"}, boundaryScanner);
    }

    protected BaseFragmentsBuilder(String[] preTags, String[] postTags, BoundaryScanner boundaryScanner) {
        this.preTags = preTags;
        this.postTags = postTags;
        this.boundaryScanner = boundaryScanner;
    }

    static Object checkTagsArgument(Object tags) {
        if (tags instanceof String) {
            return tags;
        }
        if (tags instanceof String[]) {
            return tags;
        }
        throw new IllegalArgumentException("type of preTags/postTags must be a String or String[]");
    }

    public abstract List<FieldFragList.WeightedFragInfo> getWeightedFragInfoList(List<FieldFragList.WeightedFragInfo> var1);

    @Override
    public String createFragment(IndexReader reader, int docId, String fieldName, FieldFragList fieldFragList) throws IOException {
        return this.createFragment(reader, docId, fieldName, fieldFragList, this.preTags, this.postTags, NULL_ENCODER);
    }

    @Override
    public String[] createFragments(IndexReader reader, int docId, String fieldName, FieldFragList fieldFragList, int maxNumFragments) throws IOException {
        return this.createFragments(reader, docId, fieldName, fieldFragList, maxNumFragments, this.preTags, this.postTags, NULL_ENCODER);
    }

    @Override
    public String createFragment(IndexReader reader, int docId, String fieldName, FieldFragList fieldFragList, String[] preTags, String[] postTags, Encoder encoder) throws IOException {
        String[] fragments = this.createFragments(reader, docId, fieldName, fieldFragList, 1, preTags, postTags, encoder);
        if (fragments == null || fragments.length == 0) {
            return null;
        }
        return fragments[0];
    }

    @Override
    public String[] createFragments(IndexReader reader, int docId, String fieldName, FieldFragList fieldFragList, int maxNumFragments, String[] preTags, String[] postTags, Encoder encoder) throws IOException {
        if (maxNumFragments < 0) {
            throw new IllegalArgumentException("maxNumFragments(" + maxNumFragments + ") must be positive number.");
        }
        List<FieldFragList.WeightedFragInfo> fragInfos = this.getWeightedFragInfoList(fieldFragList.getFragInfos());
        ArrayList<String> fragments = new ArrayList<String>(maxNumFragments);
        Field[] values = this.getFields(reader, docId, fieldName);
        if (values.length == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int[] nextValueIndex = new int[]{0};
        for (int n = 0; n < maxNumFragments && n < fragInfos.size(); ++n) {
            FieldFragList.WeightedFragInfo fragInfo = fragInfos.get(n);
            fragments.add(this.makeFragment(buffer, nextValueIndex, values, fragInfo, preTags, postTags, encoder));
        }
        return fragments.toArray(new String[fragments.size()]);
    }

    @Deprecated
    protected String[] getFieldValues(IndexReader reader, int docId, String fieldName) throws IOException {
        Document doc = reader.document(docId, (FieldSelector)new MapFieldSelector(new String[]{fieldName}));
        return doc.getValues(fieldName);
    }

    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        Document doc = reader.document(docId, (FieldSelector)new MapFieldSelector(new String[]{fieldName}));
        return doc.getFields(fieldName);
    }

    @Deprecated
    protected String makeFragment(StringBuilder buffer, int[] index, String[] values, FieldFragList.WeightedFragInfo fragInfo) {
        int s = fragInfo.startOffset;
        return this.makeFragment(fragInfo, this.getFragmentSource(buffer, index, values, s, fragInfo.endOffset), s, this.preTags, this.postTags, NULL_ENCODER);
    }

    private String makeFragment(FieldFragList.WeightedFragInfo fragInfo, String src, int s, String[] preTags, String[] postTags, Encoder encoder) {
        StringBuilder fragment = new StringBuilder();
        int srcIndex = 0;
        for (FieldFragList.WeightedFragInfo.SubInfo subInfo : fragInfo.subInfos) {
            for (FieldPhraseList.WeightedPhraseInfo.Toffs to : subInfo.termsOffsets) {
                fragment.append(encoder.encodeText(src.substring(srcIndex, to.startOffset - s))).append(this.getPreTag(preTags, subInfo.seqnum)).append(encoder.encodeText(src.substring(to.startOffset - s, to.endOffset - s))).append(this.getPostTag(postTags, subInfo.seqnum));
                srcIndex = to.endOffset - s;
            }
        }
        fragment.append(encoder.encodeText(src.substring(srcIndex)));
        return fragment.toString();
    }

    protected String makeFragment(StringBuilder buffer, int[] index, Field[] values, FieldFragList.WeightedFragInfo fragInfo, String[] preTags, String[] postTags, Encoder encoder) {
        StringBuilder fragment = new StringBuilder();
        int s = fragInfo.getStartOffset();
        int[] modifiedStartOffset = new int[]{s};
        String src = this.getFragmentSourceMSO(buffer, index, values, s, fragInfo.getEndOffset(), modifiedStartOffset);
        int srcIndex = 0;
        for (FieldFragList.WeightedFragInfo.SubInfo subInfo : fragInfo.getSubInfos()) {
            for (FieldPhraseList.WeightedPhraseInfo.Toffs to : subInfo.getTermsOffsets()) {
                fragment.append(encoder.encodeText(src.substring(srcIndex, to.getStartOffset() - modifiedStartOffset[0]))).append(this.getPreTag(preTags, subInfo.getSeqnum())).append(encoder.encodeText(src.substring(to.getStartOffset() - modifiedStartOffset[0], to.getEndOffset() - modifiedStartOffset[0]))).append(this.getPostTag(postTags, subInfo.getSeqnum()));
                srcIndex = to.getEndOffset() - modifiedStartOffset[0];
            }
        }
        fragment.append(encoder.encodeText(src.substring(srcIndex)));
        return fragment.toString();
    }

    protected String getFragmentSourceMSO(StringBuilder buffer, int[] index, Field[] values, int startOffset, int endOffset, int[] modifiedStartOffset) {
        while (buffer.length() < endOffset && index[0] < values.length) {
            buffer.append(values[index[0]].stringValue());
            if (values[index[0]].isTokenized()) {
                buffer.append(this.getMultiValuedSeparator());
            }
            index[0] = index[0] + 1;
        }
        int eo = buffer.length() < endOffset ? buffer.length() : this.boundaryScanner.findEndOffset(buffer, endOffset);
        modifiedStartOffset[0] = this.boundaryScanner.findStartOffset(buffer, startOffset);
        return buffer.substring(modifiedStartOffset[0], eo);
    }

    @Deprecated
    protected String getFragmentSource(StringBuilder buffer, int[] index, String[] values, int startOffset, int endOffset) {
        while (buffer.length() < endOffset && index[0] < values.length) {
            buffer.append(values[index[0]]);
            buffer.append(this.multiValuedSeparator);
            index[0] = index[0] + 1;
        }
        int eo = buffer.length() < endOffset ? buffer.length() : endOffset;
        return buffer.substring(startOffset, eo);
    }

    protected String getFragmentSource(StringBuilder buffer, int[] index, Field[] values, int startOffset, int endOffset) {
        while (buffer.length() < endOffset && index[0] < values.length) {
            buffer.append(values[index[0]].stringValue());
            if (values[index[0]].isTokenized()) {
                buffer.append(this.multiValuedSeparator);
            }
            index[0] = index[0] + 1;
        }
        int eo = buffer.length() < endOffset ? buffer.length() : endOffset;
        return buffer.substring(startOffset, eo);
    }

    public void setMultiValuedSeparator(char separator) {
        this.multiValuedSeparator = separator;
    }

    public char getMultiValuedSeparator() {
        return this.multiValuedSeparator;
    }

    protected String getPreTag(int num) {
        return this.getPreTag(this.preTags, num);
    }

    protected String getPostTag(int num) {
        return this.getPostTag(this.postTags, num);
    }

    protected String getPreTag(String[] preTags, int num) {
        int n = num % preTags.length;
        return preTags[n];
    }

    protected String getPostTag(String[] postTags, int num) {
        int n = num % postTags.length;
        return postTags[n];
    }
}

