/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.queue.shard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.netflix.astyanax.recipes.queue.MessageQueueMetadata;
import com.netflix.astyanax.recipes.queue.MessageQueueShard;
import com.netflix.astyanax.recipes.queue.MessageQueueShardStats;
import com.netflix.astyanax.recipes.queue.shard.ShardReaderPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class TimePartitionedShardReaderPolicy
implements ShardReaderPolicy {
    public static final long DEFAULT_POLLING_INTERVAL = 1000L;
    public static final long NO_CATCHUP_POLLING_INTERVAL = 0L;
    private static final String SEPARATOR = ":";
    private final MessageQueueMetadata settings;
    private final List<MessageQueueShard> shards;
    private final Map<String, MessageQueueShardStats> shardStats;
    private final LinkedBlockingQueue<MessageQueueShard> workQueue = Queues.newLinkedBlockingQueue();
    private final LinkedBlockingQueue<MessageQueueShard> idleQueue = Queues.newLinkedBlockingQueue();
    private final long pollingInterval;
    private final long catchupPollingInterval;
    private int currentTimePartition = -1;

    private TimePartitionedShardReaderPolicy(Factory.Builder builder, MessageQueueMetadata metadata) {
        this.settings = metadata;
        this.pollingInterval = builder.pollingInterval;
        this.catchupPollingInterval = builder.catchupPollingInterval;
        this.shards = Lists.newArrayListWithCapacity((int)(metadata.getPartitionCount() * metadata.getShardCount()));
        for (int i = 0; i < metadata.getPartitionCount(); ++i) {
            for (int j = 0; j < metadata.getShardCount(); ++j) {
                this.shards.add(new MessageQueueShard(metadata.getQueueName() + SEPARATOR + i + SEPARATOR + j, i, j));
            }
        }
        ArrayList queues = Lists.newArrayList();
        this.shardStats = Maps.newHashMapWithExpectedSize((int)this.shards.size());
        for (MessageQueueShard shard : this.shards) {
            queues.add(shard);
            this.shardStats.put(shard.getName(), shard);
        }
        Collections.shuffle(queues);
        this.workQueue.addAll(queues);
    }

    private int getCurrentPartitionIndex() {
        if (this.settings.getPartitionCount() <= 1) {
            return 0;
        }
        return (int)(TimeUnit.MICROSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS) / this.settings.getPartitionDuration() % (long)this.settings.getPartitionCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageQueueShard nextShard() throws InterruptedException {
        int timePartition = this.getCurrentPartitionIndex();
        if (timePartition != this.currentTimePartition) {
            TimePartitionedShardReaderPolicy timePartitionedShardReaderPolicy = this;
            synchronized (timePartitionedShardReaderPolicy) {
                if (timePartition != this.currentTimePartition) {
                    this.currentTimePartition = timePartition;
                    ArrayList temp = Lists.newArrayListWithCapacity((int)this.idleQueue.size());
                    this.idleQueue.drainTo(temp);
                    for (MessageQueueShard partition : temp) {
                        if (partition.getPartition() == this.currentTimePartition) {
                            this.workQueue.add(partition);
                            continue;
                        }
                        this.idleQueue.add(partition);
                    }
                }
            }
        }
        return this.workQueue.take();
    }

    @Override
    public void releaseShard(MessageQueueShard shard, int messagesRead) {
        if (shard.getPartition() != this.currentTimePartition && messagesRead == 0) {
            this.idleQueue.add(shard);
        } else {
            this.workQueue.add(shard);
        }
    }

    @Override
    public Collection<MessageQueueShard> listShards() {
        return Collections.unmodifiableList(this.shards);
    }

    @Override
    public Map<String, MessageQueueShardStats> getShardStats() {
        return this.shardStats;
    }

    @Override
    public int getWorkQueueDepth() {
        return this.workQueue.size();
    }

    @Override
    public int getIdleQueueDepth() {
        return this.idleQueue.size();
    }

    @Override
    public boolean isCatchingUp() {
        return this.getWorkQueueDepth() > this.settings.getShardCount() * 2;
    }

    @Override
    public long getPollInterval() {
        return this.isCatchingUp() && this.catchupPollingInterval != 0L ? this.catchupPollingInterval : this.pollingInterval;
    }

    public static class Factory
    implements ShardReaderPolicy.Factory {
        private final Builder builder;

        public static Builder builder() {
            return new Builder();
        }

        public Factory(Builder builder) {
            this.builder = builder;
        }

        @Override
        public ShardReaderPolicy create(MessageQueueMetadata metadata) {
            return new TimePartitionedShardReaderPolicy(this.builder, metadata);
        }

        public static class Builder {
            private long pollingInterval = 1000L;
            private long catchupPollingInterval = 0L;

            public Builder withPollingInterval(long pollingInterval, TimeUnit units) {
                this.pollingInterval = TimeUnit.MILLISECONDS.convert(pollingInterval, units);
                return this;
            }

            public Builder withCatchupPollingInterval(long catchupPollingInterval, TimeUnit units) {
                this.catchupPollingInterval = TimeUnit.MILLISECONDS.convert(catchupPollingInterval, units);
                return this;
            }

            public Factory build() {
                return new Factory(this);
            }
        }
    }
}

