/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.queue;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.model.Equality;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.recipes.queue.CountingQueueStats;
import com.netflix.astyanax.recipes.queue.KeyExistsException;
import com.netflix.astyanax.recipes.queue.Message;
import com.netflix.astyanax.recipes.queue.MessageConsumer;
import com.netflix.astyanax.recipes.queue.MessageConsumerImpl;
import com.netflix.astyanax.recipes.queue.MessageHistory;
import com.netflix.astyanax.recipes.queue.MessageMetadataEntry;
import com.netflix.astyanax.recipes.queue.MessageMetadataEntryType;
import com.netflix.astyanax.recipes.queue.MessageProducer;
import com.netflix.astyanax.recipes.queue.MessageQueue;
import com.netflix.astyanax.recipes.queue.MessageQueueEntry;
import com.netflix.astyanax.recipes.queue.MessageQueueEntryState;
import com.netflix.astyanax.recipes.queue.MessageQueueEntryType;
import com.netflix.astyanax.recipes.queue.MessageQueueException;
import com.netflix.astyanax.recipes.queue.MessageQueueHooks;
import com.netflix.astyanax.recipes.queue.MessageQueueMetadata;
import com.netflix.astyanax.recipes.queue.MessageQueueShard;
import com.netflix.astyanax.recipes.queue.MessageQueueShardStats;
import com.netflix.astyanax.recipes.queue.MessageQueueStats;
import com.netflix.astyanax.recipes.queue.SendMessageResponse;
import com.netflix.astyanax.recipes.queue.ShardLockManager;
import com.netflix.astyanax.recipes.queue.shard.ModShardPolicy;
import com.netflix.astyanax.recipes.queue.shard.ShardReaderPolicy;
import com.netflix.astyanax.recipes.queue.shard.TimeModShardPolicy;
import com.netflix.astyanax.recipes.queue.shard.TimePartitionedShardReaderPolicy;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.retry.RunOnce;
import com.netflix.astyanax.serializers.AnnotatedCompositeSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.TimeUUIDSerializer;
import com.netflix.astyanax.util.RangeBuilder;
import com.netflix.astyanax.util.TimeUUIDUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedDistributedMessageQueue
implements MessageQueue {
    private static final Logger LOG = LoggerFactory.getLogger(ShardedDistributedMessageQueue.class);
    public static final char COMPOSITE_ID_DELIMITER = ':';
    public static final char COMPOSITE_KEY_DELIMITER = '$';
    public static final String DEFAULT_COLUMN_FAMILY_NAME = "Queues";
    public static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.CL_LOCAL_QUORUM;
    public static final RetryPolicy DEFAULT_RETRY_POLICY = RunOnce.get();
    public static final long DEFAULT_LOCK_TIMEOUT = TimeUnit.MICROSECONDS.convert(30L, TimeUnit.SECONDS);
    public static final Integer DEFAULT_LOCK_TTL = (int)TimeUnit.SECONDS.convert(2L, TimeUnit.MINUTES);
    public static final Integer DEFAULT_METADATA_DELETE_TTL = (int)TimeUnit.SECONDS.convert(2L, TimeUnit.SECONDS);
    public static final Boolean DEFAULT_POISON_QUEUE_ENABLED = false;
    public static final String DEFAULT_QUEUE_SUFFIX = "_queue";
    public static final String DEFAULT_METADATA_SUFFIX = "_metadata";
    public static final String DEFAULT_HISTORY_SUFFIX = "_history";
    public static final long SCHEMA_CHANGE_DELAY = 3000L;
    public static final ImmutableMap<String, Object> DEFAULT_COLUMN_FAMILY_SETTINGS = ImmutableMap.builder().put((Object)"read_repair_chance", (Object)1.0).put((Object)"gc_grace_seconds", (Object)5).put((Object)"compaction_strategy", (Object)"SizeTieredCompactionStrategy").build();
    static final AnnotatedCompositeSerializer<MessageQueueEntry> entrySerializer = new AnnotatedCompositeSerializer(MessageQueueEntry.class);
    static final AnnotatedCompositeSerializer<MessageMetadataEntry> metadataSerializer = new AnnotatedCompositeSerializer(MessageMetadataEntry.class);
    static final ObjectMapper mapper = new ObjectMapper();
    final ShardLockManager lockManager;
    final ColumnFamily<String, MessageQueueEntry> queueColumnFamily;
    final ColumnFamily<String, MessageMetadataEntry> keyIndexColumnFamily;
    final ColumnFamily<String, UUID> historyColumnFamily;
    final Keyspace keyspace;
    final ConsistencyLevel consistencyLevel;
    final long lockTimeout;
    final int lockTtl;
    final int metadataDeleteTTL;
    final Collection<MessageQueueHooks> hooks;
    final MessageQueueMetadata metadata;
    final Boolean bPoisonQueueEnabled;
    final Map<String, Object> columnFamilySettings;
    final ShardReaderPolicy shardReaderPolicy;
    final ModShardPolicy modShardPolicy;
    final Function<String, Message> invalidMessageHandler;
    final MessageQueueStats stats;
    final AtomicLong counter;

    private ShardedDistributedMessageQueue(Builder builder) throws MessageQueueException {
        mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.enableDefaultTyping();
        this.invalidMessageHandler = new Function<String, Message>(){

            public Message apply(String input) {
                LOG.warn("Invalid message: " + input);
                return null;
            }
        };
        this.counter = new AtomicLong(new Random().nextInt(1000));
        this.queueColumnFamily = ColumnFamily.newColumnFamily((String)(builder.columnFamilyName + DEFAULT_QUEUE_SUFFIX), (Serializer)StringSerializer.get(), entrySerializer);
        this.keyIndexColumnFamily = ColumnFamily.newColumnFamily((String)(builder.columnFamilyName + DEFAULT_METADATA_SUFFIX), (Serializer)StringSerializer.get(), metadataSerializer);
        this.historyColumnFamily = ColumnFamily.newColumnFamily((String)(builder.columnFamilyName + DEFAULT_HISTORY_SUFFIX), (Serializer)StringSerializer.get(), (Serializer)TimeUUIDSerializer.get());
        this.consistencyLevel = builder.consistencyLevel;
        this.keyspace = builder.keyspace;
        this.hooks = builder.hooks;
        this.modShardPolicy = builder.modShardPolicy;
        this.lockManager = builder.lockManager;
        this.lockTimeout = builder.lockTimeout;
        this.lockTtl = builder.lockTtl;
        this.bPoisonQueueEnabled = builder.bPoisonQueueEnabled;
        this.metadata = builder.metadata;
        this.columnFamilySettings = builder.columnFamilySettings;
        this.metadataDeleteTTL = builder.metadataDeleteTTL;
        this.stats = builder.stats;
        this.shardReaderPolicy = builder.shardReaderPolicyFactory.create(this.metadata);
    }

    String getShardKey(Message message) {
        return this.getShardKey(message.getTokenTime(), this.modShardPolicy.getMessageShard(message, this.metadata));
    }

    private String getShardKey(long messageTime, int modShard) {
        long timePartition = this.metadata.getPartitionDuration() != null ? messageTime / this.metadata.getPartitionDuration() % (long)this.metadata.getPartitionCount() : 0L;
        return this.getName() + ":" + timePartition + ":" + modShard;
    }

    String getCompositeKey(String name, String key) {
        return name + '$' + key;
    }

    private static String[] splitCompositeKey(String key) throws MessageQueueException {
        String[] parts = StringUtils.split((String)key, (char)'$');
        if (parts.length != 2) {
            throw new MessageQueueException("Invalid key '" + key + "'.  Expected format <queue|shard>$<name>. ");
        }
        return parts;
    }

    <T> String serializeToString(T trigger) throws JsonGenerationException, JsonMappingException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        mapper.writeValue((OutputStream)baos, trigger);
        baos.flush();
        return baos.toString();
    }

    private <T> T deserializeString(String data, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        return (T)mapper.readValue((InputStream)new ByteArrayInputStream(data.getBytes()), clazz);
    }

    private <T> T deserializeString(String data, String className) throws JsonParseException, JsonMappingException, IOException, ClassNotFoundException {
        return (T)mapper.readValue((InputStream)new ByteArrayInputStream(data.getBytes()), Class.forName(className));
    }

    @Override
    public String getName() {
        return this.metadata.getQueueName();
    }

    @Override
    public long getMessageCount() throws MessageQueueException {
        Map<String, Integer> counts = this.getShardCounts();
        long count = 0L;
        for (Integer value : counts.values()) {
            count += (long)value.intValue();
        }
        return count;
    }

    @Override
    public Map<String, Integer> getShardCounts() throws MessageQueueException {
        try {
            ArrayList keys = Lists.newArrayList();
            for (int i = 0; i < this.metadata.getPartitionCount(); ++i) {
                for (int j = 0; j < this.metadata.getShardCount(); ++j) {
                    keys.add(this.getName() + ":" + i + ":" + j);
                }
            }
            TreeMap result = Maps.newTreeMap();
            result.putAll((Map)this.keyspace.prepareQuery(this.queueColumnFamily).getKeySlice((Collection)keys).getColumnCounts().execute().getResult());
            return result;
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Failed to get counts", e);
        }
    }

    @Override
    public void clearMessages() throws MessageQueueException {
        LOG.info("Clearing messages from '" + this.getName() + "'");
        MutationBatch mb = this.keyspace.prepareMutationBatch().setConsistencyLevel(this.consistencyLevel);
        for (MessageQueueShard partition : this.shardReaderPolicy.listShards()) {
            mb.withRow(this.queueColumnFamily, (Object)partition.getName()).delete();
        }
        try {
            mb.execute();
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Failed to clear messages from queue " + this.getName(), e);
        }
    }

    @Override
    public void deleteQueue() throws MessageQueueException {
        LOG.info("Deleting queue '" + this.getName() + "'");
        MutationBatch mb = this.keyspace.prepareMutationBatch().setConsistencyLevel(this.consistencyLevel);
        for (MessageQueueShard partition : this.shardReaderPolicy.listShards()) {
            mb.withRow(this.queueColumnFamily, (Object)partition.getName()).delete();
        }
        mb.withRow(this.queueColumnFamily, (Object)this.getName());
        try {
            mb.execute();
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Failed to clear messages from queue " + this.getName(), e);
        }
    }

    @Override
    public Message peekMessage(String messageId) throws MessageQueueException {
        String[] parts = ShardedDistributedMessageQueue.splitCompositeKey(messageId);
        String shardKey = parts[0];
        MessageQueueEntry entry = new MessageQueueEntry(parts[1]);
        try {
            Column column = (Column)this.keyspace.prepareQuery(this.queueColumnFamily).setConsistencyLevel(this.consistencyLevel).getKey((Object)shardKey).getColumn((Object)entry).execute().getResult();
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(column.getByteArrayValue());
                return (Message)mapper.readValue((InputStream)bais, Message.class);
            }
            catch (Exception e) {
                LOG.warn("Error parsing message", (Throwable)e);
                try {
                    return (Message)this.invalidMessageHandler.apply((Object)column.getStringValue());
                }
                catch (Exception e2) {
                    LOG.warn("Error handling invalid message message", (Throwable)e2);
                    throw new MessageQueueException("Error parsing message " + messageId);
                }
            }
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Error getting message " + messageId, e);
        }
    }

    @Override
    public List<Message> peekMessagesByKey(String key) throws MessageQueueException {
        String groupRowKey = this.getCompositeKey(this.getName(), key);
        ArrayList messages = Lists.newArrayList();
        try {
            ColumnList columns = (ColumnList)this.keyspace.prepareQuery(this.keyIndexColumnFamily).getRow((Object)groupRowKey).withColumnRange((ByteBufferRange)metadataSerializer.buildRange().greaterThanEquals((Object)((byte)MessageMetadataEntryType.MessageId.ordinal())).lessThanEquals((Object)((byte)MessageMetadataEntryType.MessageId.ordinal())).build()).execute().getResult();
            for (Column entry : columns) {
                if (entry.getTtl() != 0) continue;
                Message message = this.peekMessage(((MessageMetadataEntry)entry.getName()).getName());
                if (message != null) {
                    messages.add(this.peekMessage(((MessageMetadataEntry)entry.getName()).getName()));
                    continue;
                }
                LOG.warn("No queue item for " + entry.getName());
            }
        }
        catch (NotFoundException e) {
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Error fetching row " + groupRowKey, e);
        }
        return messages;
    }

    @Override
    public Message peekMessageByKey(String key) throws MessageQueueException {
        String groupRowKey = this.getCompositeKey(this.getName(), key);
        try {
            ColumnList columns = (ColumnList)this.keyspace.prepareQuery(this.keyIndexColumnFamily).setConsistencyLevel(this.consistencyLevel).getRow((Object)groupRowKey).withColumnRange((ByteBufferRange)metadataSerializer.buildRange().greaterThanEquals((Object)((byte)MessageMetadataEntryType.MessageId.ordinal())).lessThanEquals((Object)((byte)MessageMetadataEntryType.MessageId.ordinal())).build()).execute().getResult();
            for (Column entry : columns) {
                if (entry.getTtl() != 0) continue;
                return this.peekMessage(((MessageMetadataEntry)entry.getName()).getName());
            }
            return null;
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Error fetching row " + groupRowKey, e);
        }
    }

    @Override
    public boolean deleteMessageByKey(String key) throws MessageQueueException {
        MutationBatch mb = this.keyspace.prepareMutationBatch().setConsistencyLevel(this.consistencyLevel);
        String groupRowKey = this.getCompositeKey(this.getName(), key);
        try {
            ColumnList columns = (ColumnList)this.keyspace.prepareQuery(this.keyIndexColumnFamily).setConsistencyLevel(this.consistencyLevel).getRow((Object)groupRowKey).withColumnRange((ByteBufferRange)metadataSerializer.buildRange().greaterThanEquals((Object)((byte)MessageMetadataEntryType.MessageId.ordinal())).lessThanEquals((Object)((byte)MessageMetadataEntryType.MessageId.ordinal())).build()).execute().getResult();
            for (Column entry : columns) {
                String[] parts = ShardedDistributedMessageQueue.splitCompositeKey(((MessageMetadataEntry)entry.getName()).getName());
                String shardKey = parts[0];
                MessageQueueEntry queueEntry = new MessageQueueEntry(parts[1]);
                mb.withRow(this.queueColumnFamily, (Object)shardKey).deleteColumn((Object)queueEntry);
            }
            mb.withRow(this.keyIndexColumnFamily, (Object)groupRowKey).delete();
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Error fetching row " + groupRowKey, e);
        }
        try {
            mb.execute();
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Error deleting queue item " + groupRowKey, e);
        }
        return true;
    }

    @Override
    public void deleteMessage(String messageId) throws MessageQueueException {
        String[] parts = ShardedDistributedMessageQueue.splitCompositeKey(messageId);
        String shardKey = parts[0];
        MessageQueueEntry entry = new MessageQueueEntry(parts[1]);
        try {
            this.keyspace.prepareColumnMutation(this.queueColumnFamily, (Object)shardKey, (Object)entry).setConsistencyLevel(this.consistencyLevel).deleteColumn().execute();
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Error deleting message " + messageId, e);
        }
    }

    @Override
    public void deleteMessages(Collection<String> messageIds) throws MessageQueueException {
        MutationBatch mb = this.keyspace.prepareMutationBatch().setConsistencyLevel(this.consistencyLevel);
        for (String messageId : messageIds) {
            String[] parts = ShardedDistributedMessageQueue.splitCompositeKey(messageId);
            String shardKey = parts[0];
            MessageQueueEntry entry = new MessageQueueEntry(parts[1]);
            mb.withRow(this.queueColumnFamily, (Object)shardKey).deleteColumn((Object)entry);
        }
        try {
            mb.execute();
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Error deleting messages " + messageIds, e);
        }
    }

    private void changeSchema(Callable<Void> callable) throws MessageQueueException {
        for (int i = 0; i < 3; ++i) {
            try {
                callable.call();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new MessageQueueException("Interrupted while trying to create column family for queue " + this.getName(), ie);
                }
                return;
            }
            catch (SchemaDisagreementException e) {
                try {
                    Thread.sleep(3000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new MessageQueueException("Interrupted while trying to create column family for queue " + this.getName(), ie);
                }
            }
            catch (Exception e) {
                if (e.getMessage().contains("already exist")) {
                    return;
                }
                throw new MessageQueueException("Failed to create column family for " + this.queueColumnFamily.getName(), e);
            }
        }
    }

    @Override
    public void createStorage() throws MessageQueueException {
        this.changeSchema(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ShardedDistributedMessageQueue.this.keyspace.createColumnFamily(ShardedDistributedMessageQueue.this.queueColumnFamily, (Map)ImmutableMap.builder().put((Object)"key_validation_class", (Object)"UTF8Type").put((Object)"comparator_type", (Object)"CompositeType(BytesType, BytesType(reversed=true), TimeUUIDType, TimeUUIDType, BytesType)").putAll(ShardedDistributedMessageQueue.this.columnFamilySettings).build());
                return null;
            }
        });
        this.changeSchema(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ShardedDistributedMessageQueue.this.keyspace.createColumnFamily(ShardedDistributedMessageQueue.this.keyIndexColumnFamily, (Map)ImmutableMap.builder().put((Object)"key_validation_class", (Object)"UTF8Type").put((Object)"comparator_type", (Object)"CompositeType(BytesType, UTF8Type)").putAll(ShardedDistributedMessageQueue.this.columnFamilySettings).build());
                return null;
            }
        });
        this.changeSchema(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ShardedDistributedMessageQueue.this.keyspace.createColumnFamily(ShardedDistributedMessageQueue.this.historyColumnFamily, (Map)ImmutableMap.builder().put((Object)"default_validation_class", (Object)"UTF8Type").putAll(ShardedDistributedMessageQueue.this.columnFamilySettings).build());
                return null;
            }
        });
    }

    @Override
    public void dropStorage() throws MessageQueueException {
        block9: {
            block8: {
                try {
                    this.keyspace.dropColumnFamily(this.queueColumnFamily);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {}
                }
                catch (ConnectionException e) {
                    if (e.getMessage().contains("already exist")) break block8;
                    throw new MessageQueueException("Failed to create column family for " + this.queueColumnFamily.getName(), e);
                }
            }
            try {
                this.keyspace.dropColumnFamily(this.keyIndexColumnFamily);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {}
            }
            catch (ConnectionException e) {
                if (e.getMessage().contains("already exist")) break block9;
                throw new MessageQueueException("Failed to create column family for " + this.queueColumnFamily.getName(), e);
            }
        }
    }

    @Override
    public void createQueue() throws MessageQueueException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mapper.writeValue((OutputStream)baos, (Object)this.metadata);
            baos.flush();
            this.keyspace.prepareColumnMutation(this.queueColumnFamily, (Object)this.getName(), (Object)MessageQueueEntry.newMetadataEntry()).putValue(baos.toByteArray(), null).execute();
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Failed to create column family for " + this.queueColumnFamily.getName(), e);
        }
        catch (Exception e) {
            throw new MessageQueueException("Error serializing queue settings " + this.queueColumnFamily.getName(), e);
        }
    }

    @Override
    public MessageConsumer createConsumer() {
        return new MessageConsumerImpl(this);
    }

    @Override
    public MessageProducer createProducer() {
        return new MessageProducer(){

            @Override
            public String sendMessage(Message message) throws MessageQueueException {
                SendMessageResponse response = this.sendMessages(Lists.newArrayList((Object[])new Message[]{message}));
                if (!response.getNotUnique().isEmpty()) {
                    throw new KeyExistsException("Key already exists ." + message.getKey());
                }
                return (String)((Map.Entry)Iterables.getFirst(response.getMessages().entrySet(), null)).getKey();
            }

            @Override
            public SendMessageResponse sendMessages(Collection<Message> messages) throws MessageQueueException {
                HashMap uniqueKeys = Maps.newHashMap();
                HashSet notUniqueKeys = Sets.newHashSet();
                ArrayList notUniqueMessages = Lists.newArrayList();
                MutationBatch mb = ShardedDistributedMessageQueue.this.keyspace.prepareMutationBatch().setConsistencyLevel(ShardedDistributedMessageQueue.this.consistencyLevel);
                MessageMetadataEntry lockColumn = MessageMetadataEntry.newUnique();
                for (Message message : messages) {
                    if (!message.hasUniqueKey()) continue;
                    String groupKey = ShardedDistributedMessageQueue.this.getCompositeKey(ShardedDistributedMessageQueue.this.getName(), message.getKey());
                    uniqueKeys.put(groupKey, message);
                    mb.withRow(ShardedDistributedMessageQueue.this.keyIndexColumnFamily, (Object)groupKey).putEmptyColumn((Object)lockColumn, Integer.valueOf(ShardedDistributedMessageQueue.this.lockTtl));
                }
                if (!uniqueKeys.isEmpty()) {
                    Rows result;
                    try {
                        mb.execute();
                    }
                    catch (ConnectionException e) {
                        throw new MessageQueueException("Failed to check keys for uniqueness (1): " + uniqueKeys, e);
                    }
                    mb = ShardedDistributedMessageQueue.this.keyspace.prepareMutationBatch().setConsistencyLevel(ShardedDistributedMessageQueue.this.consistencyLevel);
                    try {
                        result = (Rows)ShardedDistributedMessageQueue.this.keyspace.prepareQuery(ShardedDistributedMessageQueue.this.keyIndexColumnFamily).setConsistencyLevel(ShardedDistributedMessageQueue.this.consistencyLevel).getRowSlice(uniqueKeys.keySet()).withColumnRange((ByteBufferRange)metadataSerializer.buildRange().greaterThanEquals((Object)((byte)MessageMetadataEntryType.Unique.ordinal())).lessThanEquals((Object)((byte)MessageMetadataEntryType.Unique.ordinal())).build()).execute().getResult();
                    }
                    catch (ConnectionException e) {
                        throw new MessageQueueException("Failed to check keys for uniqueness (2): " + uniqueKeys, e);
                    }
                    for (Row row : result) {
                        if (row.getColumns().size() != 1) {
                            String messageKey = ShardedDistributedMessageQueue.splitCompositeKey((String)row.getKey())[1];
                            notUniqueKeys.add(messageKey);
                            notUniqueMessages.add(uniqueKeys.get(messageKey));
                            mb.withRow(ShardedDistributedMessageQueue.this.keyIndexColumnFamily, row.getKey()).deleteColumn((Object)lockColumn);
                            continue;
                        }
                        mb.withRow(ShardedDistributedMessageQueue.this.keyIndexColumnFamily, row.getKey()).putEmptyColumn((Object)lockColumn);
                    }
                }
                LinkedHashMap success = Maps.newLinkedHashMap();
                for (Message message : messages) {
                    if (message.hasKey() && notUniqueKeys.contains(message.getKey())) continue;
                    String messageId = ShardedDistributedMessageQueue.this.fillMessageMutation(mb, message);
                    success.put(messageId, message);
                }
                try {
                    mb.execute();
                }
                catch (ConnectionException e) {
                    throw new MessageQueueException("Failed to insert messages into queue.", e);
                }
                return new SendMessageResponse(success, notUniqueMessages);
            }
        };
    }

    String fillMessageMutation(MutationBatch mb, Message message) throws MessageQueueException {
        long curTimeMicros = !message.hasTrigger() ? TimeUnit.MICROSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS) : TimeUnit.MICROSECONDS.convert(message.getTrigger().getTriggerTime(), TimeUnit.MILLISECONDS);
        message.setToken(TimeUUIDUtils.getMicrosTimeUUID((long)(curTimeMicros += this.counter.incrementAndGet() % 1000L)));
        MessageQueueEntry entry = MessageQueueEntry.newMessageEntry(message.getPriority(), message.getToken(), MessageQueueEntryState.Waiting);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            mapper.writeValue((OutputStream)baos, (Object)message);
            baos.flush();
        }
        catch (Exception e) {
            throw new MessageQueueException("Failed to serialize message data: " + message, e);
        }
        String shardKey = this.getShardKey(message);
        mb.withRow(this.queueColumnFamily, (Object)shardKey).putColumn((Object)entry, new String(baos.toByteArray()), this.metadata.getRetentionTimeout());
        if (message.hasKey()) {
            mb.withRow(this.keyIndexColumnFamily, (Object)this.getCompositeKey(this.getName(), message.getKey())).putEmptyColumn((Object)MessageMetadataEntry.newMessageId(this.getCompositeKey(shardKey, entry.getMessageId())), this.metadata.getRetentionTimeout());
        }
        for (MessageQueueHooks hook : this.hooks) {
            hook.beforeSendMessage(message, mb);
        }
        this.stats.incSendMessageCount();
        return this.getCompositeKey(shardKey, entry.getMessageId());
    }

    @Override
    public List<MessageHistory> getKeyHistory(String key, Long startTime, Long endTime, int count) throws MessageQueueException {
        ColumnList columns;
        ArrayList list = Lists.newArrayList();
        try {
            columns = (ColumnList)this.keyspace.prepareQuery(this.historyColumnFamily).setConsistencyLevel(this.consistencyLevel).getRow((Object)key).execute().getResult();
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Failed to load history for " + key, e);
        }
        for (Column column : columns) {
            try {
                list.add(this.deserializeString(column.getStringValue(), MessageHistory.class));
            }
            catch (Exception e) {
                LOG.info("Error deserializing history entry", (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public List<Message> peekMessages(int itemsToPeek) throws MessageQueueException {
        ArrayList messages = Lists.newArrayList();
        for (MessageQueueShard shard : this.shardReaderPolicy.listShards()) {
            messages.addAll(this.peekMessages(shard.getName(), itemsToPeek - messages.size()));
            if (messages.size() != itemsToPeek) continue;
            return messages;
        }
        return messages;
    }

    private Collection<Message> peekMessages(String shardName, int itemsToPeek) throws MessageQueueException {
        try {
            ColumnList result = (ColumnList)this.keyspace.prepareQuery(this.queueColumnFamily).setConsistencyLevel(this.consistencyLevel).getKey((Object)shardName).withColumnRange(new RangeBuilder().setLimit(itemsToPeek).setStart(entrySerializer.makeEndpoint((Object)((byte)MessageQueueEntryType.Message.ordinal()), Equality.GREATER_THAN_EQUALS).toBytes()).setEnd(entrySerializer.makeEndpoint((Object)((byte)MessageQueueEntryType.Message.ordinal()), Equality.LESS_THAN_EQUALS).toBytes()).build()).execute().getResult();
            ArrayList messages = Lists.newArrayListWithCapacity((int)result.size());
            for (Column column : result) {
                Message message = this.extractMessageFromColumn((Column<MessageQueueEntry>)column);
                if (message == null) continue;
                messages.add(message);
            }
            return messages;
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Error peeking for messages from shard " + shardName, e);
        }
    }

    Message extractMessageFromColumn(Column<MessageQueueEntry> column) {
        Message message = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(column.getByteArrayValue());
            message = (Message)mapper.readValue((InputStream)bais, Message.class);
        }
        catch (Exception e) {
            LOG.warn("Error processing message ", (Throwable)e);
            try {
                message = (Message)this.invalidMessageHandler.apply((Object)column.getStringValue());
            }
            catch (Exception e2) {
                LOG.warn("Error processing invalid message", (Throwable)e2);
            }
        }
        return message;
    }

    private boolean hasMessages(String shardName) throws MessageQueueException {
        UUID currentTime = TimeUUIDUtils.getUniqueTimeUUIDinMicros();
        try {
            ColumnList result = (ColumnList)this.keyspace.prepareQuery(this.queueColumnFamily).setConsistencyLevel(this.consistencyLevel).getKey((Object)shardName).withColumnRange(new RangeBuilder().setLimit(1).setStart(entrySerializer.makeEndpoint((Object)((byte)MessageQueueEntryType.Message.ordinal()), Equality.EQUAL).toBytes()).setEnd(entrySerializer.makeEndpoint((Object)((byte)MessageQueueEntryType.Message.ordinal()), Equality.EQUAL).append((Object)0, Equality.EQUAL).append((Object)currentTime, Equality.LESS_THAN_EQUALS).toBytes()).build()).execute().getResult();
            return !result.isEmpty();
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Error checking shard for messages. " + shardName, e);
        }
    }

    @Override
    public Map<String, MessageQueueShardStats> getShardStats() {
        return this.shardReaderPolicy.getShardStats();
    }

    public ShardReaderPolicy getShardReaderPolicy() {
        return this.shardReaderPolicy;
    }

    public ColumnFamily<String, MessageQueueEntry> getQueueColumnFamily() {
        return this.queueColumnFamily;
    }

    public ColumnFamily<String, MessageMetadataEntry> getKeyIndexColumnFamily() {
        return this.keyIndexColumnFamily;
    }

    public ColumnFamily<String, UUID> getHistoryColumnFamily() {
        return this.historyColumnFamily;
    }

    public static class Builder {
        private String columnFamilyName = "Queues";
        private ShardLockManager lockManager;
        private Keyspace keyspace;
        private ConsistencyLevel consistencyLevel = DEFAULT_CONSISTENCY_LEVEL;
        private long lockTimeout = DEFAULT_LOCK_TIMEOUT;
        private int lockTtl = DEFAULT_LOCK_TTL;
        private String queueName = "Queue";
        private int metadataDeleteTTL = DEFAULT_METADATA_DELETE_TTL;
        private Collection<MessageQueueHooks> hooks = Lists.newArrayList();
        private MessageQueueMetadata metadata = new MessageQueueMetadata();
        private MessageQueueStats stats;
        private Boolean bPoisonQueueEnabled = DEFAULT_POISON_QUEUE_ENABLED;
        private Map<String, Object> columnFamilySettings = DEFAULT_COLUMN_FAMILY_SETTINGS;
        private ShardReaderPolicy.Factory shardReaderPolicyFactory;
        private ModShardPolicy modShardPolicy;

        public Builder() {
            this.metadata.setQueueName(this.queueName);
        }

        public Builder withColumnFamily(String columnFamilyName) {
            this.columnFamilyName = columnFamilyName;
            return this;
        }

        public Builder withMetadata(MessageQueueMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder withShardCount(int count) {
            this.metadata.setShardCount(count);
            return this;
        }

        public Builder withTimeBuckets(int bucketCount, int bucketDuration, TimeUnit units) {
            this.metadata.setPartitionDuration(TimeUnit.MICROSECONDS.convert(bucketDuration, units));
            this.metadata.setPartitionCount(bucketCount);
            return this;
        }

        public Builder withBuckets(int bucketCount, int bucketDuration, TimeUnit units) {
            return this.withTimeBuckets(bucketCount, bucketDuration, units);
        }

        public Builder withRetentionTimeout(Long timeout, TimeUnit units) {
            this.metadata.setRetentionTimeout(timeout, units);
            return this;
        }

        public Builder withLockTimeout(Long timeout, TimeUnit units) {
            this.lockTimeout = TimeUnit.MICROSECONDS.convert(timeout, units);
            return this;
        }

        public Builder withLockTtl(Long ttl, TimeUnit units) {
            this.lockTtl = (int)TimeUnit.SECONDS.convert(ttl, units);
            return this;
        }

        @Deprecated
        public Builder withPollInterval(Long internval, TimeUnit units) {
            this.metadata.setPollInterval(TimeUnit.MILLISECONDS.convert(internval, units));
            return this;
        }

        public Builder withQueueName(String queueName) {
            this.metadata.setQueueName(queueName);
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevel level) {
            this.consistencyLevel = level;
            return this;
        }

        public Builder withColumnFamilySettings(Map<String, Object> settings) {
            this.columnFamilySettings = settings;
            return this;
        }

        public Builder withKeyspace(Keyspace keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public Builder withStats(MessageQueueStats stats) {
            this.stats = stats;
            return this;
        }

        public Builder withHook(MessageQueueHooks hooks) {
            this.hooks.add(hooks);
            return this;
        }

        public Builder withHooks(Collection<MessageQueueHooks> hooks) {
            this.hooks.addAll(hooks);
            return this;
        }

        public Builder withPoisonQueue(Boolean enabled) {
            this.bPoisonQueueEnabled = enabled;
            return this;
        }

        public Builder withModShardPolicy(ModShardPolicy policy) {
            this.modShardPolicy = policy;
            return this;
        }

        public Builder withShardReaderPolicy(final ShardReaderPolicy shardReaderPolicy) {
            this.shardReaderPolicyFactory = new ShardReaderPolicy.Factory(){

                @Override
                public ShardReaderPolicy create(MessageQueueMetadata metadata) {
                    return shardReaderPolicy;
                }
            };
            return this;
        }

        public Builder withShardReaderPolicy(ShardReaderPolicy.Factory shardReaderPolicyFactory) {
            this.shardReaderPolicyFactory = shardReaderPolicyFactory;
            return this;
        }

        public Builder withShardLockManager(ShardLockManager mgr) {
            this.lockManager = mgr;
            return this;
        }

        public ShardedDistributedMessageQueue build() throws MessageQueueException {
            Preconditions.checkArgument((TimeUnit.SECONDS.convert(this.lockTimeout, TimeUnit.MICROSECONDS) < (long)this.lockTtl ? 1 : 0) != 0, (Object)("Timeout " + this.lockTtl + " seconds must be less than TTL " + TimeUnit.SECONDS.convert(this.lockTtl, TimeUnit.MICROSECONDS) + " seconds"));
            Preconditions.checkNotNull((Object)this.keyspace, (Object)"Must specify keyspace");
            if (this.shardReaderPolicyFactory == null) {
                this.shardReaderPolicyFactory = TimePartitionedShardReaderPolicy.Factory.builder().build();
            }
            if (this.modShardPolicy == null) {
                this.modShardPolicy = TimeModShardPolicy.getInstance();
            }
            if (this.stats == null) {
                this.stats = new CountingQueueStats();
            }
            return new ShardedDistributedMessageQueue(this);
        }
    }
}

