/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.writes;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.Clock;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.ConsistencyLevelMapping;
import com.netflix.astyanax.cql.CqlAbstractExecutionImpl;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.writes.AbstractMutationBatchImpl;
import com.netflix.astyanax.cql.writes.CFMutationQueryGen;
import com.netflix.astyanax.cql.writes.CqlColumnListMutationImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.retry.RetryPolicy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CqlMutationBatchImpl
extends AbstractMutationBatchImpl {
    private final CqlKeyspaceImpl.KeyspaceContext ksContext;
    private boolean useCaching = false;

    public CqlMutationBatchImpl(CqlKeyspaceImpl.KeyspaceContext ksCtx, Clock clock, ConsistencyLevel consistencyLevel, RetryPolicy retry) {
        super(clock, consistencyLevel, retry);
        this.ksContext = ksCtx;
    }

    @Override
    public <K, C> ColumnListMutation<C> createColumnListMutation(String keyspace, ColumnFamily<K, C> cf, K rowKey) {
        return new CqlColumnListMutationImpl<K, C>(this.ksContext, cf, rowKey, this.getConsistencyLevel(), this.timestamp);
    }

    @Override
    public void mergeColumnListMutation(ColumnListMutation<?> from, ColumnListMutation<?> to) {
        CqlColumnListMutationImpl fromCqlListMutation = (CqlColumnListMutationImpl)from;
        CqlColumnListMutationImpl toCqlListMutation = (CqlColumnListMutationImpl)to;
        toCqlListMutation.mergeColumnListMutation(fromCqlListMutation);
    }

    public OperationResult<Void> execute() throws ConnectionException {
        return new CqlAbstractExecutionImpl<Void>(this.ksContext, this.getRetryPolicy()){

            @Override
            public CassandraOperationType getOperationType() {
                return CassandraOperationType.BATCH_MUTATE;
            }

            @Override
            public Statement getQuery() {
                return CqlMutationBatchImpl.this.getCachedPreparedStatement();
            }

            @Override
            public Void parseResultSet(ResultSet resultSet) {
                return null;
            }
        }.execute();
    }

    public ListenableFuture<OperationResult<Void>> executeAsync() throws ConnectionException {
        return new CqlAbstractExecutionImpl<Void>(this.ksContext, this.getRetryPolicy()){

            @Override
            public CassandraOperationType getOperationType() {
                return CassandraOperationType.BATCH_MUTATE;
            }

            @Override
            public Statement getQuery() {
                return CqlMutationBatchImpl.this.getCachedPreparedStatement();
            }

            @Override
            public Void parseResultSet(ResultSet resultSet) {
                return null;
            }
        }.executeAsync();
    }

    private List<CqlColumnListMutationImpl<?, ?>> getColumnMutations() {
        ArrayList colListMutation = new ArrayList();
        for (Map.Entry<ByteBuffer, Map<String, ColumnListMutation<?>>> entry : super.getMutationMap().entrySet()) {
            for (ColumnListMutation<?> colMutation : entry.getValue().values()) {
                colListMutation.add((CqlColumnListMutationImpl)colMutation);
            }
        }
        return colListMutation;
    }

    private BatchStatement getCachedPreparedStatement() {
        List<CqlColumnListMutationImpl<?, ?>> colListMutations = this.getColumnMutations();
        if (colListMutations == null || colListMutations.size() == 0) {
            return new BatchStatement(BatchStatement.Type.UNLOGGED);
        }
        CqlColumnListMutationImpl.ColListMutationType mutationType = colListMutations.get(0).getType();
        BatchStatement batch = new BatchStatement(BatchStatement.Type.UNLOGGED);
        if (mutationType == CqlColumnListMutationImpl.ColListMutationType.CounterColumnsUpdate) {
            batch = new BatchStatement(BatchStatement.Type.COUNTER);
        } else if (this.useAtomicBatch()) {
            batch = new BatchStatement(BatchStatement.Type.LOGGED);
        }
        for (CqlColumnListMutationImpl<?, ?> colListMutation : colListMutations) {
            CFMutationQueryGen queryGen = colListMutation.getMutationQueryGen();
            queryGen.addColumnListMutationToBatch(batch, colListMutation, this.useCaching);
        }
        batch.setConsistencyLevel(ConsistencyLevelMapping.getCL(this.getConsistencyLevel()));
        return batch;
    }

    public MutationBatch withCaching(boolean condition) {
        this.useCaching = condition;
        return this;
    }
}

