/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads.model;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Row;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.reads.model.CqlColumnImpl;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.cql.util.CqlTypeMapping;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;

public class CqlColumnListImpl<C>
implements ColumnList<C> {
    private List<Column<C>> columnList = new ArrayList<Column<C>>();
    private LinkedHashMap<C, Column<C>> map = new LinkedHashMap();

    public CqlColumnListImpl() {
    }

    public CqlColumnListImpl(Row row, ColumnFamily<?, ?> cf) {
        ColumnDefinitions cfDefinitions = row.getColumnDefinitions();
        for (int index = 1; index < cfDefinitions.size(); index += 3) {
            String columnName = cfDefinitions.getName(index);
            CqlColumnImpl<String> cqlCol = new CqlColumnImpl<String>(columnName, row, index);
            this.columnList.add(cqlCol);
            this.map.put(columnName, cqlCol);
        }
    }

    public CqlColumnListImpl(List<Row> rows, ColumnFamily<?, ?> cf) {
        CqlColumnFamilyDefinitionImpl cfDef = (CqlColumnFamilyDefinitionImpl)cf.getColumnFamilyDefinition();
        int columnNameIndex = cfDef.getPartitionKeyColumnDefinitionList().size();
        for (Row row : rows) {
            Object columnName = CqlTypeMapping.getDynamicColumn(row, cf.getColumnSerializer(), columnNameIndex, cf);
            int valueIndex = cfDef.getPartitionKeyColumnDefinitionList().size() + cfDef.getClusteringKeyColumnDefinitionList().size();
            CqlColumnImpl<Object> cqlCol = new CqlColumnImpl<Object>(columnName, row, valueIndex);
            this.columnList.add(cqlCol);
            this.map.put(columnName, cqlCol);
        }
    }

    public CqlColumnListImpl(List<CqlColumnImpl<C>> newColumnList) {
        this.columnList.clear();
        for (Column column : newColumnList) {
            this.columnList.add(column);
            this.map.put(column.getName(), column);
        }
    }

    public void trimFirstColumn() {
        if (this.columnList.size() == 0) {
            return;
        }
        Column<C> firstCol = this.columnList.remove(0);
        this.map.remove(firstCol.getName());
    }

    public Iterator<Column<C>> iterator() {
        return this.columnList.iterator();
    }

    public Collection<C> getColumnNames() {
        return this.map.keySet();
    }

    public Column<C> getColumnByName(C columnName) {
        return this.map.get(columnName);
    }

    public String getStringValue(C columnName, String defaultValue) {
        Column<C> column = this.map.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getStringValue();
    }

    public String getCompressedStringValue(C columnName, String defaultValue) {
        Column<C> column = this.map.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getCompressedStringValue();
    }

    public Integer getIntegerValue(C columnName, Integer defaultValue) {
        Column<C> column = this.map.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getIntegerValue();
    }

    public Double getDoubleValue(C columnName, Double defaultValue) {
        Column<C> column = this.map.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getDoubleValue();
    }

    public Long getLongValue(C columnName, Long defaultValue) {
        Column<C> column = this.map.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getLongValue();
    }

    public byte[] getByteArrayValue(C columnName, byte[] defaultValue) {
        Column<C> column = this.map.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getByteArrayValue();
    }

    public Boolean getBooleanValue(C columnName, Boolean defaultValue) {
        Column<C> column = this.map.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getBooleanValue();
    }

    public ByteBuffer getByteBufferValue(C columnName, ByteBuffer defaultValue) {
        Column<C> column = this.map.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getByteBufferValue();
    }

    public <T> T getValue(C columnName, Serializer<T> serializer, T defaultValue) {
        Column<C> column = this.map.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return (T)column.getValue(serializer);
    }

    public Date getDateValue(C columnName, Date defaultValue) {
        Column<C> column = this.map.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getDateValue();
    }

    public UUID getUUIDValue(C columnName, UUID defaultValue) {
        Column<C> column = this.map.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getUUIDValue();
    }

    public Column<C> getColumnByIndex(int idx) {
        return this.columnList.get(idx);
    }

    public <C2> Column<C2> getSuperColumn(C columnName, Serializer<C2> colSer) {
        throw new UnsupportedOperationException("Operaiton not supported");
    }

    public <C2> Column<C2> getSuperColumn(int idx, Serializer<C2> colSer) {
        throw new UnsupportedOperationException("Operaiton not supported");
    }

    public boolean isEmpty() {
        return this.columnList.size() == 0;
    }

    public int size() {
        return this.columnList.size();
    }

    public boolean isSuperColumn() {
        throw new UnsupportedOperationException("Operaiton not supported");
    }
}

