/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.patterns;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.gcube.data.trees.constraints.After;
import org.gcube.data.trees.constraints.AfterDate;
import org.gcube.data.trees.constraints.All;
import org.gcube.data.trees.constraints.AnyValue;
import org.gcube.data.trees.constraints.Before;
import org.gcube.data.trees.constraints.BeforeDate;
import org.gcube.data.trees.constraints.Constraint;
import org.gcube.data.trees.constraints.Either;
import org.gcube.data.trees.constraints.Less;
import org.gcube.data.trees.constraints.Match;
import org.gcube.data.trees.constraints.More;
import org.gcube.data.trees.constraints.Not;
import org.gcube.data.trees.constraints.Same;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.patterns.AbstractPattern;
import org.gcube.data.trees.patterns.AnyPattern;
import org.gcube.data.trees.patterns.AtLeastPattern;
import org.gcube.data.trees.patterns.BoolPattern;
import org.gcube.data.trees.patterns.CalendarPattern;
import org.gcube.data.trees.patterns.CutTreePattern;
import org.gcube.data.trees.patterns.DatePattern;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.LeafPattern;
import org.gcube.data.trees.patterns.ManyPattern;
import org.gcube.data.trees.patterns.NumPattern;
import org.gcube.data.trees.patterns.OnePattern;
import org.gcube.data.trees.patterns.OnlyPattern;
import org.gcube.data.trees.patterns.OptPattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.TextPattern;
import org.gcube.data.trees.patterns.TreePattern;
import org.gcube.data.trees.patterns.URIPattern;

public class Patterns {
    private static JAXBContext context;
    public static final QName any;
    public static final boolean C = true;
    public static final AnyValue anyval;

    static {
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{TreePattern.class});
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        any = new QName(".*", ".*");
        anyval = new AnyValue();
    }

    public static Marshaller getMarshaller() throws JAXBException {
        return context.createMarshaller();
    }

    public static Unmarshaller getUnMarshaller() throws JAXBException {
        return context.createUnmarshaller();
    }

    public static final AnyPattern any() {
        return new AnyPattern();
    }

    public static final Pattern clone(Pattern pattern) throws Exception {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(s);
        os.writeObject(pattern);
        os.close();
        ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(s.toByteArray()));
        return (Pattern)is.readObject();
    }

    public static final EdgePattern clone(EdgePattern pattern) throws Exception {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(s);
        os.writeObject(pattern);
        os.close();
        ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(s.toByteArray()));
        return (EdgePattern)is.readObject();
    }

    public static final TreePattern tree(EdgePattern ... patterns) {
        return new TreePattern(Arrays.asList(patterns));
    }

    public static final Pattern hasPath(String ... ids) throws IllegalArgumentException {
        if (ids == null || ids.length < 1) {
            throw new IllegalArgumentException();
        }
        AbstractPattern p = Patterns.id(ids[ids.length - 1], Patterns.any());
        int i = ids.length - 2;
        while (i >= 0) {
            p = Patterns.id(ids[i], Patterns.tree(Patterns.atleast(any, (Pattern)p)));
            --i;
        }
        return p;
    }

    public static final TreePattern hasLabelPath(String ... labels) throws IllegalArgumentException {
        ArrayList<QName> qnames = new ArrayList<QName>();
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            qnames.add(new QName(label));
            ++n2;
        }
        return Patterns.hasLabelPath(qnames.toArray(new QName[0]));
    }

    public static final TreePattern hasLabelPath(QName ... labels) throws IllegalArgumentException {
        if (labels == null || labels.length < 1) {
            throw new IllegalArgumentException();
        }
        TreePattern p = Patterns.tree(Patterns.atleast(labels[labels.length - 1], (Pattern)Patterns.any()));
        int i = labels.length - 2;
        while (i >= 0) {
            p = Patterns.tree(Patterns.atleast(labels[i], (Pattern)p));
            --i;
        }
        return p;
    }

    public static EdgePattern cond(EdgePattern p) {
        p.setAsCondition();
        return p;
    }

    public static final <T extends AbstractPattern> T id(LeafPattern<?, ?> idp, T p) {
        p.setIdPattern(idp);
        return p;
    }

    public static final <T extends AbstractPattern> T id(String identifier, T pattern) {
        return Patterns.id(Patterns.text(Patterns.is(identifier)), pattern);
    }

    public static final OnePattern one(QName label, Pattern pattern) {
        return new OnePattern(label, pattern);
    }

    public static final OnePattern one(String label, Pattern pattern) {
        return Patterns.one(Nodes.q(label), pattern);
    }

    public static final OptPattern opt(QName label, Pattern pattern) {
        return new OptPattern(label, pattern);
    }

    public static final OptPattern opt(String label, Pattern pattern) {
        return Patterns.opt(Nodes.q(label), pattern);
    }

    public static final AtLeastPattern atleast(QName label, Pattern pattern) {
        return new AtLeastPattern(label, pattern);
    }

    public static final AtLeastPattern atleast(String label, Pattern pattern) {
        return Patterns.atleast(Nodes.q(label), pattern);
    }

    public static final ManyPattern many(QName label, Pattern pattern) {
        return new ManyPattern(label, pattern);
    }

    public static final ManyPattern many(String label, Pattern pattern) {
        return Patterns.many(Nodes.q(label), pattern);
    }

    public static final OnlyPattern only(QName label, Pattern pattern) {
        return new OnlyPattern(label, pattern);
    }

    public static final OnlyPattern only(String label, Pattern pattern) {
        return Patterns.only(Nodes.q(label), pattern);
    }

    public static ManyPattern tail() {
        return Patterns.many(any, (Pattern)Patterns.any());
    }

    public static CutTreePattern cut(TreePattern pattern) {
        return new CutTreePattern(pattern.patterns());
    }

    public static TextPattern text(Constraint<? super String> constraint) {
        return new TextPattern(constraint);
    }

    public static TextPattern text() {
        return new TextPattern(anyval);
    }

    public static NumPattern num(Constraint<? super Double> c) {
        return new NumPattern(c);
    }

    public static NumPattern num() {
        return new NumPattern(anyval);
    }

    public static BoolPattern bool(Constraint<? super Boolean> c) {
        return new BoolPattern(c);
    }

    public static BoolPattern bool() {
        return new BoolPattern(anyval);
    }

    public static DatePattern date(Constraint<? super Date> c) {
        return new DatePattern(c);
    }

    public static DatePattern date() {
        return new DatePattern(anyval);
    }

    public static URIPattern uri(Constraint<? super URI> c) {
        return new URIPattern(c);
    }

    public static URIPattern uri() {
        return new URIPattern(anyval);
    }

    public static CalendarPattern calendar(Constraint<? super Calendar> c) {
        return new CalendarPattern(c);
    }

    public static CalendarPattern calendar() {
        return new CalendarPattern(anyval);
    }

    public static <T> Same<T> is(T v) {
        return new Same(v);
    }

    public static Match matches(String regex) {
        return new Match(regex);
    }

    public static <T> All<T> all(Constraint<T> constraint1, Constraint<T> constraint2) {
        return new All<T>(constraint1, constraint2);
    }

    public static <T> Either<T> either(Constraint<T> constraint1, Constraint<T> constraint2) {
        return new Either<T>(constraint1, constraint2);
    }

    public static <T> Not<T> not(Constraint<T> constraint) {
        return new Not<T>(constraint);
    }

    public static More more(double than) {
        return new More(than);
    }

    public static Less less(double than) {
        return new Less(than);
    }

    public static BeforeDate before(Date d) {
        return new BeforeDate(d);
    }

    public static AfterDate afterDate(Date d) {
        return new AfterDate(d);
    }

    public static AfterDate futureDate() {
        return new AfterDate(new Date());
    }

    public static BeforeDate pastDate() {
        return new BeforeDate(new Date());
    }

    public static Before before(Calendar c) {
        return new Before(c);
    }

    public static After after(Calendar c) {
        return new After(c);
    }

    public static After future() {
        return new After(Calendar.getInstance());
    }

    public static Before past() {
        return new Before(Calendar.getInstance());
    }
}

