/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.XMLBindings;

class XMLReader {
    private static final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private final XMLStreamReader reader;

    static {
        inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
    }

    XMLReader(Source source) {
        try {
            this.reader = inputFactory.createXMLStreamReader(source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Node readNode() {
        try {
            this.reader.nextTag();
            return this._readNode();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Tree read() {
        try {
            this.reader.nextTag();
            Node node = this._readNode();
            if (node instanceof Leaf) {
                throw new Exception("trees cannot be rooted in leaves like " + this.reader.getLocalName());
            }
            InnerNode inode = (InnerNode)node;
            Map<QName, String> attributes = inode.attributes();
            String source = attributes.remove(XMLBindings.SOURCE);
            Tree tree = new Tree(inode.id(), inode.state(), attributes, inode.edges().toArray(new Edge[0]));
            tree.setSourceId(source);
            return tree;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node _readNode() throws Exception {
        Map<QName, String> attributes = this.readAttributes();
        String id = attributes.remove(XMLBindings.ID);
        String s = attributes.remove(XMLBindings.STATE);
        Node.State state = null;
        try {
            if (s != null) {
                state = Node.State.valueOf(s);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("invalid node state " + s);
        }
        ArrayList<Edge> edges = new ArrayList<Edge>();
        String value = null;
        String nil = attributes.remove(new QName("http://www.w3.org/2001/XMLSchema-instance", "nil"));
        if (nil != null && nil.equals("true")) {
            value = "nil";
        }
        boolean leaf = false;
        boolean inner = false;
        block7: while (this.reader.hasNext()) {
            int next = this.reader.next();
            switch (next) {
                case 1: {
                    if (leaf) {
                        throw new IllegalArgumentException("invalid tree serialisation: found mixed content");
                    }
                    inner = true;
                    QName edgeLabel = this.reader.getName();
                    edges.add(new Edge(edgeLabel, this._readNode()));
                    break;
                }
                case 4: {
                    if (this.reader.getText().trim().isEmpty()) break;
                    if (inner) {
                        throw new IllegalArgumentException("invalid tree serialisation: found mixed content");
                    }
                    leaf = true;
                    value = this.reader.getText();
                    break;
                }
                case 2: {
                    break block7;
                }
            }
        }
        if (value == null) {
            return new InnerNode(id, state, attributes, edges.toArray(new Edge[0]));
        }
        if (value.equals("nil")) {
            value = null;
        }
        return new Leaf(id, state, value, attributes);
    }

    private Map<QName, String> readAttributes() {
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        int i = 0;
        while (i < this.reader.getAttributeCount()) {
            String ns = this.reader.getAttributeNamespace(i);
            String name = this.reader.getAttributeLocalName(i);
            String prefix = this.reader.getAttributePrefix(i);
            QName attribute = prefix == null ? new QName(ns, name) : new QName(ns, name, prefix);
            String attrValue = this.reader.getAttributeValue(i);
            attributes.put(attribute, attrValue);
            ++i;
        }
        return attributes;
    }
}

