/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.WriteOptions;
import org.gcube.data.trees.io.XMLReader;
import org.gcube.data.trees.io.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLBindings {
    private static final DocumentBuilder docFactory;
    private static final TransformerFactory tracFactory;
    public static final QName ID;
    public static final QName STATE;
    public static final QName SOURCE;
    private static final WriteOptions defaultOptions;

    static {
        tracFactory = TransformerFactory.newInstance();
        ID = new QName("http://gcube-system.org/namespaces/data/trees", "id");
        STATE = new QName("http://gcube-system.org/namespaces/data/trees", "state");
        SOURCE = new QName("http://gcube-system.org/namespaces/data/trees", "source");
        defaultOptions = new WriteOptions();
        DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
        df.setNamespaceAware(true);
        try {
            docFactory = df.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(Tree tree) {
        return XMLBindings.toString(tree, defaultOptions);
    }

    public static String nodeToString(Node node) {
        return XMLBindings.nodeToString(node, defaultOptions);
    }

    public static String toString(Tree tree, WriteOptions options) {
        StreamResult result = new StreamResult(new StringWriter());
        XMLBindings.toResult(tree, result, options);
        return result.getWriter().toString();
    }

    public static String nodeToString(Node node, WriteOptions options) {
        StreamResult result = new StreamResult(new StringWriter());
        XMLBindings.nodeToResult(node, result, options);
        return result.getWriter().toString();
    }

    public static Tree fromString(String xml) {
        return XMLBindings.fromSource(new StreamSource(new StringReader(xml)));
    }

    public static Node nodeFromString(String xml) {
        return XMLBindings.nodeFromSource(new StreamSource(new StringReader(xml)));
    }

    public static void toStream(Tree tree, Writer stream) {
        XMLBindings.toStream(tree, stream, defaultOptions);
    }

    public static void nodeToStream(Node node, Writer stream) {
        XMLBindings.nodeToStream(node, stream, defaultOptions);
    }

    public static void toStream(Tree tree, Writer stream, WriteOptions options) {
        XMLBindings.toResult(tree, new StreamResult(stream), options);
    }

    public static void nodeToStream(Node node, Writer stream, WriteOptions options) {
        XMLBindings.nodeToResult(node, new StreamResult(stream), options);
    }

    public static Tree fromStream(Reader stream) {
        return XMLBindings.fromSource(new StreamSource(stream));
    }

    public static Node nodeFromStream(Reader stream) {
        return XMLBindings.nodeFromSource(new StreamSource(stream));
    }

    public static void toStream(Tree tree, OutputStream stream) {
        XMLBindings.toStream(tree, stream, defaultOptions);
    }

    public static void nodetoStream(Node node, OutputStream stream) {
        XMLBindings.nodeToStream(node, stream, defaultOptions);
    }

    public static void toStream(Tree tree, OutputStream stream, WriteOptions options) {
        XMLBindings.toResult(tree, new StreamResult(stream), options);
    }

    public static void nodeToStream(Node node, OutputStream stream, WriteOptions options) {
        XMLBindings.nodeToResult(node, new StreamResult(stream), options);
    }

    public static Tree fromStream(InputStream stream) {
        return XMLBindings.fromSource(new StreamSource(stream));
    }

    public static Node nodeFromStream(InputStream stream) {
        return XMLBindings.nodeFromSource(new StreamSource(stream));
    }

    public static Element toElement(Tree tree) {
        return XMLBindings.toElement(tree, defaultOptions);
    }

    public static Element toElement(Tree tree, WriteOptions options) {
        return XMLBindings.toElement(XMLBindings.toString(tree, options));
    }

    public static Element nodeToElement(Node node, WriteOptions options) {
        return XMLBindings.toElement(XMLBindings.nodeToString(node, options));
    }

    public static Element nodeToElement(Node node) {
        return XMLBindings.toElement(XMLBindings.nodeToString(node, defaultOptions));
    }

    private static Element toElement(String xml) {
        try {
            DOMResult result = new DOMResult(docFactory.newDocument());
            tracFactory.newTransformer().transform(new StreamSource(new StringReader(xml)), result);
            return ((Document)Document.class.cast(result.getNode())).getDocumentElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Tree fromElement(Element element) {
        return XMLBindings.fromString(XMLBindings._fromElement(element));
    }

    public static Node nodeFromElement(Element element) {
        return XMLBindings.nodeFromString(XMLBindings._fromElement(element));
    }

    public static String _fromElement(Element element) {
        try {
            DOMSource source = new DOMSource(element);
            StringWriter w = new StringWriter();
            tracFactory.newTransformer().transform(source, new StreamResult(w));
            return w.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Tree fromSource(Source source) {
        return new XMLReader(source).read();
    }

    private static Node nodeFromSource(Source source) {
        return new XMLReader(source).readNode();
    }

    private static void toResult(Tree tree, Result result, WriteOptions options) {
        new XMLWriter(result, options).write(tree);
    }

    private static void nodeToResult(Node node, Result result, WriteOptions options) {
        new XMLWriter(result, options).writeNode(node);
    }
}

