/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.generators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.generators.AbstractTreeTemplate;

public class SimilarityTemplate
extends AbstractTreeTemplate {
    private final Tree proto;
    private final double similarity;

    protected SimilarityTemplate(Tree proto, double similarity) {
        this.proto = proto;
        this.similarity = similarity;
    }

    @Override
    public Tree generate() {
        return new Tree(this.newId(this.proto), this.newattributes(this.proto), this.newedges(this.proto));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("tree prototype");
        b.append("\n======================");
        b.append(this.proto);
        b.append("\n");
        return b.toString();
    }

    private String newId(Node proto) {
        return proto.id() == null ? null : UUID.randomUUID().toString();
    }

    private Edge[] newedges(InnerNode proto) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge e : proto.edges()) {
            if (!(Math.random() < this.similarity)) continue;
            edges.add(this.newedge(e));
        }
        return edges.toArray(new Edge[0]);
    }

    private Edge newedge(Edge proto) {
        Node target = proto.target();
        return new Edge(proto.label(), target instanceof InnerNode ? this.generate((InnerNode)target) : this.generate((Leaf)target));
    }

    private Map<QName, String> newattributes(Node proto) {
        HashMap<QName, String> attributes = new HashMap<QName, String>();
        for (Map.Entry<QName, String> attr : proto.attributes().entrySet()) {
            if (!(Math.random() < this.similarity)) continue;
            attributes.put(attr.getKey(), this.shuffle(attr.getValue(), this.similarity + (1.0 - this.similarity) / 2.0));
        }
        return attributes;
    }

    private Leaf generate(Leaf proto) {
        return new Leaf(this.newId(proto), null, this.shuffle(proto.value(), this.similarity), this.newattributes(proto));
    }

    private InnerNode generate(InnerNode proto) {
        return new InnerNode(this.newId(proto), this.newattributes(proto), this.newedges(proto));
    }

    private String shuffle(String value, double similarity) {
        if (value.length() <= 1) {
            return value;
        }
        int split = value.length() / 2;
        String temp1 = this.shuffle(value.substring(0, split), similarity);
        String temp2 = this.shuffle(value.substring(split), similarity);
        if (Math.random() < similarity) {
            return String.valueOf(temp1) + temp2;
        }
        return String.valueOf(temp2) + temp1;
    }
}

