/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra.nodeassignmentpolicy;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import gr.uoa.di.madgik.commons.infra.nodeassignmentpolicy.CollocationRegistry;
import gr.uoa.di.madgik.commons.infra.nodeassignmentpolicy.NodeAssignmentPolicy;
import gr.uoa.di.madgik.commons.infra.nodeselection.HostingNodeInfo;
import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import java.util.List;
import java.util.Random;

public class MinimumCollocationPolicy
implements NodeAssignmentPolicy {
    public static float DefaultPenalty = 0.0f;
    private NodeSelector selector = null;
    private CollocationRegistry registry = new CollocationRegistry();
    private float threshold = 0.0f;
    private float collocationPenalty;

    public MinimumCollocationPolicy(NodeSelector selector) {
        this.selector = selector;
    }

    public MinimumCollocationPolicy(NodeSelector selector, float threshold) {
        this.selector = selector;
        this.threshold = threshold;
    }

    @Override
    public NodeAssignmentPolicy.Type getType() {
        return NodeAssignmentPolicy.Type.MinimumCollocation;
    }

    @Override
    public void setPenalty(float collocationPenalty) {
        this.collocationPenalty = collocationPenalty;
    }

    @Override
    public HostingNode selectNode(List<HostingNode> candidates) throws Exception {
        List<HostingNodeInfo> assessed = this.selector.assessNodes(candidates);
        for (HostingNodeInfo hn : assessed) {
            if (this.registry.isSelected(hn.node) || !(hn.score.floatValue() + this.registry.getCollocationScore(hn.node) > this.threshold)) continue;
            if ((double)this.collocationPenalty > 1.0E-10 || (double)this.collocationPenalty < -1.0E-10) {
                this.registry.addToCollocationScore(hn.node, this.collocationPenalty);
            }
            this.selector.markSelected(hn.node);
            return hn.node;
        }
        for (HostingNodeInfo hn : assessed) {
            if (this.registry.isSelected(hn.node)) continue;
            this.registry.markSelected(hn.node);
            if ((double)this.collocationPenalty > 1.0E-10 || (double)this.collocationPenalty < -1.0E-10) {
                this.registry.addToCollocationScore(hn.node, this.collocationPenalty);
            }
            this.selector.markSelected(hn.node);
            return hn.node;
        }
        HostingNode selected = null;
        Random rnd = new Random();
        while (!this.registry.isSelected(selected = assessed.get((int)rnd.nextInt()).node)) {
        }
        if ((double)this.collocationPenalty > 1.0E-10 || (double)this.collocationPenalty < -1.0E-10) {
            this.registry.addToCollocationScore(selected, this.collocationPenalty);
        }
        return selected;
    }

    @Override
    public void reset() {
        this.registry = new CollocationRegistry();
    }
}

