/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlListener;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.UnmodifiableAccessControlList;
import org.apache.jackrabbit.core.security.authorization.acl.ACLEditor;
import org.apache.jackrabbit.core.security.authorization.acl.ACLTemplate;
import org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector;
import org.apache.jackrabbit.core.security.authorization.acl.EntryCollector;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilter;
import org.apache.jackrabbit.core.security.authorization.acl.EntryFilterImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLProvider
extends AbstractAccessControlProvider
implements AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(ACLProvider.class);
    private ACLEditor systemEditor;
    private NodeId rootNodeId;
    private EntryCollector entryCollector;

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        boolean initializedWithDefaults;
        super.init(systemSession, configuration);
        NodeImpl root = (NodeImpl)this.session.getRootNode();
        this.rootNodeId = root.getNodeId();
        this.systemEditor = new ACLEditor(systemSession, this);
        boolean bl = initializedWithDefaults = !configuration.containsKey("omit-default-permission");
        if (initializedWithDefaults && !ACLProvider.isAccessControlled(root)) {
            ACLProvider.initRootACL(this.session, this.systemEditor);
        }
        this.entryCollector = this.createEntryCollector((SessionImpl)systemSession);
    }

    @Override
    public void close() {
        super.close();
        this.entryCollector.close();
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Path absPath) throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        NodeImpl targetNode = (NodeImpl)this.session.getNode(this.session.getJCRPath(absPath));
        NodeImpl node = this.getNode(targetNode, this.isAcItem(targetNode));
        ArrayList<AccessControlList> acls = new ArrayList<AccessControlList>();
        this.collectAcls(node, acls);
        if (acls.isEmpty()) {
            log.warn("No access controlled node present in item hierarchy starting from " + targetNode.getPath());
        }
        return (AccessControlPolicy[])acls.toArray(new AccessControlList[acls.size()]);
    }

    @Override
    public AccessControlEditor getEditor(Session session) {
        this.checkInitialized();
        return new ACLEditor(session, this);
    }

    @Override
    public CompiledPermissions compilePermissions(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return this.getAdminPermissions();
        }
        if (this.isReadOnly(principals)) {
            return this.getReadOnlyPermissions();
        }
        return new AclPermissions(principals);
    }

    @Override
    public boolean canAccessRoot(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return true;
        }
        AclPermissions cp = new AclPermissions(principals, false);
        return cp.canRead(null, this.rootNodeId);
    }

    protected EntryCollector createEntryCollector(SessionImpl systemSession) throws RepositoryException {
        return new CachingEntryCollector(systemSession, this.systemEditor, this.rootNodeId);
    }

    protected Iterator<AccessControlEntry> retrieveResultEntries(NodeImpl node, EntryFilter filter) throws RepositoryException {
        Iterator<AccessControlEntry> itr = this.entryCollector.collectEntries(node, filter).iterator();
        return itr;
    }

    private NodeImpl getNode(NodeImpl targetNode, boolean isAcItem) throws RepositoryException {
        Name ntName;
        NodeImpl node = isAcItem ? ((ntName = ((NodeTypeImpl)targetNode.getPrimaryNodeType()).getQName()).equals(NT_REP_ACL) ? (NodeImpl)targetNode.getParent() : (NodeImpl)targetNode.getParent().getParent()) : targetNode;
        return node;
    }

    private void collectAcls(NodeImpl node, List<AccessControlList> acls) throws RepositoryException {
        if (ACLProvider.isAccessControlled(node)) {
            acls.add((AccessControlList)new UnmodifiableAccessControlList(this.entryCollector.getEntries(node), node.getPath(), Collections.<String, Integer>emptyMap()));
        }
        if (!this.rootNodeId.equals(node.getId())) {
            NodeImpl parentNode = (NodeImpl)node.getParent();
            this.collectAcls(parentNode, acls);
        }
    }

    private static void initRootACL(SessionImpl session, AccessControlEditor editor) throws RepositoryException {
        try {
            log.debug("Install initial ACL:...");
            String rootPath = session.getRootNode().getPath();
            AccessControlPolicy[] acls = editor.editAccessControlPolicies(rootPath);
            if (acls.length > 0) {
                Privilege[] privs;
                ACLTemplate acl = (ACLTemplate)acls[0];
                PrincipalManager pMgr = session.getPrincipalManager();
                AccessControlManager acMgr = session.getAccessControlManager();
                String pName = "administrators";
                if (pMgr.hasPrincipal(pName)) {
                    Principal administrators = pMgr.getPrincipal(pName);
                    log.debug("... Privilege.ALL for administrators.");
                    privs = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")};
                    acl.addAccessControlEntry(administrators, privs);
                } else {
                    log.info("Administrators principal group is missing -> omitting initialization of default permissions.");
                }
                Principal everyone = pMgr.getEveryone();
                log.debug("... Privilege.READ for everyone.");
                privs = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")};
                acl.addAccessControlEntry(everyone, privs);
                editor.setPolicy(rootPath, (AccessControlPolicy)acl);
                session.save();
            } else {
                log.info("No applicable ACL available for the root node -> skip initialization of the root node's ACL.");
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to set-up minimal access control for root node of workspace " + session.getWorkspace().getName());
            session.getRootNode().refresh(false);
        }
    }

    static boolean isAccessControlled(NodeImpl node) throws RepositoryException {
        return node.hasNode(N_POLICY) && node.isNodeType(NT_REP_ACCESS_CONTROLLABLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AclPermissions
    extends AbstractCompiledPermissions
    implements AccessControlListener {
        private final List<String> principalNames;
        private final Map<NodeId, Boolean> readCache = new LRUMap(1000);
        private final Object monitor = new Object();

        private AclPermissions(Set<Principal> principals) throws RepositoryException {
            this(principals, true);
        }

        private AclPermissions(Set<Principal> principals, boolean listenToEvents) throws RepositoryException {
            this.principalNames = new ArrayList<String>(principals.size());
            for (Principal princ : principals) {
                this.principalNames.add(princ.getName());
            }
            if (listenToEvents) {
                ACLProvider.this.entryCollector.addListener(this);
            }
        }

        private AbstractCompiledPermissions.Result buildResult(NodeImpl node, boolean existingNode, boolean isAcItem, EntryFilter filter) throws RepositoryException {
            Iterator<AccessControlEntry> entries = ACLProvider.this.retrieveResultEntries(ACLProvider.this.getNode(node, isAcItem), filter);
            int allows = 0;
            int denies = 0;
            int allowPrivileges = 0;
            int denyPrivileges = 0;
            int parentAllows = 0;
            int parentDenies = 0;
            while (entries.hasNext()) {
                int permissions;
                boolean isLocal;
                ACLTemplate.Entry ace = (ACLTemplate.Entry)entries.next();
                int entryBits = ace.getPrivilegeBits();
                boolean bl = isLocal = existingNode && ace.isLocal(node.getNodeId());
                if (!isLocal) {
                    if (ace.isAllow()) {
                        parentAllows |= Permission.diff(entryBits, parentDenies);
                    } else {
                        parentDenies |= Permission.diff(entryBits, parentAllows);
                    }
                }
                if (ace.isAllow()) {
                    permissions = PrivilegeRegistry.calculatePermissions(allowPrivileges |= Permission.diff(entryBits, denyPrivileges), parentAllows, true, isAcItem);
                    allows |= Permission.diff(permissions, denies);
                    continue;
                }
                permissions = PrivilegeRegistry.calculatePermissions(denyPrivileges |= Permission.diff(entryBits, allowPrivileges), parentDenies, false, isAcItem);
                denies |= Permission.diff(permissions, allows);
            }
            return new AbstractCompiledPermissions.Result(allows, denies, allowPrivileges, denyPrivileges);
        }

        @Override
        protected AbstractCompiledPermissions.Result buildResult(Path absPath) throws RepositoryException {
            NodeImpl node;
            boolean existingNode = false;
            ItemManager itemMgr = ACLProvider.this.session.getItemManager();
            try {
                ItemImpl item = itemMgr.getItem(absPath);
                if (item.isNode()) {
                    node = (NodeImpl)item;
                    existingNode = true;
                } else {
                    node = (NodeImpl)item.getParent();
                }
            }
            catch (RepositoryException e) {
                int index;
                Name name;
                Path.Element[] elems = absPath.getElements();
                NodeImpl parent = (NodeImpl)ACLProvider.this.session.getRootNode();
                for (int i = 1; i < elems.length - 1 && parent.hasNode(name = elems[i].getName(), index = elems[i].getIndex()); ++i) {
                    parent = parent.getNode(name, index);
                }
                node = parent;
            }
            if (node == null) {
                throw new ItemNotFoundException("Item out of hierarchy.");
            }
            boolean isAcItem = ACLProvider.this.isAcItem(absPath);
            return this.buildResult(node, existingNode, isAcItem, new EntryFilterImpl(this.principalNames));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void clearCache() {
            Object object = this.monitor;
            synchronized (object) {
                this.readCache.clear();
            }
            super.clearCache();
        }

        @Override
        public void close() {
            ACLProvider.this.entryCollector.removeListener(this);
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canRead(Path path, ItemId itemId) throws RepositoryException {
            boolean canRead;
            NodeId nodeId;
            ItemId id = itemId == null ? ACLProvider.this.session.getHierarchyManager().resolvePath(path) : itemId;
            boolean existingNode = false;
            if (id.denotesNode()) {
                nodeId = (NodeId)id;
                existingNode = true;
            } else {
                nodeId = ((PropertyId)id).getParentId();
            }
            Object object = this.monitor;
            synchronized (object) {
                if (this.readCache.containsKey(nodeId)) {
                    canRead = this.readCache.get(nodeId);
                } else {
                    ItemManager itemMgr = ACLProvider.this.session.getItemManager();
                    NodeImpl node = (NodeImpl)itemMgr.getItem(nodeId);
                    AbstractCompiledPermissions.Result result = this.buildResult(node, existingNode, ACLProvider.this.isAcItem(node), new EntryFilterImpl(this.principalNames));
                    canRead = result.grants(1);
                    this.readCache.put(nodeId, canRead);
                }
            }
            return canRead;
        }

        @Override
        public void acModified(AccessControlModifications modifications) {
            this.clearCache();
        }
    }
}

