/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.Short2DoubleMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShort2DoubleMap
implements Short2DoubleMap,
Serializable {
    protected double defRetValue;

    protected AbstractShort2DoubleMap() {
    }

    @Override
    public void defaultReturnValue(double rv) {
        this.defRetValue = rv;
    }

    @Override
    public double defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public double put(short key, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double remove(short key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double get(Object ok) {
        short k = (Short)ok;
        return this.containsKey(k) ? Double.valueOf(this.get(k)) : null;
    }

    @Override
    public Double put(Short ok, Double ov) {
        short k = ok;
        double v = this.put(k, (double)ov);
        return this.containsKey(k) ? Double.valueOf(v) : null;
    }

    @Override
    public Double remove(Object ok) {
        short k = (Short)ok;
        double v = this.remove(k);
        return this.containsKey(k) ? Double.valueOf(v) : null;
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue((Double)ov);
    }

    @Override
    public boolean containsKey(Object ok) {
        return this.containsKey((Short)ok);
    }

    @Override
    public boolean containsValue(double v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(short k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Short, ? extends Double> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Short, ? extends Double>> i = m.entrySet().iterator();
        if (m instanceof Short2DoubleMap) {
            while (n-- != 0) {
                Short2DoubleMap.Entry e = (Short2DoubleMap.Entry)i.next();
                this.put(e.getShortKey(), e.getDoubleValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Short, ? extends Double> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ShortSet keySet() {
        return new AbstractShortSet(){

            public boolean contains(short k) {
                return AbstractShort2DoubleMap.this.containsKey(k);
            }

            public int size() {
                return AbstractShort2DoubleMap.this.size();
            }

            public void clear() {
                AbstractShort2DoubleMap.this.clear();
            }

            public ShortIterator iterator() {
                return new AbstractShortIterator(){
                    final ObjectIterator<Map.Entry<Short, Double>> i;
                    {
                        this.i = AbstractShort2DoubleMap.this.entrySet().iterator();
                    }

                    public short nextShort() {
                        return ((Short2DoubleMap.Entry)this.i.next()).getShortKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public DoubleCollection values() {
        return new AbstractDoubleCollection(){

            public boolean contains(double k) {
                return AbstractShort2DoubleMap.this.containsValue(k);
            }

            public int size() {
                return AbstractShort2DoubleMap.this.size();
            }

            public void clear() {
                AbstractShort2DoubleMap.this.clear();
            }

            public DoubleIterator iterator() {
                return new AbstractDoubleIterator(){
                    final ObjectIterator<Map.Entry<Short, Double>> i;
                    {
                        this.i = AbstractShort2DoubleMap.this.entrySet().iterator();
                    }

                    public double nextDouble() {
                        return ((Short2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Map.Entry<Short, Double>> i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Map.Entry<Short, Double>> i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Short2DoubleMap.Entry e = (Short2DoubleMap.Entry)i.next();
            s.append(String.valueOf(e.getShortKey()));
            s.append("=>");
            s.append(String.valueOf(e.getDoubleValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Short2DoubleMap.Entry {
        protected short key;
        protected double value;

        public BasicEntry(Short key, Double value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(short key, double value) {
            this.key = key;
            this.value = value;
        }

        public Short getKey() {
            return this.key;
        }

        public short getShortKey() {
            return this.key;
        }

        public Double getValue() {
            return this.value;
        }

        public double getDoubleValue() {
            return this.value;
        }

        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        public Double setValue(Double value) {
            return this.setValue((double)value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Short)e.getKey() && this.value == (Double)e.getValue();
        }

        public int hashCode() {
            return this.key ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

