/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.types.Type;

public abstract class RowStoreAVL
implements PersistentStore {
    Session session;
    Database database;
    PersistentStoreCollection manager;
    Index[] indexList = Index.emptyArray;
    CachedObject[] accessorList = CachedObject.emptyArray;
    TableBase table;
    int elementCount;
    private long timestamp;
    PersistentStore[] subStores = PersistentStore.emptyArray;

    public TableBase getTable() {
        return this.table;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isMemory() {
        return false;
    }

    public void setMemory(boolean mode) {
    }

    public abstract int getAccessCount();

    public abstract void set(CachedObject var1);

    public abstract CachedObject get(int var1, boolean var2);

    public abstract CachedObject get(CachedObject var1, boolean var2);

    public abstract int getStorageSize(int var1);

    public abstract void add(CachedObject var1);

    public abstract CachedObject get(RowInputInterface var1);

    public abstract CachedObject getNewInstance(int var1);

    public abstract CachedObject getNewCachedObject(Session var1, Object var2, boolean var3);

    public abstract void removePersistence(int var1);

    public abstract void removeAll();

    public abstract void remove(int var1);

    public abstract void release(int var1);

    public abstract void commitPersistence(CachedObject var1);

    public abstract DataFileCache getCache();

    public abstract void setCache(DataFileCache var1);

    public abstract void release();

    public PersistentStore getAccessorStore(Index index) {
        return null;
    }

    public CachedObject getAccessor(Index key) {
        int position = key.getPosition();
        if (position >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[position];
    }

    public void delete(Session session, Row row) {
        int i;
        row = (Row)this.get(row, false);
        for (i = 0; i < this.indexList.length; ++i) {
            this.indexList[i].delete(session, this, row);
        }
        for (i = 0; i < this.subStores.length; ++i) {
            this.subStores[i].delete(session, row);
        }
        row.delete(this);
        --this.elementCount;
    }

    public void indexRow(Session session, Row row) {
        int i;
        try {
            for (i = 0; i < this.indexList.length; ++i) {
                this.indexList[i].insert(session, this, row);
            }
            int j = 0;
            try {
                for (j = 0; j < this.subStores.length; ++j) {
                    this.subStores[j].indexRow(session, row);
                }
            }
            catch (HsqlException e) {
                int count = j;
                for (j = 0; j < count; ++j) {
                    this.subStores[j].delete(session, row);
                }
                throw e;
            }
            ++this.elementCount;
        }
        catch (HsqlException e) {
            int count = i;
            for (i = 0; i < count; ++i) {
                this.indexList[i].delete(session, this, row);
            }
            this.remove(row.getPos());
            throw e;
        }
    }

    public final void indexRows(Session session) {
        for (int i = 1; i < this.indexList.length; ++i) {
            this.setAccessor(this.indexList[i], null);
        }
        RowIterator it = this.rowIterator();
        while (it.hasNext()) {
            Row row = it.getNextRow();
            ((RowAVL)row).clearNonPrimaryNodes();
            for (int i = 1; i < this.indexList.length; ++i) {
                this.indexList[i].insert(session, this, row);
            }
        }
    }

    public final RowIterator rowIterator() {
        Index index = this.indexList[0];
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!this.indexList[i].isClustered()) continue;
            index = this.indexList[i];
            break;
        }
        return index.firstRow(this);
    }

    public abstract void setAccessor(Index var1, CachedObject var2);

    public abstract void setAccessor(Index var1, int var2);

    public void resetAccessorKeys(Index[] keys) {
        int position;
        Index[] oldIndexList = this.indexList;
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.indexList == keys) {
            return;
        }
        CachedObject[] oldAccessors = this.accessorList;
        int limit = this.indexList.length;
        int diff = keys.length - this.indexList.length;
        if (diff < -1) {
            throw Error.runtimeError(201, "RowStoreAV");
        }
        if (diff == -1) {
            limit = keys.length;
        } else {
            if (diff == 0) {
                throw Error.runtimeError(201, "RowStoreAV");
            }
            if (diff != 1) {
                for (position = 0; position < limit && this.indexList[position] == keys[position]; ++position) {
                }
                Index[] tempKeys = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, position, 1);
                tempKeys[position] = keys[position];
                this.resetAccessorKeys(tempKeys);
                this.resetAccessorKeys(keys);
                return;
            }
        }
        while (position < limit && this.indexList[position] == keys[position]) {
            ++position;
        }
        this.accessorList = (CachedObject[])ArrayUtil.toAdjustedArray(this.accessorList, null, position, diff);
        this.indexList = keys;
        try {
            if (diff > 0) {
                this.insertIndexNodes(this.indexList[0], this.indexList[position]);
            } else {
                this.dropIndexFromRows(this.indexList[0], oldIndexList[position]);
            }
        }
        catch (HsqlException e) {
            this.accessorList = oldAccessors;
            this.indexList = oldIndexList;
            throw e;
        }
    }

    public Index[] getAccessorKeys() {
        return this.indexList;
    }

    public int elementCount() {
        Index index = this.indexList[0];
        if (this.elementCount < 0) {
            this.elementCount = ((IndexAVL)index).getNodeCount(this.session, this);
        }
        return this.elementCount;
    }

    public int elementCount(Session session) {
        int txControl;
        Index index = this.indexList[0];
        if (this.elementCount < 0) {
            this.elementCount = ((IndexAVL)index).getNodeCount(session, this);
        }
        if (session != null && (txControl = session.database.txManager.getTransactionControl()) != 0) {
            switch (this.table.getTableType()) {
                case 4: 
                case 5: 
                case 7: {
                    return ((IndexAVL)index).getNodeCount(session, this);
                }
            }
        }
        return this.elementCount;
    }

    public int elementCountUnique(Index index) {
        return 0;
    }

    public void setElementCount(Index key, int size, int uniqueSize) {
        this.elementCount = size;
    }

    public final void moveData(Session session, PersistentStore other, int colindex, int adjust) {
        Type oldtype = null;
        Type newtype = null;
        Object colvalue = null;
        if (adjust >= 0 && colindex != -1) {
            ColumnSchema column = ((Table)this.table).getColumn(colindex);
            colvalue = column.getDefaultValue(session);
            newtype = ((Table)this.table).getColumnTypes()[colindex];
        }
        if (adjust <= 0 && colindex != -1) {
            oldtype = ((Table)other.getTable()).getColumnTypes()[colindex];
        }
        try {
            Object[] olddata;
            Row row;
            Table table = (Table)this.table;
            RowIterator it = other.rowIterator();
            while (it.hasNext()) {
                row = it.getNextRow();
                olddata = row.getData();
                Object[] data = table.getEmptyRowData();
                Object oldvalue = null;
                if (adjust == 0 && colindex != -1) {
                    oldvalue = olddata[colindex];
                    colvalue = newtype.convertToType(session, oldvalue, oldtype);
                }
                ArrayUtil.copyAdjustArray(olddata, data, colvalue, colindex, adjust);
                table.systemSetIdentityColumn(session, data);
                if (table.hasGeneratedColumn()) {
                    table.setGeneratedColumns(session, data);
                }
                table.enforceTypeLimits(session, data);
                table.enforceRowConstraints(session, data);
                Row newrow = (Row)this.getNewCachedObject(session, data, false);
                this.indexRow(session, newrow);
            }
            if (table.isTemp()) {
                return;
            }
            if (oldtype != null && oldtype.isLobType()) {
                it = other.rowIterator();
                while (it.hasNext()) {
                    row = it.getNextRow();
                    olddata = row.getData();
                    Object oldvalue = olddata[colindex];
                    if (oldvalue == null) continue;
                    session.sessionData.adjustLobUsageCount(oldvalue, -1);
                }
            }
            if (newtype != null && newtype.isLobType()) {
                it = this.rowIterator();
                while (it.hasNext()) {
                    row = it.getNextRow();
                    Object[] data = row.getData();
                    Object value = data[colindex];
                    if (value == null) continue;
                    session.sessionData.adjustLobUsageCount(value, 1);
                }
            }
        }
        catch (OutOfMemoryError e) {
            throw Error.error(460);
        }
    }

    public void reindex(Session session, Index index) {
        this.setAccessor(index, null);
        RowIterator it = this.table.rowIterator(this);
        while (it.hasNext()) {
            RowAVL row = (RowAVL)it.getNextRow();
            row.getNode(index.getPosition()).delete();
            index.insert(session, this, row);
        }
    }

    public void writeLock() {
    }

    public void writeUnlock() {
    }

    void dropIndexFromRows(Index primaryIndex, Index oldIndex) {
        RowIterator it = primaryIndex.firstRow(this);
        int position = oldIndex.getPosition() - 1;
        while (it.hasNext()) {
            Row row = it.getNextRow();
            int i = position - 1;
            NodeAVL backnode = ((RowAVL)row).getNode(0);
            while (i-- > 0) {
                backnode = backnode.nNext;
            }
            backnode.nNext = backnode.nNext.nNext;
        }
    }

    boolean insertIndexNodes(Index primaryIndex, Index newIndex) {
        int position = newIndex.getPosition();
        RowIterator it = primaryIndex.firstRow(this);
        int rowCount = 0;
        HsqlException error = null;
        try {
            while (it.hasNext()) {
                Row row = it.getNextRow();
                ((RowAVL)row).insertNode(position);
                ++rowCount;
                newIndex.insert(this.session, this, row);
            }
            return true;
        }
        catch (OutOfMemoryError e) {
            error = Error.error(460);
        }
        catch (HsqlException e) {
            error = e;
        }
        it = primaryIndex.firstRow(this);
        for (int i = 0; i < rowCount; ++i) {
            Row row = it.getNextRow();
            NodeAVL backnode = ((RowAVL)row).getNode(0);
            int j = position;
            while (--j > 0) {
                backnode = backnode.nNext;
            }
            backnode.nNext = backnode.nNext.nNext;
        }
        throw error;
    }
}

