/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.linear;

import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.linear.AbstractLinearOptimizer;
import org.apache.commons.math.optimization.linear.NoFeasibleSolutionException;
import org.apache.commons.math.optimization.linear.SimplexTableau;
import org.apache.commons.math.optimization.linear.UnboundedSolutionException;
import org.apache.commons.math.util.MathUtils;

public class SimplexSolver
extends AbstractLinearOptimizer {
    private static final double DEFAULT_EPSILON = 1.0E-6;
    protected final double epsilon;

    public SimplexSolver() {
        this(1.0E-6);
    }

    public SimplexSolver(double epsilon) {
        this.epsilon = epsilon;
    }

    private Integer getPivotColumn(SimplexTableau tableau) {
        double minValue = 0.0;
        Integer minPos = null;
        for (int i = tableau.getNumObjectiveFunctions(); i < tableau.getWidth() - 1; ++i) {
            if (MathUtils.compareTo(tableau.getEntry(0, i), minValue, this.epsilon) >= 0) continue;
            minValue = tableau.getEntry(0, i);
            minPos = i;
        }
        return minPos;
    }

    private Integer getPivotRow(int col, SimplexTableau tableau) {
        double minRatio = Double.MAX_VALUE;
        Integer minRatioPos = null;
        for (int i = tableau.getNumObjectiveFunctions(); i < tableau.getHeight(); ++i) {
            double ratio;
            double rhs = tableau.getEntry(i, tableau.getWidth() - 1);
            if (MathUtils.compareTo(tableau.getEntry(i, col), 0.0, this.epsilon) < 0 || !((ratio = rhs / tableau.getEntry(i, col)) < minRatio)) continue;
            minRatio = ratio;
            minRatioPos = i;
        }
        return minRatioPos;
    }

    protected void doIteration(SimplexTableau tableau) throws OptimizationException {
        this.incrementIterationsCounter();
        Integer pivotCol = this.getPivotColumn(tableau);
        Integer pivotRow = this.getPivotRow(pivotCol, tableau);
        if (pivotRow == null) {
            throw new UnboundedSolutionException();
        }
        double pivotVal = tableau.getEntry(pivotRow, pivotCol);
        tableau.divideRow(pivotRow, pivotVal);
        for (int i = 0; i < tableau.getHeight(); ++i) {
            if (i == pivotRow) continue;
            double multiplier = tableau.getEntry(i, pivotCol);
            tableau.subtractRow(i, pivotRow, multiplier);
        }
    }

    private boolean isPhase1Solved(SimplexTableau tableau) {
        if (tableau.getNumArtificialVariables() == 0) {
            return true;
        }
        for (int i = tableau.getNumObjectiveFunctions(); i < tableau.getWidth() - 1; ++i) {
            if (MathUtils.compareTo(tableau.getEntry(0, i), 0.0, this.epsilon) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isOptimal(SimplexTableau tableau) {
        if (tableau.getNumArtificialVariables() > 0) {
            return false;
        }
        for (int i = tableau.getNumObjectiveFunctions(); i < tableau.getWidth() - 1; ++i) {
            if (MathUtils.compareTo(tableau.getEntry(0, i), 0.0, this.epsilon) >= 0) continue;
            return false;
        }
        return true;
    }

    protected void solvePhase1(SimplexTableau tableau) throws OptimizationException {
        if (tableau.getNumArtificialVariables() == 0) {
            return;
        }
        while (!this.isPhase1Solved(tableau)) {
            this.doIteration(tableau);
        }
        if (!MathUtils.equals(tableau.getEntry(0, tableau.getRhsOffset()), 0.0, this.epsilon)) {
            throw new NoFeasibleSolutionException();
        }
    }

    public RealPointValuePair doOptimize() throws OptimizationException {
        SimplexTableau tableau = new SimplexTableau(this.f, this.constraints, this.goalType, this.restrictToNonNegative, this.epsilon);
        this.solvePhase1(tableau);
        tableau.discardArtificialVariables();
        while (!this.isOptimal(tableau)) {
            this.doIteration(tableau);
        }
        return tableau.getSolution();
    }
}

