/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;

public class StringUtils {
    public static String toCamelCase(String s) {
        String[] parts = s.split("_");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (sb.length() == 0) {
                sb.append(part.toLowerCase());
                continue;
            }
            sb.append(StringUtils.toProperCase(part));
        }
        return sb.toString();
    }

    public static String toProperCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static <T> String joinClassAttributeValues(final T object, String name, Class<T> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("[");
        sb.append(org.apache.commons.lang.StringUtils.join((Collection)Collections2.transform((Collection)Collections2.filter(Arrays.asList(fields), (Predicate)new Predicate<Field>(){

            public boolean apply(Field field) {
                if ((field.getModifiers() & 8) == 8) {
                    return false;
                }
                return Character.isLowerCase(field.getName().charAt(0));
            }
        }), (Function)new Function<Field, String>(){

            public String apply(Field field) {
                Object value;
                try {
                    value = field.get(object);
                }
                catch (Exception e) {
                    value = "***";
                }
                return field.getName() + "=" + value;
            }
        }), (String)","));
        sb.append("]");
        return sb.toString();
    }

    public static <T> String joinClassGettersValues(final T object, String name, Class<T> clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("[");
        sb.append(org.apache.commons.lang.StringUtils.join((Collection)Collections2.transform((Collection)Collections2.filter(Arrays.asList(methods), (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                if ((method.getModifiers() & 8) == 8) {
                    return false;
                }
                return org.apache.commons.lang.StringUtils.startsWith((String)method.getName(), (String)"get");
            }
        }), (Function)new Function<Method, String>(){

            public String apply(Method method) {
                Object value;
                try {
                    value = method.invoke(object, new Object[0]);
                }
                catch (Exception e) {
                    value = "***";
                }
                return org.apache.commons.lang.StringUtils.uncapitalize((String)org.apache.commons.lang.StringUtils.substring((String)method.getName(), (int)3)) + "=" + value;
            }
        }), (String)","));
        sb.append("]");
        return sb.toString();
    }
}

