/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.model;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.AbstractColumnImpl;
import com.netflix.astyanax.model.ColumnList;
import java.nio.ByteBuffer;
import org.apache.cassandra.thrift.Column;

public class ThriftColumnImpl<C>
extends AbstractColumnImpl<C> {
    private final Column column;

    public ThriftColumnImpl(C name, Column column) {
        super(name);
        this.column = column;
    }

    @Override
    public <V> V getValue(Serializer<V> valSer) {
        return valSer.fromBytes(this.column.getValue());
    }

    @Override
    public <C2> ColumnList<C2> getSubColumns(Serializer<C2> ser) {
        throw new UnsupportedOperationException("SimpleColumn '" + this.getName() + "' has no children");
    }

    @Override
    public boolean isParentColumn() {
        return false;
    }

    @Override
    public long getTimestamp() {
        return this.column.getTimestamp();
    }

    @Override
    public ByteBuffer getRawName() {
        return ByteBuffer.wrap(this.column.getName());
    }

    @Override
    public int getTtl() {
        return this.column.isSetTtl() ? this.column.getTtl() : 0;
    }

    @Override
    public boolean hasValue() {
        return this.column.value != null && this.column.value.remaining() != 0;
    }
}

