/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.ddl;

import com.google.common.collect.Maps;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.FieldMetadata;
import com.netflix.astyanax.thrift.ThriftTypes;
import com.netflix.astyanax.thrift.ddl.ThriftColumnDefinitionImpl;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.thrift.meta_data.FieldMetaData;

public class ThriftColumnFamilyDefinitionImpl
implements ColumnFamilyDefinition {
    private static final Map<String, FieldMetadata> fieldsMetadata = Maps.newHashMap();
    private final CfDef cfDef;

    public ThriftColumnFamilyDefinitionImpl() {
        for (Map.Entry field : CfDef.metaDataMap.entrySet()) {
            fieldsMetadata.put(((FieldMetaData)field.getValue()).fieldName, new FieldMetadata(((CfDef._Fields)field.getKey()).name(), ThriftTypes.values()[((FieldMetaData)field.getValue()).valueMetaData.type].name(), ((FieldMetaData)field.getValue()).valueMetaData.isContainer()));
        }
        this.cfDef = new CfDef();
    }

    public ThriftColumnFamilyDefinitionImpl(CfDef cfDef) {
        for (Map.Entry field : CfDef.metaDataMap.entrySet()) {
            fieldsMetadata.put(((FieldMetaData)field.getValue()).fieldName, new FieldMetadata(((CfDef._Fields)field.getKey()).name(), ThriftTypes.values()[((FieldMetaData)field.getValue()).valueMetaData.type].name(), ((FieldMetaData)field.getValue()).valueMetaData.isContainer()));
        }
        this.cfDef = cfDef;
    }

    public CfDef getThriftColumnFamilyDefinition() {
        return this.cfDef;
    }

    @Override
    public ColumnFamilyDefinition setComment(String comment) {
        this.cfDef.setComment(comment);
        return this;
    }

    @Override
    public String getComment() {
        return this.cfDef.getComment();
    }

    @Override
    public ColumnFamilyDefinition setKeyspace(String keyspace) {
        this.cfDef.setKeyspace(keyspace);
        return this;
    }

    @Override
    public String getKeyspace() {
        return this.cfDef.getKeyspace();
    }

    @Override
    @Deprecated
    public ColumnFamilyDefinition setMemtableFlushAfterMins(Integer value) {
        throw new RuntimeException("API Remove in Cassandra 1.0");
    }

    @Override
    @Deprecated
    public Integer getMemtableFlushAfterMins() {
        throw new RuntimeException("API Remove in Cassandra 1.0");
    }

    @Override
    @Deprecated
    public ColumnFamilyDefinition setMemtableOperationsInMillions(Double value) {
        throw new RuntimeException("API Remove in Cassandra 1.0");
    }

    @Override
    @Deprecated
    public Double getMemtableOperationsInMillions() {
        throw new RuntimeException("API Remove in Cassandra 1.0");
    }

    @Override
    @Deprecated
    public ColumnFamilyDefinition setMemtableThroughputInMb(Integer value) {
        throw new RuntimeException("API Remove in Cassandra 1.0");
    }

    @Override
    public ColumnFamilyDefinition setMergeShardsChance(Double value) {
        this.cfDef.setMerge_shards_chance(value.doubleValue());
        return this;
    }

    @Override
    public ColumnFamilyDefinition setMinCompactionThreshold(Integer value) {
        if (value != null) {
            this.cfDef.setMin_compaction_threshold(value.intValue());
        }
        return this;
    }

    @Override
    public ColumnFamilyDefinition setName(String name) {
        this.cfDef.setName(name);
        return this;
    }

    @Override
    public String getName() {
        return this.cfDef.getName();
    }

    @Override
    public ColumnFamilyDefinition setReadRepairChance(Double value) {
        if (value != null) {
            this.cfDef.setRead_repair_chance(value.doubleValue());
        }
        return this;
    }

    @Override
    public ColumnFamilyDefinition setReplicateOnWrite(Boolean value) {
        if (value != null) {
            this.cfDef.setReplicate_on_write(value.booleanValue());
        }
        return this;
    }

    @Override
    public ColumnFamilyDefinition setRowCacheProvider(String value) {
        this.cfDef.setRow_cache_provider(value);
        return this;
    }

    @Override
    public ColumnFamilyDefinition setRowCacheSavePeriodInSeconds(Integer value) {
        if (value != null) {
            this.cfDef.setRow_cache_save_period_in_seconds(value.intValue());
        }
        return this;
    }

    @Override
    public ColumnFamilyDefinition setRowCacheSize(Double size) {
        if (size != null) {
            this.cfDef.setRow_cache_size(size.doubleValue());
        }
        return this;
    }

    @Override
    public ColumnFamilyDefinition setComparatorType(String value) {
        this.cfDef.setComparator_type(value);
        return this;
    }

    @Override
    public String getComparatorType() {
        return this.cfDef.getComparator_type();
    }

    @Override
    public ColumnFamilyDefinition setDefaultValidationClass(String value) {
        this.cfDef.setDefault_validation_class(value);
        return this;
    }

    @Override
    public String getDefaultValidationClass() {
        return this.cfDef.getDefault_validation_class();
    }

    @Override
    public ColumnFamilyDefinition setId(Integer id) {
        this.cfDef.setId(id.intValue());
        return this;
    }

    @Override
    public Integer getId() {
        return this.cfDef.getId();
    }

    @Override
    public ColumnFamilyDefinition setKeyAlias(ByteBuffer alias) {
        this.cfDef.setKey_alias(alias);
        return this;
    }

    @Override
    public ByteBuffer getKeyAlias() {
        if (this.cfDef.getKey_alias() == null) {
            return null;
        }
        return ByteBuffer.wrap(this.cfDef.getKey_alias());
    }

    @Override
    public ColumnFamilyDefinition setKeyCacheSavePeriodInSeconds(Integer value) {
        if (value != null) {
            this.cfDef.setKey_cache_save_period_in_seconds(value.intValue());
        }
        return this;
    }

    @Override
    public Integer getKeyCacheSavePeriodInSeconds() {
        return this.cfDef.getKey_cache_save_period_in_seconds();
    }

    @Override
    public ColumnFamilyDefinition setKeyCacheSize(Double keyCacheSize) {
        if (keyCacheSize != null) {
            this.cfDef.setKey_cache_size(keyCacheSize.doubleValue());
        }
        return this;
    }

    @Override
    public ColumnFamilyDefinition setKeyValidationClass(String keyValidationClass) {
        this.cfDef.setKey_validation_class(keyValidationClass);
        return this;
    }

    @Override
    public String getKeyValidationClass() {
        return this.cfDef.getKey_validation_class();
    }

    @Override
    public ColumnFamilyDefinition addColumnDefinition(ColumnDefinition columnDef) {
        ArrayList<ColumnDef> columns = this.cfDef.getColumn_metadata();
        if (columns == null) {
            columns = new ArrayList<ColumnDef>();
            this.cfDef.setColumn_metadata(columns);
        }
        columns.add(((ThriftColumnDefinitionImpl)columnDef).getThriftColumnDefinition());
        return this;
    }

    @Override
    public List<ColumnDefinition> getColumnDefinitionList() {
        ArrayList<ColumnDefinition> list = new ArrayList<ColumnDefinition>();
        List cdefs = this.cfDef.getColumn_metadata();
        if (cdefs != null) {
            for (ColumnDef cdef : cdefs) {
                list.add(new ThriftColumnDefinitionImpl(cdef));
            }
        }
        return list;
    }

    @Override
    public void clearColumnDefinitionList() {
        this.cfDef.setColumn_metadata(new ArrayList());
    }

    @Override
    @Deprecated
    public Integer getMemtableThroughputInMb() {
        throw new RuntimeException("API Remove in Cassandra 1.0");
    }

    @Override
    public Double getMergeShardsChance() {
        return this.cfDef.merge_shards_chance;
    }

    @Override
    public Integer getMinCompactionThreshold() {
        return this.cfDef.min_compaction_threshold;
    }

    @Override
    public Double getReadRepairChance() {
        return this.cfDef.read_repair_chance;
    }

    @Override
    public Boolean getReplicateOnWrite() {
        return this.cfDef.replicate_on_write;
    }

    @Override
    public String getRowCacheProvider() {
        return this.cfDef.row_cache_provider;
    }

    @Override
    public Integer getRowCacheSavePeriodInSeconds() {
        return this.cfDef.row_cache_save_period_in_seconds;
    }

    @Override
    public Double getRowCacheSize() {
        return this.cfDef.row_cache_size;
    }

    @Override
    public Double getKeyCacheSize() {
        return this.cfDef.key_cache_size;
    }

    @Override
    public Collection<String> getFieldNames() {
        return fieldsMetadata.keySet();
    }

    @Override
    public Object getFieldValue(String name) {
        return this.cfDef.getFieldValue(CfDef._Fields.valueOf((String)name));
    }

    @Override
    public ColumnFamilyDefinition setFieldValue(String name, Object value) {
        this.cfDef.setFieldValue(CfDef._Fields.valueOf((String)name), value);
        return this;
    }

    @Override
    public ColumnDefinition makeColumnDefinition() {
        return new ThriftColumnDefinitionImpl();
    }

    @Override
    public Collection<FieldMetadata> getFieldsMetadata() {
        return fieldsMetadata.values();
    }

    @Override
    public ColumnFamilyDefinition setMaxCompactionThreshold(Integer value) {
        if (value != null) {
            this.cfDef.setMax_compaction_threshold(value.intValue());
        }
        return this;
    }

    @Override
    public Integer getMaxCompactionThreshold() {
        return this.cfDef.getMax_compaction_threshold();
    }

    @Override
    public ColumnFamilyDefinition setCompactionStrategy(String strategy) {
        this.cfDef.setCompaction_strategy(strategy);
        return this;
    }

    @Override
    public String getCompactionStrategy() {
        return this.cfDef.getCompaction_strategy();
    }

    @Override
    public ColumnFamilyDefinition setCompactionStrategyOptions(Map<String, String> options) {
        this.cfDef.setCompaction_strategy_options(options);
        return this;
    }

    @Override
    public Map<String, String> getCompactionStrategyOptions() {
        return this.cfDef.getCompaction_strategy_options();
    }

    @Override
    public ColumnFamilyDefinition setCompressionOptions(Map<String, String> options) {
        this.cfDef.setCompression_options(options);
        return this;
    }

    @Override
    public Map<String, String> getCompressionOptions() {
        return this.cfDef.getCompression_options();
    }

    @Override
    public ColumnFamilyDefinition setBloomFilterFpChance(Double chance) {
        if (chance != null) {
            this.cfDef.setBloom_filter_fp_chance(chance.doubleValue());
        }
        return this;
    }

    @Override
    public Double getBloomFilterFpChance() {
        return this.cfDef.getBloom_filter_fp_chance();
    }

    @Override
    public ColumnFamilyDefinition setCaching(String caching) {
        this.cfDef.setCaching(caching);
        return this;
    }

    @Override
    public String getCaching() {
        return this.cfDef.getCaching();
    }

    @Override
    public ColumnFamilyDefinition setLocalReadRepairChance(Double value) {
        if (value != null) {
            this.cfDef.setDclocal_read_repair_chance(value.doubleValue());
        }
        return this;
    }

    @Override
    public Double getLocalReadRepairChance() {
        return this.cfDef.getDclocal_read_repair_chance();
    }

    @Override
    public ColumnFamilyDefinition setGcGraceSeconds(Integer seconds) {
        if (seconds != null) {
            this.cfDef.setGc_grace_seconds(seconds.intValue());
        }
        return this;
    }

    @Override
    public Integer getGcGraceSeconds() {
        return this.cfDef.getGc_grace_seconds();
    }

    @Override
    public void setFields(Map<String, Object> options) {
        for (Map.Entry<String, FieldMetadata> field : fieldsMetadata.entrySet()) {
            String fieldName = field.getKey();
            if (!options.containsKey(fieldName)) continue;
            if (fieldName.equals("column_metadata")) {
                Map columns = (Map)options.get("column_metadata");
                for (Map.Entry column : columns.entrySet()) {
                    ThriftColumnDefinitionImpl columnDef = new ThriftColumnDefinitionImpl();
                    columnDef.setName(((String)column.getKey()).toString());
                    columnDef.setFields((Map)column.getValue());
                    this.addColumnDefinition(columnDef);
                }
                continue;
            }
            this.setFieldValue(field.getValue().getName(), options.get(fieldName));
        }
    }
}

