/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.netflix.astyanax.Serializer;
import java.nio.ByteBuffer;
import org.apache.cassandra.thrift.SliceRange;

public class ThriftUtils {
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);
    public static final int MUTATION_OVERHEAD = 20;

    public static SliceRange createAllInclusiveSliceRange() {
        return new SliceRange(EMPTY_BYTE_BUFFER, EMPTY_BYTE_BUFFER, false, Integer.MAX_VALUE);
    }

    public static <C> SliceRange createSliceRange(Serializer<C> serializer, C startColumn, C endColumn, boolean reversed, int limit) {
        return new SliceRange(startColumn == null ? EMPTY_BYTE_BUFFER : serializer.toByteBuffer(startColumn), endColumn == null ? EMPTY_BYTE_BUFFER : serializer.toByteBuffer(endColumn), reversed, limit);
    }
}

