/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.Cluster;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.KeyspaceTracerFactory;
import com.netflix.astyanax.connectionpool.ConnectionFactory;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.thrift.ThriftClusterImpl;
import com.netflix.astyanax.thrift.ThriftKeyspaceImpl;
import com.netflix.astyanax.thrift.ThriftSyncConnectionFactoryImpl;
import org.apache.cassandra.thrift.Cassandra;

public class ThriftFamilyFactory
implements AstyanaxTypeFactory<Cassandra.Client> {
    private static final ThriftFamilyFactory instance = new ThriftFamilyFactory();

    public static ThriftFamilyFactory getInstance() {
        return instance;
    }

    @Override
    public Keyspace createKeyspace(String ksName, ConnectionPool<Cassandra.Client> cp, AstyanaxConfiguration asConfig, KeyspaceTracerFactory tracerFactory) {
        return new ThriftKeyspaceImpl(ksName, cp, asConfig, tracerFactory);
    }

    @Override
    public Cluster createCluster(ConnectionPool<Cassandra.Client> cp, AstyanaxConfiguration asConfig, KeyspaceTracerFactory tracerFactory) {
        return new ThriftClusterImpl(asConfig, cp, tracerFactory);
    }

    @Override
    public ConnectionFactory<Cassandra.Client> createConnectionFactory(AstyanaxConfiguration asConfig, ConnectionPoolConfiguration cfConfig, KeyspaceTracerFactory tracerFactory, ConnectionPoolMonitor monitor) {
        return new ThriftSyncConnectionFactoryImpl(asConfig, cfConfig, tracerFactory, monitor);
    }
}

