/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.connectionpool.ConnectionContext;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.CqlStatement;
import com.netflix.astyanax.cql.CqlStatementResult;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.thrift.AbstractKeyspaceOperationImpl;
import com.netflix.astyanax.thrift.ThriftCqlStatementResult;
import com.netflix.astyanax.thrift.ThriftKeyspaceImpl;
import java.nio.ByteBuffer;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Compression;

public class ThriftCqlStatement
implements CqlStatement {
    private ThriftKeyspaceImpl keyspace;
    private ByteBuffer query;
    private Compression compression = Compression.NONE;
    private RetryPolicy retry;

    public ThriftCqlStatement(ThriftKeyspaceImpl keyspace) {
        this.keyspace = keyspace;
        this.retry = keyspace.getConfig().getRetryPolicy();
    }

    @Override
    public OperationResult<CqlStatementResult> execute() throws ConnectionException {
        return this.keyspace.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<CqlStatementResult>(this.keyspace.tracerFactory.newTracer(CassandraOperationType.CQL, null), null, this.keyspace.getKeyspaceName()){

            @Override
            public CqlStatementResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return new ThriftCqlStatementResult(client.execute_cql_query(ThriftCqlStatement.this.query, ThriftCqlStatement.this.compression));
            }
        }, this.retry);
    }

    @Override
    public ListenableFuture<OperationResult<CqlStatementResult>> executeAsync() throws ConnectionException {
        return null;
    }

    @Override
    public CqlStatement withCql(String cql) {
        this.query = StringSerializer.get().toByteBuffer(cql);
        return this;
    }

    public CqlStatement withCompression(Boolean flag) {
        this.compression = flag != false ? Compression.GZIP : Compression.NONE;
        return this;
    }
}

