/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.Cluster;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.KeyspaceTracerFactory;
import com.netflix.astyanax.connectionpool.ConnectionContext;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.OperationException;
import com.netflix.astyanax.connectionpool.exceptions.SchemaDisagreementException;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.ddl.SchemaChangeResult;
import com.netflix.astyanax.ddl.impl.SchemaChangeResponseImpl;
import com.netflix.astyanax.retry.RunOnce;
import com.netflix.astyanax.thrift.AbstractKeyspaceOperationImpl;
import com.netflix.astyanax.thrift.AbstractOperationImpl;
import com.netflix.astyanax.thrift.ThriftKeyspaceImpl;
import com.netflix.astyanax.thrift.ddl.ThriftColumnDefinitionImpl;
import com.netflix.astyanax.thrift.ddl.ThriftColumnFamilyDefinitionImpl;
import com.netflix.astyanax.thrift.ddl.ThriftKeyspaceDefinitionImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.KsDef;

public class ThriftClusterImpl
implements Cluster {
    private static final int MAX_SCHEMA_CHANGE_ATTEMPTS = 6;
    private static final int SCHEMA_DISAGREEMENT_BACKOFF = 10000;
    private final ConnectionPool<Cassandra.Client> connectionPool;
    private final ConcurrentMap<String, Keyspace> keyspaces;
    private final AstyanaxConfiguration config;
    private final KeyspaceTracerFactory tracerFactory;

    public ThriftClusterImpl(AstyanaxConfiguration config, ConnectionPool<Cassandra.Client> connectionPool, KeyspaceTracerFactory tracerFactory) {
        this.config = config;
        this.connectionPool = connectionPool;
        this.tracerFactory = tracerFactory;
        this.keyspaces = Maps.newConcurrentMap();
    }

    @Override
    public String describeClusterName() throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractOperationImpl<String>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_CLUSTER)){

            @Override
            public String internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return client.describe_cluster_name();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    @Override
    public String describeSnitch() throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractOperationImpl<String>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_SNITCH)){

            @Override
            public String internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return client.describe_snitch();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    @Override
    public String describePartitioner() throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractOperationImpl<String>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_PARTITIONER)){

            @Override
            public String internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return client.describe_partitioner();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    @Override
    public Map<String, List<String>> describeSchemaVersions() throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractOperationImpl<Map<String, List<String>>>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_SCHEMA_VERSION)){

            @Override
            public Map<String, List<String>> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return client.describe_schema_versions();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    @Override
    public String getVersion() throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractOperationImpl<String>(this.tracerFactory.newTracer(CassandraOperationType.GET_VERSION)){

            @Override
            public String internalExecute(Cassandra.Client client, ConnectionContext state) throws Exception {
                return client.describe_version();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    private <K> OperationResult<K> executeSchemaChangeOperation(AbstractOperationImpl<K> op) throws OperationException, ConnectionException {
        int attempt = 0;
        while (true) {
            try {
                return this.connectionPool.executeWithFailover(op, this.config.getRetryPolicy().duplicate());
            }
            catch (SchemaDisagreementException e) {
                if (++attempt >= 6) {
                    throw e;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    Thread.interrupted();
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    @Override
    public List<KeyspaceDefinition> describeKeyspaces() throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractOperationImpl<List<KeyspaceDefinition>>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_KEYSPACES)){

            @Override
            public List<KeyspaceDefinition> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                List ksDefs = client.describe_keyspaces();
                return Lists.transform((List)ksDefs, (Function)new Function<KsDef, KeyspaceDefinition>(){

                    public KeyspaceDefinition apply(KsDef ksDef) {
                        return new ThriftKeyspaceDefinitionImpl(ksDef);
                    }
                });
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    @Override
    public KeyspaceDefinition describeKeyspace(String ksName) throws ConnectionException {
        List<KeyspaceDefinition> ksDefs = this.describeKeyspaces();
        for (KeyspaceDefinition ksDef : ksDefs) {
            if (!ksDef.getName().equals(ksName)) continue;
            return ksDef;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Keyspace getKeyspace(String ksName) {
        Keyspace keyspace = (Keyspace)this.keyspaces.get(ksName);
        if (keyspace == null) {
            ThriftClusterImpl thriftClusterImpl = this;
            synchronized (thriftClusterImpl) {
                ThriftKeyspaceImpl newKeyspace = new ThriftKeyspaceImpl(ksName, this.connectionPool, this.config, this.tracerFactory);
                keyspace = this.keyspaces.putIfAbsent(ksName, newKeyspace);
                if (keyspace == null) {
                    keyspace = newKeyspace;
                }
            }
        }
        return keyspace;
    }

    @Override
    public ColumnFamilyDefinition makeColumnFamilyDefinition() {
        return new ThriftColumnFamilyDefinitionImpl();
    }

    @Override
    public OperationResult<SchemaChangeResult> addColumnFamily(final ColumnFamilyDefinition def) throws ConnectionException {
        return this.executeSchemaChangeOperation(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_COLUMN_FAMILY), def.getKeyspace()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return new SchemaChangeResponseImpl().setSchemaId(client.system_add_column_family(((ThriftColumnFamilyDefinitionImpl)def).getThriftColumnFamilyDefinition()));
            }
        });
    }

    @Override
    public OperationResult<SchemaChangeResult> updateColumnFamily(final ColumnFamilyDefinition def) throws ConnectionException {
        return this.executeSchemaChangeOperation(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.UPDATE_COLUMN_FAMILY), def.getKeyspace()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return new SchemaChangeResponseImpl().setSchemaId(client.system_update_column_family(((ThriftColumnFamilyDefinitionImpl)def).getThriftColumnFamilyDefinition()));
            }
        });
    }

    @Override
    public KeyspaceDefinition makeKeyspaceDefinition() {
        return new ThriftKeyspaceDefinitionImpl();
    }

    @Override
    public OperationResult<SchemaChangeResult> addKeyspace(final KeyspaceDefinition def) throws ConnectionException {
        return this.executeSchemaChangeOperation(new AbstractOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_KEYSPACE)){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return new SchemaChangeResponseImpl().setSchemaId(client.system_add_keyspace(((ThriftKeyspaceDefinitionImpl)def).getThriftKeyspaceDefinition()));
            }
        });
    }

    @Override
    public OperationResult<SchemaChangeResult> updateKeyspace(final KeyspaceDefinition def) throws ConnectionException {
        return this.executeSchemaChangeOperation(new AbstractOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.UPDATE_KEYSPACE)){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return new SchemaChangeResponseImpl().setSchemaId(client.system_update_keyspace(((ThriftKeyspaceDefinitionImpl)def).getThriftKeyspaceDefinition()));
            }
        });
    }

    @Override
    public ColumnDefinition makeColumnDefinition() {
        return new ThriftColumnDefinitionImpl();
    }

    @Override
    public AstyanaxConfiguration getConfig() {
        return this.config;
    }

    @Override
    public <K, C> OperationResult<SchemaChangeResult> createColumnFamily(final Map<String, Object> options) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_COLUMN_FAMILY), (String)options.get("keyspace")){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftColumnFamilyDefinitionImpl def = new ThriftColumnFamilyDefinitionImpl();
                def.setFields(options);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_add_column_family(def.getThriftColumnFamilyDefinition()));
            }
        }, RunOnce.get());
    }

    @Override
    public <K, C> OperationResult<SchemaChangeResult> updateColumnFamily(final Map<String, Object> options) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.UPDATE_COLUMN_FAMILY), (String)options.get("keyspace")){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftColumnFamilyDefinitionImpl def = new ThriftColumnFamilyDefinitionImpl();
                def.setFields(options);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_update_column_family(def.getThriftColumnFamilyDefinition()));
            }
        }, RunOnce.get());
    }

    @Override
    public OperationResult<SchemaChangeResult> dropColumnFamily(String keyspaceName, final String columnFamilyName) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.DROP_COLUMN_FAMILY), keyspaceName){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return new SchemaChangeResponseImpl().setSchemaId(client.system_drop_column_family(columnFamilyName));
            }
        }, RunOnce.get());
    }

    @Override
    public OperationResult<SchemaChangeResult> createKeyspace(final Map<String, Object> options) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_KEYSPACE)){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftKeyspaceDefinitionImpl def = new ThriftKeyspaceDefinitionImpl();
                def.setFields(options);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_add_keyspace(def.getThriftKeyspaceDefinition()));
            }
        }, RunOnce.get());
    }

    @Override
    public OperationResult<SchemaChangeResult> updateKeyspace(final Map<String, Object> options) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.UPDATE_KEYSPACE), (String)options.get("name")){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftKeyspaceDefinitionImpl def = new ThriftKeyspaceDefinitionImpl();
                def.setFields(options);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_update_keyspace(def.getThriftKeyspaceDefinition()));
            }
        }, RunOnce.get());
    }

    @Override
    public OperationResult<SchemaChangeResult> dropKeyspace(final String keyspaceName) throws ConnectionException {
        return this.connectionPool.executeWithFailover(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.DROP_KEYSPACE), keyspaceName){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return new SchemaChangeResponseImpl().setSchemaId(client.system_drop_keyspace(keyspaceName));
            }
        }, RunOnce.get());
    }
}

