/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.annotations.Component;
import com.netflix.astyanax.model.Equality;
import com.netflix.astyanax.model.RangeEndpoint;
import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.serializers.ByteBufferOutputStream;
import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.serializers.CompositeRangeBuilder;
import com.netflix.astyanax.serializers.SerializerTypeInferer;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AnnotatedCompositeSerializer<T>
extends AbstractSerializer<T> {
    private static byte END_OF_COMPONENT = 0;
    private static ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private final List<ComponentSerializer<?>> components;
    private final Class<T> clazz;
    private final int bufferSize;

    public AnnotatedCompositeSerializer(Class<T> clazz, boolean includeParentFields) {
        this(clazz, 512, includeParentFields);
    }

    public AnnotatedCompositeSerializer(Class<T> clazz) {
        this(clazz, 512, false);
    }

    public AnnotatedCompositeSerializer(Class<T> clazz, int bufferSize) {
        this(clazz, bufferSize, false);
    }

    public AnnotatedCompositeSerializer(Class<T> clazz, int bufferSize, boolean includeParentFields) {
        this.clazz = clazz;
        this.components = new ArrayList();
        this.bufferSize = bufferSize;
        for (Field field : this.getFields(clazz, includeParentFields)) {
            Component annotation = field.getAnnotation(Component.class);
            if (annotation == null) continue;
            Serializer s = SerializerTypeInferer.getSerializer(field.getType());
            this.components.add(AnnotatedCompositeSerializer.makeComponent(field, s, annotation.ordinal()));
        }
        Collections.sort(this.components);
    }

    private List<Field> getFields(Class clazz, boolean recursuvely) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        if (clazz.getDeclaredFields() != null && clazz.getDeclaredFields().length > 0) {
            allFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            if (recursuvely && clazz.getSuperclass() != null) {
                allFields.addAll(this.getFields(clazz.getSuperclass(), true));
            }
        }
        return allFields;
    }

    @Override
    public ByteBuffer toByteBuffer(T obj) {
        ByteBuffer bb = ByteBuffer.allocate(this.bufferSize);
        for (ComponentSerializer<?> serializer : this.components) {
            try {
                ByteBuffer cb = serializer.serialize(obj);
                if (cb == null) {
                    cb = ByteBuffer.allocate(0);
                }
                if (cb.limit() + 3 > bb.remaining()) {
                    ByteBuffer temp = ByteBuffer.allocate(bb.limit() * 2);
                    bb.flip();
                    temp.put(bb);
                    bb = temp;
                }
                bb.putShort((short)cb.remaining());
                bb.put(cb.slice());
                bb.put(END_OF_COMPONENT);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        bb.flip();
        return bb;
    }

    @Override
    public T fromByteBuffer(ByteBuffer byteBuffer) {
        byteBuffer = byteBuffer.duplicate();
        try {
            T obj = this.createContents(this.clazz);
            for (ComponentSerializer<?> serializer : this.components) {
                ByteBuffer data = AnnotatedCompositeSerializer.getWithShortLength(byteBuffer);
                if (data != null) {
                    byte end_of_component;
                    if (data.remaining() > 0) {
                        serializer.deserialize(obj, data);
                    }
                    if ((end_of_component = byteBuffer.get()) == END_OF_COMPONENT) continue;
                    throw new RuntimeException("Invalid composite column.  Expected END_OF_COMPONENT.");
                }
                throw new RuntimeException("Missing component data in composite type");
            }
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.COMPOSITETYPE;
    }

    private static int getShortLength(ByteBuffer bb) {
        int length = (bb.get() & 0xFF) << 8;
        return length | bb.get() & 0xFF;
    }

    private static ByteBuffer getWithShortLength(ByteBuffer bb) {
        int length = AnnotatedCompositeSerializer.getShortLength(bb);
        return AnnotatedCompositeSerializer.getBytes(bb, length);
    }

    private static ByteBuffer getBytes(ByteBuffer bb, int length) {
        ByteBuffer copy = bb.duplicate();
        copy.limit(copy.position() + length);
        bb.position(bb.position() + length);
        return copy;
    }

    private static <P> ComponentSerializer<P> makeComponent(Field field, Serializer<P> serializer, int ordinal) {
        return new ComponentSerializer<P>(field, serializer, ordinal);
    }

    private T createContents(Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    public CompositeRangeBuilder buildRange() {
        return new CompositeRangeBuilder(){
            private int position = 0;

            @Override
            public void nextComponent() {
                ++this.position;
            }

            @Override
            public void append(ByteBufferOutputStream out, Object value, Equality equality) {
                ByteBuffer cb;
                ComponentSerializer serializer = (ComponentSerializer)AnnotatedCompositeSerializer.this.components.get(this.position);
                try {
                    cb = serializer.serializeValue(value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (cb == null) {
                    cb = EMPTY_BYTE_BUFFER;
                }
                out.writeShort((short)cb.remaining());
                out.write(cb.slice());
                out.write(equality.toByte());
            }
        };
    }

    public <T1> RangeEndpoint makeEndpoint(T1 value, Equality equality) {
        RangeEndpoint endpoint = new RangeEndpoint(){
            private ByteBuffer out;
            private int position;
            private boolean done;
            {
                this.out = ByteBuffer.allocate(AnnotatedCompositeSerializer.this.bufferSize);
                this.position = 0;
                this.done = false;
            }

            @Override
            public RangeEndpoint append(Object value, Equality equality) {
                ByteBuffer cb;
                ComponentSerializer serializer = (ComponentSerializer)AnnotatedCompositeSerializer.this.components.get(this.position);
                ++this.position;
                try {
                    cb = serializer.serializeValue(value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (cb == null) {
                    cb = EMPTY_BYTE_BUFFER;
                }
                if (cb.limit() + 3 > this.out.remaining()) {
                    ByteBuffer temp = ByteBuffer.allocate(this.out.limit() * 2);
                    this.out.flip();
                    temp.put(this.out);
                    this.out = temp;
                }
                this.out.putShort((short)cb.remaining());
                this.out.put(cb.slice());
                this.out.put(equality.toByte());
                return this;
            }

            @Override
            public ByteBuffer toBytes() {
                if (!this.done) {
                    this.out.flip();
                    this.done = true;
                }
                return this.out;
            }
        };
        endpoint.append(value, equality);
        return endpoint;
    }

    public static class ComponentSerializer<P>
    implements Comparable<ComponentSerializer<?>> {
        private Field field;
        private Serializer<P> serializer;
        private int ordinal;

        public ComponentSerializer(Field field, Serializer<P> serializer, int ordinal) {
            this.field = field;
            this.field.setAccessible(true);
            this.serializer = serializer;
            this.ordinal = ordinal;
        }

        public Field getField() {
            return this.field;
        }

        public ByteBuffer serialize(Object obj) throws IllegalArgumentException, IllegalAccessException {
            Object value = this.field.get(obj);
            ByteBuffer buf = this.serializer.toByteBuffer(value);
            return buf;
        }

        public void deserialize(Object obj, ByteBuffer value) throws IllegalArgumentException, IllegalAccessException {
            this.field.set(obj, this.serializer.fromByteBuffer(value));
        }

        public ByteBuffer serializeValue(Object value) {
            ByteBuffer buf = this.serializer.toByteBuffer(value);
            return buf;
        }

        @Override
        public int compareTo(ComponentSerializer<?> other) {
            return this.ordinal - other.ordinal;
        }
    }
}

