/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.queue.triggers;

import com.netflix.astyanax.recipes.queue.triggers.AbstractTrigger;
import com.netflix.astyanax.recipes.queue.triggers.Trigger;
import java.util.concurrent.TimeUnit;

public class RepeatingTrigger
extends AbstractTrigger {
    private Long delay;
    private long interval = 0L;
    private Long repeatCount;
    private long endTime = 0L;

    @Override
    public Trigger nextTrigger() {
        if (this.repeatCount != null && this.getExecutionCount() + 1L >= this.repeatCount) {
            return null;
        }
        long currentTime = System.currentTimeMillis();
        long nextTime = this.getTriggerTime() + this.interval;
        if (this.endTime != 0L && (nextTime > this.endTime || currentTime > this.endTime)) {
            return null;
        }
        RepeatingTrigger next = new RepeatingTrigger();
        next.delay = this.delay;
        next.interval = this.interval;
        next.repeatCount = this.repeatCount;
        next.setExecutionCount(this.getExecutionCount() + 1L);
        next.setTriggerTime(this.getTriggerTime() + this.interval);
        return next;
    }

    public Long getDelay() {
        return this.delay;
    }

    public long getInterval() {
        return this.interval;
    }

    public Long getRepeatCount() {
        return this.repeatCount;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setRepeatCount(long repeatCount) {
        this.repeatCount = repeatCount;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public String toString() {
        return "RepeatingTrigger [delay=" + this.delay + ", interval=" + this.interval + ", repeatCount=" + this.repeatCount + ", endTime=" + this.endTime + "] " + super.toString();
    }

    public static class Builder {
        private RepeatingTrigger trigger = new RepeatingTrigger();

        public Builder withInterval(long interval, TimeUnit units) {
            this.trigger.interval = TimeUnit.MILLISECONDS.convert(interval, units);
            return this;
        }

        public Builder withDelay(long delay, TimeUnit units) {
            this.trigger.delay = TimeUnit.MILLISECONDS.convert(delay, units);
            return this;
        }

        public Builder withRepeatCount(long repeatCount) {
            this.trigger.repeatCount = repeatCount;
            return this;
        }

        public Builder withEndTime(long endTime, TimeUnit units) {
            this.trigger.endTime = TimeUnit.MILLISECONDS.convert(endTime, units);
            return this;
        }

        public RepeatingTrigger build() {
            if (this.trigger.delay != null) {
                this.trigger.setTriggerTime(System.currentTimeMillis() + this.trigger.delay);
            } else {
                this.trigger.setTriggerTime(System.currentTimeMillis());
            }
            return this.trigger;
        }
    }
}

