/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.queue;

import com.netflix.astyanax.annotations.Component;
import com.netflix.astyanax.recipes.queue.Message;
import com.netflix.astyanax.recipes.queue.MessageQueueEntryState;
import com.netflix.astyanax.recipes.queue.MessageQueueEntryType;
import com.netflix.astyanax.util.TimeUUIDUtils;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class MessageQueueEntry {
    private static final String ID_DELIMITER = ":";
    @Component(ordinal=0)
    private Byte type;
    @Component(ordinal=1)
    private Byte priority;
    @Component(ordinal=2)
    private UUID timestamp;
    @Component(ordinal=3)
    private UUID random;
    @Component(ordinal=4)
    private Byte state;

    public MessageQueueEntry() {
    }

    public MessageQueueEntry(String id) {
        String[] parts = StringUtils.split((String)id, (String)ID_DELIMITER);
        if (parts.length != 5) {
            throw new RuntimeException("Invalid message ID.  Expection <type>:<priority>:<timestamp>:<random>:<state> but got " + id);
        }
        this.type = Byte.parseByte(parts[0]);
        this.priority = Byte.parseByte(parts[1]);
        this.timestamp = UUID.fromString(parts[2]);
        this.random = UUID.fromString(parts[3]);
        this.state = Byte.parseByte(parts[4]);
    }

    private MessageQueueEntry(MessageQueueEntryType type, byte priority, UUID timestamp, UUID random, MessageQueueEntryState state) {
        this.type = (byte)type.ordinal();
        this.priority = 0;
        this.timestamp = timestamp;
        this.state = (byte)state.ordinal();
        this.random = random == null ? TimeUUIDUtils.getUniqueTimeUUIDinMicros() : random;
    }

    public static MessageQueueEntry newLockEntry(MessageQueueEntryState state) {
        return new MessageQueueEntry(MessageQueueEntryType.Lock, 0, TimeUUIDUtils.getUniqueTimeUUIDinMicros(), null, state);
    }

    public static MessageQueueEntry newLockEntry(UUID timestamp, MessageQueueEntryState state) {
        return new MessageQueueEntry(MessageQueueEntryType.Lock, 0, timestamp, null, state);
    }

    public static MessageQueueEntry newMetadataEntry() {
        return new MessageQueueEntry(MessageQueueEntryType.Metadata, 0, null, null, MessageQueueEntryState.None);
    }

    public static MessageQueueEntry newMessageEntry(byte priority, UUID timestamp, MessageQueueEntryState state) {
        return new MessageQueueEntry(MessageQueueEntryType.Message, priority, timestamp, null, state);
    }

    public static MessageQueueEntry newBusyEntry(Message message) {
        return new MessageQueueEntry(MessageQueueEntryType.Message, message.getPriority(), message.getToken(), message.getRandom(), MessageQueueEntryState.Busy);
    }

    public MessageQueueEntryType getType() {
        return MessageQueueEntryType.values()[this.type];
    }

    public UUID getTimestamp() {
        return this.timestamp;
    }

    public long getTimetsamp(TimeUnit units) {
        return units.convert(TimeUUIDUtils.getMicrosTimeFromUUID(this.timestamp), TimeUnit.MICROSECONDS);
    }

    public MessageQueueEntryState getState() {
        return MessageQueueEntryState.values()[this.state];
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public void setTimestamp(UUID timestamp) {
        this.timestamp = timestamp;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public void setPriorty(Byte priority) {
        this.priority = priority;
    }

    public String getMessageId() {
        return this.type + ID_DELIMITER + this.priority + ID_DELIMITER + this.timestamp.toString() + ID_DELIMITER + this.random.toString() + ID_DELIMITER + this.state;
    }

    public UUID getRandom() {
        return this.random;
    }

    public void setRandom(UUID random) {
        this.random = random;
    }

    public String toString() {
        return "MessageQueueEntry [type=" + this.type + ", priority=" + this.priority + ", timestamp=" + this.timestamp + ", random=" + this.random + ", state=" + this.state + "]";
    }
}

