/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.model;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.AbstractComposite;
import com.netflix.astyanax.model.CompositeBuilder;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.TimeUUIDSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import com.netflix.astyanax.util.TimeUUIDUtils;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class CompositeBuilderImpl
implements CompositeBuilder {
    private AbstractComposite composite;
    private AbstractComposite.ComponentEquality equality = AbstractComposite.ComponentEquality.EQUAL;

    public CompositeBuilderImpl(AbstractComposite composite) {
        this.composite = composite;
    }

    @Override
    public CompositeBuilder addString(String value) {
        this.composite.addComponent(value, StringSerializer.get(), this.equality);
        return this;
    }

    @Override
    public CompositeBuilder addLong(Long value) {
        this.composite.addComponent(value, LongSerializer.get(), this.equality);
        return this;
    }

    @Override
    public CompositeBuilder addInteger(Integer value) {
        this.composite.addComponent(value, IntegerSerializer.get(), this.equality);
        return this;
    }

    @Override
    public CompositeBuilder addBoolean(Boolean value) {
        this.composite.addComponent(value, BooleanSerializer.get(), this.equality);
        return this;
    }

    @Override
    public CompositeBuilder addUUID(UUID value) {
        this.composite.addComponent(value, UUIDSerializer.get(), this.equality);
        return this;
    }

    @Override
    public <T> CompositeBuilder add(T value, Serializer<T> serializer) {
        this.composite.addComponent(value, serializer, this.equality);
        return this;
    }

    @Override
    public CompositeBuilder addTimeUUID(UUID value) {
        this.composite.addComponent(value, TimeUUIDSerializer.get(), this.equality);
        return this;
    }

    @Override
    public CompositeBuilder addTimeUUID(Long value, TimeUnit units) {
        this.composite.addComponent(TimeUUIDUtils.getMicrosTimeUUID(TimeUnit.MICROSECONDS.convert(value, units)), TimeUUIDSerializer.get(), this.equality);
        return this;
    }

    @Override
    public CompositeBuilder addBytes(byte[] bytes) {
        this.composite.addComponent(ByteBuffer.wrap(bytes), ByteBufferSerializer.get(), this.equality);
        return this;
    }

    @Override
    public CompositeBuilder addBytes(ByteBuffer bb) {
        this.composite.addComponent(bb, ByteBufferSerializer.get(), this.equality);
        return this;
    }

    @Override
    public ByteBuffer build() {
        return this.composite.serialize();
    }

    @Override
    public CompositeBuilder greaterThanEquals() {
        this.equality = AbstractComposite.ComponentEquality.GREATER_THAN_EQUAL;
        return this;
    }

    @Override
    public CompositeBuilder lessThanEquals() {
        this.equality = AbstractComposite.ComponentEquality.LESS_THAN_EQUAL;
        return this;
    }
}

