/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.model;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.impl.PreparedIndexExpressionImpl;
import com.netflix.astyanax.model.ColumnType;
import com.netflix.astyanax.query.PreparedIndexExpression;
import com.netflix.astyanax.serializers.ByteBufferSerializer;

public class ColumnFamily<K, C> {
    private final String columnFamilyName;
    private final Serializer<K> keySerializer;
    private final Serializer<C> columnSerializer;
    private final Serializer<?> defaultValueSerializer;
    private final ColumnType type;

    public ColumnFamily(String columnFamilyName, Serializer<K> keySerializer, Serializer<C> columnSerializer, ColumnType type) {
        this.columnFamilyName = columnFamilyName;
        this.keySerializer = keySerializer;
        this.columnSerializer = columnSerializer;
        this.defaultValueSerializer = ByteBufferSerializer.get();
        this.type = type;
    }

    public ColumnFamily(String columnFamilyName, Serializer<K> keySerializer, Serializer<C> columnSerializer) {
        this(columnFamilyName, keySerializer, columnSerializer, ByteBufferSerializer.get());
    }

    public ColumnFamily(String columnFamilyName, Serializer<K> keySerializer, Serializer<C> columnSerializer, Serializer<?> defaultValueSerializer) {
        this.columnFamilyName = columnFamilyName;
        this.keySerializer = keySerializer;
        this.columnSerializer = columnSerializer;
        this.defaultValueSerializer = defaultValueSerializer;
        this.type = ColumnType.STANDARD;
    }

    public String getName() {
        return this.columnFamilyName;
    }

    public Serializer<C> getColumnSerializer() {
        return this.columnSerializer;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<?> getDefaultValueSerializer() {
        return this.defaultValueSerializer;
    }

    public ColumnType getType() {
        return this.type;
    }

    public PreparedIndexExpression<K, C> newIndexClause() {
        return new PreparedIndexExpressionImpl(this.columnSerializer);
    }

    public static <K, C> ColumnFamily<K, C> newColumnFamily(String columnFamilyName, Serializer<K> keySerializer, Serializer<C> columnSerializer) {
        return new ColumnFamily<K, C>(columnFamilyName, keySerializer, columnSerializer);
    }

    public static <K, C> ColumnFamily<K, C> newColumnFamily(String columnFamilyName, Serializer<K> keySerializer, Serializer<C> columnSerializer, Serializer<?> defaultSerializer) {
        return new ColumnFamily<K, C>(columnFamilyName, keySerializer, columnSerializer, defaultSerializer);
    }
}

