/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.impl;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.query.IndexOperator;
import com.netflix.astyanax.query.PreparedIndexExpression;
import com.netflix.astyanax.query.PreparedIndexOperationExpression;
import com.netflix.astyanax.query.PreparedIndexValueExpression;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.BytesArraySerializer;
import com.netflix.astyanax.serializers.DateSerializer;
import com.netflix.astyanax.serializers.DoubleSerializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;

public class PreparedIndexExpressionImpl<K, C>
implements PreparedIndexExpression<K, C>,
PreparedIndexOperationExpression<K, C>,
PreparedIndexValueExpression<K, C> {
    private ByteBuffer value;
    private ByteBuffer column;
    private IndexOperator operator;
    private final Serializer<C> columnSerializer;

    public PreparedIndexExpressionImpl(Serializer<C> columnSerializer) {
        this.columnSerializer = columnSerializer;
    }

    @Override
    public PreparedIndexOperationExpression<K, C> whereColumn(C columnName) {
        this.column = this.columnSerializer.toByteBuffer(columnName);
        return this;
    }

    @Override
    public ByteBuffer getColumn() {
        return this.column;
    }

    @Override
    public ByteBuffer getValue() {
        return this.value;
    }

    @Override
    public IndexOperator getOperator() {
        return this.operator;
    }

    @Override
    public PreparedIndexValueExpression<K, C> equals() {
        this.operator = IndexOperator.EQ;
        return this;
    }

    @Override
    public PreparedIndexValueExpression<K, C> greaterThan() {
        this.operator = IndexOperator.GT;
        return this;
    }

    @Override
    public PreparedIndexValueExpression<K, C> lessThan() {
        this.operator = IndexOperator.LT;
        return this;
    }

    @Override
    public PreparedIndexValueExpression<K, C> greaterThanEquals() {
        this.operator = IndexOperator.GTE;
        return this;
    }

    @Override
    public PreparedIndexValueExpression<K, C> lessThanEquals() {
        this.operator = IndexOperator.LTE;
        return this;
    }

    @Override
    public PreparedIndexExpression<K, C> value(String value) {
        this.value = StringSerializer.get().toByteBuffer(value);
        return this;
    }

    @Override
    public PreparedIndexExpression<K, C> value(long value) {
        this.value = LongSerializer.get().toByteBuffer(value);
        return this;
    }

    @Override
    public PreparedIndexExpression<K, C> value(int value) {
        this.value = IntegerSerializer.get().toByteBuffer(value);
        return this;
    }

    @Override
    public PreparedIndexExpression<K, C> value(boolean value) {
        this.value = BooleanSerializer.get().toByteBuffer(value);
        return this;
    }

    @Override
    public PreparedIndexExpression<K, C> value(Date value) {
        this.value = DateSerializer.get().toByteBuffer(value);
        return this;
    }

    @Override
    public PreparedIndexExpression<K, C> value(byte[] value) {
        this.value = BytesArraySerializer.get().toByteBuffer(value);
        return this;
    }

    @Override
    public PreparedIndexExpression<K, C> value(ByteBuffer value) {
        this.value = ByteBufferSerializer.get().toByteBuffer(value);
        return this;
    }

    @Override
    public PreparedIndexExpression<K, C> value(double value) {
        this.value = DoubleSerializer.get().toByteBuffer(value);
        return this;
    }

    @Override
    public PreparedIndexExpression<K, C> value(UUID value) {
        this.value = UUIDSerializer.get().toByteBuffer(value);
        return this;
    }

    @Override
    public <V> PreparedIndexExpression<K, C> value(V value, Serializer<V> valueSerializer) {
        this.value = valueSerializer.toByteBuffer(value);
        return this;
    }
}

