/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.serializers.SerializerTypeInferer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.Entity;
import org.apache.commons.lang.StringUtils;

public class MappingUtils {
    static Serializer<?> getSerializerForField(Field field) {
        Serializer serializer = null;
        com.netflix.astyanax.entitystore.Serializer serializerAnnotation = field.getAnnotation(com.netflix.astyanax.entitystore.Serializer.class);
        if (serializerAnnotation != null) {
            Class<?> serializerClazz = serializerAnnotation.value();
            if (!Serializer.class.isAssignableFrom(serializerClazz)) {
                throw new RuntimeException("annotated serializer class is not a subclass of com.netflix.astyanax.Serializer");
            }
            try {
                Method getInstanceMethod = serializerClazz.getMethod("get", new Class[0]);
                serializer = (Serializer)getInstanceMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get or invoke public static get() method", e);
            }
        } else {
            serializer = SerializerTypeInferer.getSerializer(field.getType());
        }
        return serializer;
    }

    static String getEntityName(Entity entityAnnotation, Class<?> clazz) {
        String name = entityAnnotation.name();
        if (name == null || name.isEmpty()) {
            return StringUtils.substringAfterLast((String)clazz.getName(), (String)".").toLowerCase();
        }
        return null;
    }
}

