/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.netflix.astyanax.connectionpool.ConnectionFactory;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.ExecuteWithFailover;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NoAvailableHostsException;
import com.netflix.astyanax.connectionpool.impl.AbstractHostPartitionConnectionPool;
import com.netflix.astyanax.connectionpool.impl.RoundRobinExecuteWithFailover;
import com.netflix.astyanax.connectionpool.impl.TokenHostConnectionPoolPartition;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class TokenAwareConnectionPoolImpl<CL>
extends AbstractHostPartitionConnectionPool<CL> {
    private AtomicInteger roundRobinCounter = new AtomicInteger(new Random().nextInt(997));
    private static final int MAX_RR_COUNTER = 0x3FFFFFFF;

    public TokenAwareConnectionPoolImpl(ConnectionPoolConfiguration configuration, ConnectionFactory<CL> factory, ConnectionPoolMonitor monitor) {
        super(configuration, factory, monitor);
    }

    @Override
    public <R> ExecuteWithFailover<CL, R> newExecuteWithFailover(Operation<CL, R> op) throws ConnectionException {
        try {
            List pools;
            boolean isSorted = false;
            if (op.getPinnedHost() != null) {
                HostConnectionPool pool = (HostConnectionPool)this.hosts.get((Object)op.getPinnedHost());
                if (pool == null) {
                    throw new NoAvailableHostsException("Host " + op.getPinnedHost() + " not active");
                }
                pools = Arrays.asList(pool);
            } else {
                TokenHostConnectionPoolPartition partition = this.topology.getPartition(op.getRowKey());
                pools = partition.getPools();
                isSorted = partition.isSorted();
            }
            int index = this.roundRobinCounter.incrementAndGet();
            if (index > 0x3FFFFFFF) {
                this.roundRobinCounter.set(0);
            }
            return new RoundRobinExecuteWithFailover(this.config, this.monitor, pools, isSorted ? 0 : index);
        }
        catch (ConnectionException e) {
            this.monitor.incOperationFailure(e.getHost(), e);
            throw e;
        }
    }
}

