/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.cassandra.utils.AbstractStatsDeque;

class AdaptiveLatencyTracker
extends AbstractStatsDeque {
    private final LinkedBlockingDeque<Double> latencies;

    AdaptiveLatencyTracker(int size) {
        this.latencies = new LinkedBlockingDeque(size);
    }

    @Override
    public void add(double i) {
        if (!this.latencies.offer(i)) {
            try {
                this.latencies.remove();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.latencies.offer(i);
        }
    }

    @Override
    public void clear() {
        this.latencies.clear();
    }

    @Override
    public Iterator<Double> iterator() {
        return this.latencies.iterator();
    }

    @Override
    public int size() {
        return this.latencies.size();
    }

    double score() {
        return this.size() > 0 ? this.mean() : 0.0;
    }
}

