/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.VersionGenerator;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.FBUtilities;

public class VersionedValue
implements Comparable<VersionedValue> {
    public static final IVersionedSerializer<VersionedValue> serializer = new VersionedValueSerializer();
    public static final char DELIMITER = ',';
    public static final String DELIMITER_STR = new String(new char[]{','});
    public static final String STATUS_BOOTSTRAPPING = "BOOT";
    public static final String STATUS_NORMAL = "NORMAL";
    public static final String STATUS_LEAVING = "LEAVING";
    public static final String STATUS_LEFT = "LEFT";
    public static final String STATUS_MOVING = "MOVING";
    public static final String REMOVING_TOKEN = "removing";
    public static final String REMOVED_TOKEN = "removed";
    public static final String HIBERNATE = "hibernate";
    public static final String REMOVAL_COORDINATOR = "REMOVER";
    public final int version;
    public final String value;

    private VersionedValue(String value, int version) {
        assert (value != null);
        this.value = value;
        this.version = version;
    }

    private VersionedValue(String value) {
        this(value, VersionGenerator.getNextVersion());
    }

    @Override
    public int compareTo(VersionedValue value) {
        return this.version - value.version;
    }

    public String toString() {
        return "Value(" + this.value + "," + this.version + ")";
    }

    private static class VersionedValueSerializer
    implements IVersionedSerializer<VersionedValue> {
        private VersionedValueSerializer() {
        }

        @Override
        public void serialize(VersionedValue value, DataOutput dos, int version) throws IOException {
            dos.writeUTF(value.value);
            dos.writeInt(value.version);
        }

        @Override
        public VersionedValue deserialize(DataInput dis, int version) throws IOException {
            String value = dis.readUTF();
            int valVersion = dis.readInt();
            return new VersionedValue(value, valVersion);
        }

        @Override
        public long serializedSize(VersionedValue value, int version) {
            throw new UnsupportedOperationException();
        }
    }

    public static class VersionedValueFactory {
        IPartitioner partitioner;

        public VersionedValueFactory(IPartitioner partitioner) {
            this.partitioner = partitioner;
        }

        public VersionedValue bootstrapping(Token token) {
            return new VersionedValue("BOOT," + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue normal(Token token) {
            return new VersionedValue("NORMAL," + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue load(double load) {
            return new VersionedValue(String.valueOf(load));
        }

        public VersionedValue migration(UUID newVersion) {
            return new VersionedValue(newVersion.toString());
        }

        public VersionedValue leaving(Token token) {
            return new VersionedValue("LEAVING," + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue left(Token token, long expireTime) {
            return new VersionedValue("LEFT," + this.partitioner.getTokenFactory().toString(token) + ',' + expireTime);
        }

        public VersionedValue moving(Token token) {
            return new VersionedValue("MOVING," + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue removingNonlocal(Token token) {
            return new VersionedValue("removing," + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue removedNonlocal(Token token, long expireTime) {
            return new VersionedValue("removed," + this.partitioner.getTokenFactory().toString(token) + ',' + expireTime);
        }

        public VersionedValue removalCoordinator(Token token) {
            return new VersionedValue("REMOVER," + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue hibernate(boolean value) {
            return new VersionedValue("hibernate," + value);
        }

        public VersionedValue datacenter(String dcId) {
            return new VersionedValue(dcId);
        }

        public VersionedValue rack(String rackId) {
            return new VersionedValue(rackId);
        }

        public VersionedValue rpcaddress(InetAddress endpoint) {
            return new VersionedValue(endpoint.getHostAddress());
        }

        public VersionedValue releaseVersion() {
            return new VersionedValue(FBUtilities.getReleaseVersionString());
        }

        public VersionedValue internalIP(String private_ip) {
            return new VersionedValue(private_ip);
        }
    }
}

