/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.utils.BoundedStatsDeque;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrivalWindow {
    private static Logger logger_ = LoggerFactory.getLogger(ArrivalWindow.class);
    private double tLast_ = 0.0;
    private BoundedStatsDeque arrivalIntervals_;
    private final double PHI_FACTOR = 1.0 / Math.log(10.0);
    private final double MAX_INTERVAL_IN_MS = DatabaseDescriptor.getRpcTimeout();

    ArrivalWindow(int size) {
        this.arrivalIntervals_ = new BoundedStatsDeque(size);
    }

    synchronized void add(double value) {
        double interArrivalTime = this.tLast_ > 0.0 ? value - this.tLast_ : 500.0;
        if (interArrivalTime <= this.MAX_INTERVAL_IN_MS) {
            this.arrivalIntervals_.add(interArrivalTime);
        } else {
            logger_.debug("Ignoring interval time of {}", (Object)interArrivalTime);
        }
        this.tLast_ = value;
    }

    synchronized double sum() {
        return this.arrivalIntervals_.sum();
    }

    synchronized double sumOfDeviations() {
        return this.arrivalIntervals_.sumOfDeviations();
    }

    synchronized double mean() {
        return this.arrivalIntervals_.mean();
    }

    synchronized double variance() {
        return this.arrivalIntervals_.variance();
    }

    double stdev() {
        return this.arrivalIntervals_.stdev();
    }

    void clear() {
        this.arrivalIntervals_.clear();
    }

    synchronized double phi(long tnow) {
        int size = this.arrivalIntervals_.size();
        double t = (double)tnow - this.tLast_;
        return size > 0 ? this.PHI_FACTOR * t / this.mean() : 0.0;
    }

    public String toString() {
        return StringUtils.join(this.arrivalIntervals_.iterator(), (String)" ");
    }
}

