/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.HeapAllocator;

public class ExpiringColumn
extends Column {
    private final int localExpirationTime;
    private final int timeToLive;

    public ExpiringColumn(ByteBuffer name, ByteBuffer value, long timestamp, int timeToLive) {
        this(name, value, timestamp, timeToLive, (int)(System.currentTimeMillis() / 1000L) + timeToLive);
    }

    public ExpiringColumn(ByteBuffer name, ByteBuffer value, long timestamp, int timeToLive, int localExpirationTime) {
        super(name, value, timestamp);
        assert (timeToLive > 0) : timeToLive;
        assert (localExpirationTime > 0) : localExpirationTime;
        this.timeToLive = timeToLive;
        this.localExpirationTime = localExpirationTime;
    }

    public static Column create(ByteBuffer name, ByteBuffer value, long timestamp, int timeToLive, int localExpirationTime, int expireBefore, IColumnSerializer.Flag flag) {
        if (localExpirationTime >= expireBefore || flag == IColumnSerializer.Flag.PRESERVE_SIZE) {
            return new ExpiringColumn(name, value, timestamp, timeToLive, localExpirationTime);
        }
        return new DeletedColumn(name, localExpirationTime, timestamp);
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public int size() {
        return super.size() + 4 + 4;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name.duplicate());
        digest.update(this.value.duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.timestamp);
            buffer.writeByte(this.serializationFlags());
            buffer.writeInt(this.timeToLive);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public int getLocalDeletionTime() {
        return this.localExpirationTime;
    }

    @Override
    public IColumn localCopy(ColumnFamilyStore cfs) {
        return new ExpiringColumn(cfs.internOrCopy(this.name, HeapAllocator.instance), ByteBufferUtil.clone(this.value), this.timestamp, this.timeToLive, this.localExpirationTime);
    }

    @Override
    public IColumn localCopy(ColumnFamilyStore cfs, Allocator allocator) {
        ByteBuffer clonedName = cfs.maybeIntern(this.name);
        if (clonedName == null) {
            clonedName = allocator.clone(this.name);
        }
        return new ExpiringColumn(clonedName, allocator.clone(this.value), this.timestamp, this.timeToLive, this.localExpirationTime);
    }

    @Override
    public String getString(AbstractType<?> comparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getString(comparator));
        sb.append("!");
        sb.append(this.timeToLive);
        return sb.toString();
    }

    @Override
    public long getMarkedForDeleteAt() {
        if (this.isMarkedForDelete()) {
            return this.timestamp;
        }
        throw new IllegalStateException("column is not marked for delete");
    }

    @Override
    public int serializationFlags() {
        return 2;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        super.validateFields(metadata);
        if (this.timeToLive <= 0) {
            throw new MarshalException("A column TTL should be > 0");
        }
        if (this.localExpirationTime < 0) {
            throw new MarshalException("The local expiration time should not be negative");
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.localExpirationTime == ((ExpiringColumn)o).localExpirationTime && this.timeToLive == ((ExpiringColumn)o).timeToLive;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.localExpirationTime;
        result = 31 * result + this.timeToLive;
        return result;
    }
}

