/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.utils.ByteBufferUtil;

public class UpdateStatement
extends ModificationStatement {
    private CFDefinition cfDef;
    private final Map<ColumnIdentifier, Operation> columns;
    private final List<ColumnIdentifier> columnNames;
    private final List<Term> columnValues;
    private final List<Relation> whereClause;
    private final Map<ColumnIdentifier, Operation> processedColumns = new HashMap<ColumnIdentifier, Operation>();
    private final Map<ColumnIdentifier, List<Term>> processedKeys = new HashMap<ColumnIdentifier, List<Term>>();

    public UpdateStatement(CFName name, Map<ColumnIdentifier, Operation> columns, List<Relation> whereClause, Attributes attrs) {
        super(name, attrs);
        this.columns = columns;
        this.whereClause = whereClause;
        this.columnNames = null;
        this.columnValues = null;
    }

    public UpdateStatement(CFName name, List<ColumnIdentifier> columnNames, List<Term> columnValues, Attributes attrs) {
        super(name, attrs);
        this.columnNames = columnNames;
        this.columnValues = columnValues;
        this.whereClause = null;
        this.columns = null;
    }

    @Override
    public List<IMutation> getMutations(ClientState clientState, List<ByteBuffer> variables) throws InvalidRequestException {
        List<Term> keys = this.processedKeys.get(this.cfDef.key.name);
        if (keys == null || keys.isEmpty()) {
            throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", this.cfDef.key));
        }
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        CFDefinition.Name firstEmpty = null;
        for (CFDefinition.Name name : this.cfDef.columns.values()) {
            List<Term> values = this.processedKeys.get(name.name);
            if (values == null || values.isEmpty()) {
                firstEmpty = name;
                if (!this.cfDef.isComposite || this.cfDef.isCompact) continue;
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", name));
            }
            if (firstEmpty != null) {
                throw new InvalidRequestException(String.format("Missing PRIMARY KEY part %s since %s is set", firstEmpty.name, name.name));
            }
            assert (values.size() == 1);
            builder.add(values.get(0), Relation.Type.EQ, variables);
        }
        LinkedList<IMutation> rowMutations = new LinkedList<IMutation>();
        for (Term key : keys) {
            ByteBuffer rawKey = key.getByteBuffer(this.cfDef.key.type, variables);
            rowMutations.add(this.mutationForKey(this.cfDef, clientState, rawKey, builder, variables));
        }
        return rowMutations;
    }

    private IMutation mutationForKey(CFDefinition cfDef, ClientState clientState, ByteBuffer key, ColumnNameBuilder builder, List<ByteBuffer> variables) throws InvalidRequestException {
        org.apache.cassandra.cql.QueryProcessor.validateKey(key);
        boolean hasCounterColumn = false;
        QueryProcessor.validateKey(key);
        RowMutation rm = new RowMutation(cfDef.cfm.ksName, key);
        ColumnFamily cf = rm.addOrGet(cfDef.cfm.cfName);
        if (cfDef.isCompact) {
            if (builder.componentCount() == 0) {
                throw new InvalidRequestException(String.format("Missing PRIMARY KEY part %s", cfDef.columns.values().iterator().next()));
            }
            Operation value = this.processedColumns.get(cfDef.value.name);
            if (value == null) {
                throw new InvalidRequestException(String.format("Missing mandatory column %s", cfDef.value));
            }
            hasCounterColumn = this.addToMutation(clientState, cf, builder.build(), cfDef.value, value, variables);
        } else {
            for (CFDefinition.Name name : cfDef.metadata.values()) {
                Operation value = this.processedColumns.get(name.name);
                if (value == null) continue;
                ByteBuffer colName = builder.copy().add(name.name.key).build();
                hasCounterColumn |= this.addToMutation(clientState, cf, colName, name, value, variables);
            }
        }
        return hasCounterColumn ? new CounterMutation(rm, this.getConsistencyLevel()) : rm;
    }

    private boolean addToMutation(ClientState clientState, ColumnFamily cf, ByteBuffer colName, CFDefinition.Name valueDef, Operation value, List<ByteBuffer> variables) throws InvalidRequestException {
        long val;
        if (value.isUnary()) {
            org.apache.cassandra.cql.QueryProcessor.validateColumnName(colName);
            ByteBuffer valueBytes = value.value.getByteBuffer(valueDef.type, variables);
            Column c = this.timeToLive > 0 ? new ExpiringColumn(colName, valueBytes, this.getTimestamp(clientState), this.timeToLive) : new Column(colName, valueBytes, this.getTimestamp(clientState));
            cf.addColumn(c);
            return false;
        }
        if (!valueDef.name.equals(value.ident)) {
            throw new InvalidRequestException("Only expressions like X = X + <long> are supported.");
        }
        try {
            val = ByteBufferUtil.toLong(value.value.getByteBuffer(LongType.instance, variables));
        }
        catch (NumberFormatException e) {
            throw new InvalidRequestException(String.format("'%s' is an invalid value, should be a long.", value.value.getText()));
        }
        if (value.type == Operation.Type.MINUS) {
            if (val == Long.MIN_VALUE) {
                throw new InvalidRequestException("The negation of " + val + " overflows supported integer precision (signed 8 bytes integer)");
            }
            val = -val;
        }
        cf.addCounter(new QueryPath(this.columnFamily(), null, colName), val);
        return true;
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        boolean hasCommutativeOperation = false;
        AbstractType[] types = new AbstractType[this.getBoundsTerms()];
        if (this.columns != null) {
            for (Map.Entry<ColumnIdentifier, Operation> column : this.columns.entrySet()) {
                if (!column.getValue().isUnary()) {
                    hasCommutativeOperation = true;
                }
                if (!hasCommutativeOperation || !column.getValue().isUnary()) continue;
                throw new InvalidRequestException("Mix of commutative and non-commutative operations is not allowed.");
            }
        }
        CFMetaData metadata = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily(), hasCommutativeOperation);
        if (hasCommutativeOperation) {
            ThriftValidation.validateCommutativeForWrite(metadata, this.cLevel);
        }
        this.cfDef = metadata.getCfDef();
        if (this.columns == null) {
            if (this.columnNames.size() != this.columnValues.size()) {
                throw new InvalidRequestException("unmatched column names/values");
            }
            if (this.columnNames.size() < 1) {
                throw new InvalidRequestException("no columns specified for INSERT");
            }
            block9: for (int i = 0; i < this.columnNames.size(); ++i) {
                CFDefinition.Name name = this.cfDef.get(this.columnNames.get(i));
                if (name == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", this.columnNames.get(i)));
                }
                Term value = this.columnValues.get(i);
                if (value.isBindMarker()) {
                    types[value.bindIndex] = name.type;
                }
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        if (this.processedKeys.containsKey(name.name)) {
                            throw new InvalidRequestException(String.format("Multiple definition found for PRIMARY KEY part %s", name));
                        }
                        this.processedKeys.put(name.name, Collections.singletonList(value));
                        continue block9;
                    }
                    case VALUE_ALIAS: 
                    case COLUMN_METADATA: {
                        if (this.processedColumns.containsKey(name.name)) {
                            throw new InvalidRequestException(String.format("Multiple definition found for column %s", name));
                        }
                        this.processedColumns.put(name.name, new Operation(value));
                    }
                }
            }
        } else {
            for (Map.Entry<ColumnIdentifier, Operation> entry : this.columns.entrySet()) {
                CFDefinition.Name name = this.cfDef.get(entry.getKey());
                if (name == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", entry.getKey()));
                }
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s found in SET part", entry.getKey()));
                    }
                    case VALUE_ALIAS: 
                    case COLUMN_METADATA: {
                        if (this.processedColumns.containsKey(name.name)) {
                            throw new InvalidRequestException(String.format("Multiple definition found for column %s", name));
                        }
                        Operation op = entry.getValue();
                        if (op.value.isBindMarker()) {
                            types[op.value.bindIndex] = name.type;
                        }
                        this.processedColumns.put(name.name, op);
                    }
                }
            }
            UpdateStatement.processKeys(this.cfDef, this.whereClause, this.processedKeys, types);
        }
        return new ParsedStatement.Prepared(this, Arrays.asList(types));
    }

    static void processKeys(CFDefinition cfDef, List<Relation> keys, Map<ColumnIdentifier, List<Term>> processed, AbstractType[] types) throws InvalidRequestException {
        for (Relation rel : keys) {
            CFDefinition.Name name = cfDef.get(rel.getEntity());
            if (name == null) {
                throw new InvalidRequestException(String.format("Unknown key identifier %s", rel.getEntity()));
            }
            switch (name.kind) {
                case KEY_ALIAS: 
                case COLUMN_ALIAS: {
                    List<Term> values;
                    if (rel.operator() == Relation.Type.EQ) {
                        values = Collections.singletonList(rel.getValue());
                    } else if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS && rel.operator() == Relation.Type.IN) {
                        values = rel.getInValues();
                    } else {
                        throw new InvalidRequestException(String.format("Invalid operator %s for key %s", new Object[]{rel.operator(), rel.getEntity()}));
                    }
                    if (processed.containsKey(name.name)) {
                        throw new InvalidRequestException(String.format("Multiple definition found for PRIMARY KEY part %s", name));
                    }
                    for (Term value : values) {
                        if (!value.isBindMarker()) continue;
                        types[value.bindIndex] = name.type;
                    }
                    processed.put(name.name, values);
                    break;
                }
                case VALUE_ALIAS: 
                case COLUMN_METADATA: {
                    throw new InvalidRequestException(String.format("PRIMARY KEY part %s found in SET part", rel.getEntity()));
                }
            }
        }
    }

    public String toString() {
        return String.format("UpdateStatement(name=%s, keys=%s, columns=%s, consistency=%s, timestamp=%s, timeToLive=%s)", this.cfName, this.whereClause, this.columns, this.getConsistencyLevel(), this.timestamp, this.timeToLive);
    }
}

