/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.io.compress.SnappyCompressor;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFPropDefs {
    private static Logger logger = LoggerFactory.getLogger(CFPropDefs.class);
    public static final String KW_COMMENT = "comment";
    public static final String KW_READREPAIRCHANCE = "read_repair_chance";
    public static final String KW_DCLOCALREADREPAIRCHANCE = "dclocal_read_repair_chance";
    public static final String KW_GCGRACESECONDS = "gc_grace_seconds";
    public static final String KW_MINCOMPACTIONTHRESHOLD = "min_compaction_threshold";
    public static final String KW_MAXCOMPACTIONTHRESHOLD = "max_compaction_threshold";
    public static final String KW_REPLICATEONWRITE = "replicate_on_write";
    public static final String KW_COMPACTION_STRATEGY_CLASS = "compaction_strategy_class";
    public static final String KW_CACHING = "caching";
    public static final String KW_BF_FP_CHANCE = "bloom_filter_fp_chance";
    public static final Map<String, String> comparators = new HashMap<String, String>();
    public static final Set<String> keywords = new HashSet<String>();
    public static final Set<String> obsoleteKeywords = new HashSet<String>();
    public static final Set<String> allowedKeywords = new HashSet<String>();
    public static final String COMPACTION_OPTIONS_PREFIX = "compaction_strategy_options";
    public static final String COMPRESSION_PARAMETERS_PREFIX = "compression_parameters";
    public final Map<String, String> properties = new HashMap<String, String>();
    public final Map<String, String> compactionStrategyOptions = new HashMap<String, String>();
    public final Map<String, String> compressionParameters = new HashMap<String, String>(){
        {
            this.put("sstable_compression", SnappyCompressor.class.getCanonicalName());
        }
    };

    public static AbstractType<?> parseType(String type) throws InvalidRequestException {
        try {
            String className = comparators.get(type);
            if (className == null) {
                className = type;
            }
            return TypeParser.parse(className);
        }
        catch (ConfigurationException e) {
            InvalidRequestException ex = new InvalidRequestException(e.toString());
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public void validate() throws InvalidRequestException {
        Iterator i$ = Sets.difference(this.properties.keySet(), allowedKeywords).iterator();
        if (i$.hasNext()) {
            String bogus = (String)i$.next();
            throw new InvalidRequestException(bogus + " is not a valid keyword argument for CREATE COLUMNFAMILY");
        }
        for (String obsolete : Sets.intersection(this.properties.keySet(), obsoleteKeywords)) {
            logger.warn("Ignoring obsolete property {}", (Object)obsolete);
        }
        Integer minCompaction = this.getInt(KW_MINCOMPACTIONTHRESHOLD, null);
        Integer maxCompaction = this.getInt(KW_MAXCOMPACTIONTHRESHOLD, null);
        if (minCompaction != null && maxCompaction != null) {
            if (minCompaction > maxCompaction && maxCompaction != 0) {
                throw new InvalidRequestException(String.format("%s cannot be larger than %s", KW_MINCOMPACTIONTHRESHOLD, KW_MAXCOMPACTIONTHRESHOLD));
            }
        } else if (minCompaction != null) {
            if (minCompaction > 32) {
                throw new InvalidRequestException(String.format("%s cannot be larger than %s, (default %s)", KW_MINCOMPACTIONTHRESHOLD, KW_MAXCOMPACTIONTHRESHOLD, 32));
            }
        } else if (maxCompaction != null && maxCompaction < 4 && maxCompaction != 0) {
            throw new InvalidRequestException(String.format("%s cannot be smaller than %s, (default %s)", KW_MAXCOMPACTIONTHRESHOLD, KW_MINCOMPACTIONTHRESHOLD, 4));
        }
    }

    public void addProperty(String name, String value) {
        String[] composite = name.split(":");
        if (composite.length > 1) {
            if (composite[0].equals(COMPACTION_OPTIONS_PREFIX)) {
                this.compactionStrategyOptions.put(composite[1], value);
                return;
            }
            if (composite[0].equals(COMPRESSION_PARAMETERS_PREFIX)) {
                this.compressionParameters.put(composite[1], value);
                return;
            }
        }
        this.properties.put(name, value);
    }

    public void addAll(Map<String, String> propertyMap) {
        for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
            this.addProperty(entry.getKey(), entry.getValue());
        }
    }

    public Boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public String get(String name) {
        return this.properties.get(name);
    }

    public String getString(String key, String defaultValue) {
        String value = this.properties.get(key);
        return value != null ? value : defaultValue;
    }

    public Boolean getBoolean(String key, Boolean defaultValue) throws InvalidRequestException {
        String value = this.properties.get(key);
        return value == null ? defaultValue.booleanValue() : value.toLowerCase().matches("(1|true|yes)");
    }

    public Double getDouble(String key, Double defaultValue) throws InvalidRequestException {
        Double result;
        String value = this.properties.get(key);
        if (value == null) {
            result = defaultValue;
        } else {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidRequestException(String.format("%s not valid for \"%s\"", value, key));
            }
        }
        return result;
    }

    public Integer getInt(String key, Integer defaultValue) throws InvalidRequestException {
        Integer result;
        String value = this.properties.get(key);
        if (value == null) {
            result = defaultValue;
        } else {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidRequestException(String.format("%s not valid for \"%s\"", value, key));
            }
        }
        return result;
    }

    public String toString() {
        return String.format("CFPropDefs(%s, compaction: %s, compression: %s)", this.properties.toString(), this.compactionStrategyOptions.toString(), this.compressionParameters.toString());
    }

    static {
        comparators.put("ascii", "AsciiType");
        comparators.put("bigint", "LongType");
        comparators.put("blob", "BytesType");
        comparators.put("boolean", "BooleanType");
        comparators.put("counter", "CounterColumnType");
        comparators.put("decimal", "DecimalType");
        comparators.put("double", "DoubleType");
        comparators.put("float", "FloatType");
        comparators.put("int", "Int32Type");
        comparators.put("text", "UTF8Type");
        comparators.put("timestamp", "DateType");
        comparators.put("uuid", "UUIDType");
        comparators.put("varchar", "UTF8Type");
        comparators.put("varint", "IntegerType");
        keywords.add(KW_COMMENT);
        keywords.add(KW_READREPAIRCHANCE);
        keywords.add(KW_DCLOCALREADREPAIRCHANCE);
        keywords.add(KW_GCGRACESECONDS);
        keywords.add(KW_MINCOMPACTIONTHRESHOLD);
        keywords.add(KW_MAXCOMPACTIONTHRESHOLD);
        keywords.add(KW_REPLICATEONWRITE);
        keywords.add(KW_COMPACTION_STRATEGY_CLASS);
        keywords.add(KW_CACHING);
        keywords.add(KW_BF_FP_CHANCE);
        allowedKeywords.addAll(keywords);
        allowedKeywords.addAll(obsoleteKeywords);
    }
}

