/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.thrift.InvalidRequestException;

public class CreateKeyspaceStatement {
    private final String name;
    private final Map<String, String> attrs;
    private String strategyClass;
    private Map<String, String> strategyOptions = new HashMap<String, String>();

    public CreateKeyspaceStatement(String name, Map<String, String> attrs) {
        this.name = name;
        this.attrs = attrs;
    }

    public void validate() throws InvalidRequestException {
        if (!this.attrs.containsKey("strategy_class")) {
            throw new InvalidRequestException("missing required argument \"strategy_class\"");
        }
        this.strategyClass = this.attrs.get("strategy_class");
        for (String key : this.attrs.keySet()) {
            if (!key.contains(":") || !key.startsWith("strategy_options")) continue;
            this.strategyOptions.put(key.split(":")[1], this.attrs.get(key));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getStrategyClass() {
        return this.strategyClass;
    }

    public Map<String, String> getStrategyOptions() {
        return this.strategyOptions;
    }
}

