/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.impl.ContextBean;

final class SymmetricKey {
    private static Key key;
    private static String keyAlgorithm;

    private SymmetricKey() {
    }

    protected static Key getKeyByFile(String context) throws InvalidKeyException {
        if (key == null) {
            SymmetricKey.load(SymmetricKey.getKeyFileName(context));
        }
        return key;
    }

    @Deprecated
    protected static Key getKey() throws InvalidKeyException {
        if (key == null) {
            SymmetricKey.load();
        }
        return key;
    }

    private static void load() throws InvalidKeyException {
        String token = SecurityTokenProvider.instance.get();
        try {
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            SymmetricKey.load(SymmetricKey.getKeyFileName(entry.getContext()));
        }
        catch (Exception e) {
            throw new InvalidKeyException("Unable to load the Key, token not valid", e);
        }
    }

    private static void load(String keyFileName) throws InvalidKeyException {
        byte[] rawKey;
        try {
            InputStream is = SymmetricKey.class.getResourceAsStream("/" + keyFileName);
            rawKey = SymmetricKey.getBytesFromStream(is);
        }
        catch (Exception e) {
            throw new InvalidKeyException("Unable to load the Key " + keyFileName + " from the classpath");
        }
        try {
            key = new SecretKeySpec(rawKey, 0, rawKey.length, keyAlgorithm);
        }
        catch (Exception e) {
            throw new InvalidKeyException(e);
        }
    }

    private static byte[] getBytesFromStream(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        byte[] rawKey = buffer.toByteArray();
        return rawKey;
    }

    protected static String getKeyFileName(String context) throws InvalidKeyException {
        ContextBean bean;
        String keyFile = null;
        if (context != null) {
            bean = new ContextBean(context);
            if (bean.is(ContextBean.Type.VRE)) {
                bean = bean.enclosingScope();
            }
        } else {
            throw new InvalidKeyException(" invalid key for context: " + context);
        }
        String name = bean.name();
        keyFile = name + ".gcubekey";
        return keyFile;
    }

    static {
        keyAlgorithm = "AES";
    }
}

