/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.encryption;

import java.security.Key;
import javax.crypto.Cipher;
import javax.xml.bind.DatatypeConverter;
import org.gcube.common.encryption.IEncrypter;
import org.gcube.common.encryption.SymmetricKey;

public class StringEncrypter
implements IEncrypter<String> {
    private static StringEncrypter singleton;

    StringEncrypter() {
    }

    public static StringEncrypter getEncrypter() {
        if (singleton == null) {
            singleton = new StringEncrypter();
        }
        return singleton;
    }

    @Override
    public String encrypt(String string, Key ... key) throws Exception {
        Key ekey = key != null && key.length > 0 ? key[0] : SymmetricKey.getKey();
        Cipher cipher = Cipher.getInstance(ekey.getAlgorithm());
        cipher.init(1, ekey);
        return new String(DatatypeConverter.printBase64Binary((byte[])cipher.doFinal(string.getBytes())));
    }

    public String encrypt(String string, String context) throws Exception {
        return this.encrypt(string, SymmetricKey.getKeyByFile(context));
    }

    @Override
    public String decrypt(String string, Key ... key) throws Exception {
        Key dkey = key != null && key.length > 0 ? key[0] : SymmetricKey.getKey();
        Cipher cipher = Cipher.getInstance(dkey.getAlgorithm());
        cipher.init(2, dkey);
        return new String(cipher.doFinal(DatatypeConverter.parseBase64Binary((String)string)));
    }

    public String decrypt(String string, String context) throws Exception {
        return this.decrypt(string, SymmetricKey.getKeyByFile(context));
    }
}

