/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.ax;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.MessageExtensionFactory;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.ax.StoreRequest;
import org.openid4java.message.ax.StoreResponse;

public class AxMessage
implements MessageExtension,
MessageExtensionFactory {
    private static Log _log = LogFactory.getLog(AxMessage.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final String OPENID_NS_AX = "http://openid.net/srv/ax/1.0";
    protected ParameterList _parameters;

    public AxMessage() {
        this._parameters = new ParameterList();
        if (DEBUG) {
            _log.debug((Object)"Created empty AXMessage.");
        }
    }

    public AxMessage(ParameterList params) {
        this._parameters = params;
        if (DEBUG) {
            _log.debug((Object)("Created AXMessage from parameter list:\n" + params));
        }
    }

    public String getTypeUri() {
        return OPENID_NS_AX;
    }

    public ParameterList getParameters() {
        return this._parameters;
    }

    public String getParameterValue(String name) {
        return this._parameters.getParameterValue(name);
    }

    public void setParameters(ParameterList params) {
        this._parameters = params;
    }

    public boolean providesIdentifier() {
        return false;
    }

    public boolean signRequired() {
        return true;
    }

    public MessageExtension getExtension(ParameterList parameterList, boolean isRequest) throws MessageException {
        String axMode = null;
        if (parameterList.hasParameter("mode")) {
            axMode = parameterList.getParameterValue("mode");
            if ("fetch_request".equals(axMode)) {
                return FetchRequest.createFetchRequest(parameterList);
            }
            if ("fetch_response".equals(axMode)) {
                return FetchResponse.createFetchResponse(parameterList);
            }
            if ("store_request".equals(axMode)) {
                return StoreRequest.createStoreRequest(parameterList);
            }
            if ("store_response_success".equals(axMode) || "store_response_failure".equals(axMode)) {
                return StoreResponse.createStoreResponse(parameterList);
            }
        }
        throw new MessageException("Invalid value for attribute exchange mode: " + axMode);
    }
}

