/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.bnd.ant.BaseTask;
import aQute.bnd.osgi.eclipse.EclipseClasspath;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseTask
extends BaseTask {
    private String prefix = "project.";
    private List<File> prebuild = new ArrayList<File>();
    private File workspaceLocation;
    private String separator = ",";
    private File projectLocation;

    public void execute() throws BuildException {
        try {
            if (this.projectLocation == null) {
                this.projectLocation = this.getProject().getBaseDir();
            }
            if (this.workspaceLocation == null) {
                this.workspaceLocation = this.projectLocation.getParentFile();
            }
            EclipseClasspath eclipse = new EclipseClasspath(this, this.workspaceLocation, this.projectLocation);
            if (this.report()) {
                throw new BuildException("Errors during Eclipse Path inspection");
            }
            this.addProperty(this.prefix + "classpath", this.join(eclipse.getClasspath(), this.separator));
            this.addProperty(this.prefix + "bootclasspath", this.join(eclipse.getBootclasspath(), this.separator));
            if (!eclipse.getSourcepath().isEmpty()) {
                this.addProperty(this.prefix + "sourcepath", this.join(eclipse.getSourcepath(), this.separator));
            }
            this.addProperty(this.prefix + "output", eclipse.getOutput().getAbsolutePath());
            ArrayList<File> dependents = new ArrayList<File>();
            this.addCareful(dependents, this.prebuild);
            this.addCareful(dependents, eclipse.getDependents());
            if (dependents.size() > 0) {
                this.addProperty(this.prefix + "buildpath", this.join(dependents, this.separator));
            }
        }
        catch (Exception e) {
            throw new BuildException("Error during parsing Eclipse .classpath files", (Throwable)e);
        }
    }

    private void addCareful(List<File> result, Collection<File> projects) {
        for (File d : projects) {
            if (result.contains(d)) continue;
            result.add(d);
        }
    }

    protected void addProperty(String n, String v) {
        if (v != null) {
            this.getProject().setProperty(n, v);
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setPrebuild(String prebuild) {
        StringTokenizer st = new StringTokenizer(prebuild, " ,");
        while (st.hasMoreTokens()) {
            this.prebuild.add(EclipseTask.getFile(this.getProject().getBaseDir().getParentFile(), st.nextToken()));
        }
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setProjectLocation(File projectLocation) {
        this.projectLocation = projectLocation;
    }

    public void setWorkspaceLocation(File workspaceLocation) {
        this.workspaceLocation = workspaceLocation;
    }
}

