/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.trash;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashFolder;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.trash.JCRWorkspaceTrashItem;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRWorkspaceTrashFolder
extends JCRWorkspaceFolder
implements WorkspaceTrashFolder {
    public JCRWorkspaceTrashFolder(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public JCRWorkspaceTrashFolder(JCRWorkspace workspace, ItemDelegate node, String name, String description) throws RepositoryException {
        super(workspace, node, name, description);
    }

    public WorkspaceTrashItem getTrashItemById(String id) throws InternalErrorException {
        JCRWorkspaceTrashItem trashItem;
        block8: {
            ItemDelegate trashNode = null;
            trashItem = null;
            JCRSession servlets = null;
            try {
                try {
                    servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
                    trashNode = servlets.getItemById(id);
                    if (!trashNode.getPrimaryType().equals("nthl:trashItem")) break block8;
                    try {
                        trashItem = new JCRWorkspaceTrashItem(this.workspace, trashNode);
                    }
                    catch (Exception e) {
                        throw new InternalErrorException("Trash not found " + e);
                    }
                }
                catch (RepositoryException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (ItemNotFoundException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            finally {
                servlets.releaseSession();
            }
        }
        return trashItem;
    }

    public List<WorkspaceTrashItem> listTrashItems() throws InternalErrorException, ItemNotFoundException {
        ItemDelegate node = null;
        ArrayList<WorkspaceTrashItem> children = null;
        JCRSession servlets = null;
        try {
            try {
                servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), true);
                children = new ArrayList<WorkspaceTrashItem>();
                node = servlets.getItemById(this.getId());
                DelegateManager wrap = new DelegateManager(node, this.workspace.getOwner().getPortalLogin());
                List<ItemDelegate> trashNodes = wrap.getNodes();
                for (ItemDelegate trashNode : trashNodes) {
                    if (!trashNode.getPrimaryType().equals("nthl:trashItem")) continue;
                    ItemDelegate nodeItem = servlets.getItemById(trashNode.getId());
                    WorkspaceTrashItem trashItem = (WorkspaceTrashItem)this.workspace.getWorkspaceItem(nodeItem);
                    children.add(trashItem);
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return children;
    }

    public List<String> emptyTrash() throws InternalErrorException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JCRWorkspaceTrashFolder.this.workspace.getStorage().removeRemoteFolder(((JCRWorkspaceTrashFolder)JCRWorkspaceTrashFolder.this).workspace.trashPath);
                }
                catch (RemoteBackendException e) {
                    logger.error("Error deleting folder " + ((JCRWorkspaceTrashFolder)JCRWorkspaceTrashFolder.this).workspace.trashPath + (Object)((Object)e));
                }
            }
        }).start();
        JCRSession servlets = null;
        try {
            try {
                servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
                servlets.removeItem(this.workspace.trashPath);
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return null;
    }

    public List<String> restoreAll() throws InternalErrorException {
        ItemDelegate trashNode = null;
        JCRSession servlets = null;
        ArrayList<String> fails = new ArrayList<String>();
        try {
            try {
                servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
                trashNode = servlets.getItemById(this.getId());
                DelegateManager wrap = new DelegateManager(trashNode, this.workspace.getOwner().getPortalLogin());
                List<ItemDelegate> children = wrap.getNodes();
                for (ItemDelegate child : children) {
                    if (!child.getPrimaryType().equals("nthl:trashItem")) continue;
                    JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(this.workspace, child);
                    try {
                        trashItem.restore();
                    }
                    catch (Exception e) {
                        fails.add(trashItem.getId());
                    }
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return fails;
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.TRASH_FOLDER;
    }

    public void restoreById(String id) throws InternalErrorException {
        ItemDelegate trashItemDelegate = null;
        JCRSession servlets = null;
        try {
            try {
                servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
                trashItemDelegate = servlets.getItemById(id);
                JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(this.workspace, trashItemDelegate);
                trashItem.restore();
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
    }

    public void deletePermanentlyById(String id) throws InternalErrorException {
        ItemDelegate trashItemDelegate = null;
        JCRSession servlets = null;
        try {
            try {
                servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
                trashItemDelegate = servlets.getItemById(id);
                JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(this.workspace, trashItemDelegate);
                trashItem.deletePermanently();
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
    }
}

