/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.stubs.test;

import java.io.FileReader;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.dir.master.stubs.ICollectionRank;
import org.gcube.dir.master.stubs.ICollectionRanking;
import org.gcube.dir.master.stubs.IDefaultQuery;
import org.gcube.dir.master.stubs.IDefaultQueryTerm;
import org.gcube.dir.master.stubs.IExtendedCollectionRank;
import org.gcube.dir.master.stubs.IQueryTerm;
import org.gcube.dir.master.stubs.IResultDistributionCriterion;
import org.gcube.dir.master.stubs.ISelectionParameters;
import org.gcube.dir.master.stubs.MasterCall;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.xml.sax.InputSource;

public class Select {
    static GCUBEClientLog logger = new GCUBEClientLog(Select.class, new Properties[0]);

    public static void main(String[] args) {
        try {
            Select.run(args);
        }
        catch (Exception e) {
            logger.debug((Object)e.getClass().getSimpleName(), (Throwable)e);
        }
    }

    public static void run(String[] args) throws Exception {
        if (args.length != 3) {
            logger.debug((Object)"SPECIFY: 1) MANAGER ENDPOINT (FILENAME) 2) QUERY KEYWORDS (COMMA SEPARATED), 3) CALL SCOPE");
            return;
        }
        FileReader reader = new FileReader(args[0]);
        EndpointReferenceType epr = (EndpointReferenceType)ObjectDeserializer.deserialize((InputSource)new InputSource(reader), EndpointReferenceType.class);
        ArrayList<IDefaultQueryTerm> terms = new ArrayList<IDefaultQueryTerm>();
        for (String term : args[1].split(",")) {
            IDefaultQueryTerm iterm = new IDefaultQueryTerm();
            iterm.setName(term);
            iterm.setWeight(1.0f);
            terms.add(iterm);
        }
        ISelectionParameters params = new ISelectionParameters();
        params.setCriterion(new IResultDistributionCriterion(100));
        params.setQuery(new IDefaultQuery(terms.toArray(new IQueryTerm[0])));
        MasterCall call = new MasterCall(GCUBEScope.getScope((String)args[2]), new GCUBESecurityManager[0]);
        call.setEPR(epr);
        ICollectionRanking response = call.select(params);
        if (response != null && response.getRanks() != null) {
            for (ICollectionRank rank : response.getRanks()) {
                if (IExtendedCollectionRank.class.isAssignableFrom(rank.getClass())) {
                    logger.debug((Object)("Collection:" + rank.getCollectionID() + "(" + rank.getScore() + ")" + " fetch:" + ((IExtendedCollectionRank)rank).getResultEstimate() + " results"));
                    continue;
                }
                logger.debug((Object)("Collection:" + rank.getCollectionID() + "(" + rank.getScore() + ")"));
            }
        }
    }
}

