/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.account;

import java.net.URI;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.FormParam;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.gcube.event.publisher.Event;
import org.gcube.keycloak.account.DeleteAccountEvent;
import org.gcube.keycloak.event.OrchestratorEventPublisherProviderFactory;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.RealmsResource;

public class DeleteAccountResource {
    protected static final Logger logger = Logger.getLogger(DeleteAccountResource.class);
    public static final String STATE_CHECKER_ATTRIBUTE = "state_checker";
    public static final String STATE_CHECKER_PARAMETER = "stateChecker";
    private final KeycloakSession session;
    private final AuthenticationManager.AuthResult auth;

    public DeleteAccountResource(KeycloakSession session) {
        logger.info((Object)"Created new DeleteAccountResource object");
        this.session = session;
        this.auth = new AppAuthManager().authenticateIdentityCookie(session, session.getContext().getRealm());
    }

    @NoCache
    @POST
    @Path(value="delete")
    public Response performDeleteAccount(@FormParam(value="stateChecker") String stateChecker) {
        if (this.auth == null) {
            logger.debug((Object)"Invoked DELETE without authorization");
            throw new NotAuthorizedException((Object)"Cookie", new Object[0]);
        }
        String requiredStateChecker = (String)this.session.getAttribute(STATE_CHECKER_ATTRIBUTE, String.class);
        if (!requiredStateChecker.equals(stateChecker)) {
            throw new ForbiddenException("State");
        }
        logger.info((Object)"Invoked perform delete account");
        RealmModel realm = this.auth.getSession().getRealm();
        logger.debug((Object)"Sending delete account event to the orchestrator");
        new OrchestratorEventPublisherProviderFactory().create(this.session).publish((Event)new DeleteAccountEvent(this.auth.getUser(), realm));
        logger.debug((Object)"Forcing logout from all active sessions");
        this.session.sessions().removeUserSessions(realm);
        URI auccountLoginUri = this.session.getContext().getUri().getBaseUriBuilder().path(RealmsResource.class).path("{realm}/account").build(new Object[]{realm.getName()});
        logger.debugf("Finally redirecting to the account form login: %s", (Object)auccountLoginUri);
        return Response.status((int)302).location(auccountLoginUri).build();
    }
}

